/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.gui.chart.BaseTblDataAdapter;
import com.ecmtuning.ecmlink.gui.chart.TblBuilder;
import com.ecmtuning.ecmlink.gui.chart.TblDataAdapter;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.SDRecordModel;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uifextras.util.PopupAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataListener;

public class SDTableAdapter
extends TblDataAdapter {
    final SDRecordModel model;
    Action copyTableAction;
    Action pasteTableAction;
    private static String[] v1StrRpmIndices = new String[]{"0rpm", "500", "1000", "1500", "2000", "2500", "3000", "3500", "4000", "4500", "5000", "5500", "6000", "6500", "7000", "7500", "8000", "8500", "9000", "9500", "10k"};
    private static String[] v2StrRpmIndices = new String[]{"0rpm", "500", "1000", "1500", "2000", "2500", "3000", "3500", "4000", "4500", "5000", "5500", "6000", "6500", "7000", "7500", "8000"};
    private static float[] v1RpmIndices = new float[]{0.0f, 500.0f, 1000.0f, 1500.0f, 2000.0f, 2500.0f, 3000.0f, 3500.0f, 4000.0f, 4500.0f, 5000.0f, 5500.0f, 6000.0f, 6500.0f, 7000.0f, 7500.0f, 8000.0f, 8500.0f, 9000.0f, 9500.0f, 10000.0f};
    private static float[] v2RpmIndices = new float[]{0.0f, 500.0f, 1000.0f, 1500.0f, 2000.0f, 2500.0f, 3000.0f, 3500.0f, 4000.0f, 4500.0f, 5000.0f, 5500.0f, 6000.0f, 6500.0f, 7000.0f, 7500.0f, 8000.0f};
    private static ArrayListModel v1rpmStrList = new ArrayListModel(Arrays.asList(v1StrRpmIndices));
    private static ArrayListModel v2rpmStrList = new ArrayListModel(Arrays.asList(v2StrRpmIndices));
    private static float[] v1PsiaIndices = new float[]{0.0f, 1.837f, 3.674f, 5.511f, 7.348f, 9.185f, 11.022f, 12.859f, 14.696f, 16.533f, 18.37f, 20.207f, 22.044f, 23.881f, 25.718f, 27.555f, 29.392f, 31.229f, 33.066f, 36.74f, 40.414f, 44.088f, 47.762f, 51.436f, 55.11f};
    private static float[] v2PsiaIndices = new float[]{0.0f, 1.837f, 3.674f, 5.511f, 7.348f, 9.185f, 11.022f, 12.859f, 14.696f, 16.533f, 18.37f, 20.207f, 22.044f, 23.881f, 25.718f, 27.555f, 29.392f, 31.229f, 33.066f, 36.74f, 40.414f};
    private static ArrayListModel v1PsiaFloatList = new ArrayListModel(Arrays.asList(ListUtil.convertToFloatArray(v1PsiaIndices)));
    private static ArrayListModel v2PsiaFloatList = new ArrayListModel(Arrays.asList(ListUtil.convertToFloatArray(v2PsiaIndices)));

    public SDTableAdapter(SDRecordModel sDRecordModel) {
        this.model = sDRecordModel;
        super.construct(new String[]{"99999"});
    }

    @Override
    protected Number calculateNextRawValue(Number number, boolean bl) {
        Float8Field float8Field = (Float8Field)this.model.mdlVETable.getSubject();
        return bl ? float8Field.nextStepValue((Float)number) : float8Field.previousStepValue((Float)number);
    }

    @Override
    protected ValueModel createRawColumnHeaderModel() {
        return new ValueHolder((Object)(this.model.isV1SD ? v1rpmStrList : v2rpmStrList));
    }

    @Override
    protected ListModelPlug createStringColumnHeaderModel() {
        ListModelPlug listModelPlug = new ListModelPlug(this.rawColumnHeaderModel, null, true);
        listModelPlug.getLocalArrayListValue().addListDataListener((ListDataListener)new BaseTblDataAdapter.LocalListListener(2));
        return listModelPlug;
    }

    @Override
    protected ValueModel createRawDataModel() {
        return this.model.mdlVETable;
    }

    @Override
    protected ValueModel createRawRowHeaderModel() {
        ListModelPlug listModelPlug = new ListModelPlug((ValueModel)new ValueHolder((Object)(this.model.isV1SD ? v1PsiaFloatList : v2PsiaFloatList)), null);
        UnitsHelper.installFilter(listModelPlug, "typeAbsoluteAirFromPSIA");
        return listModelPlug;
    }

    @Override
    protected int getRowHeaderPrec() {
        return 1;
    }

    @Override
    protected int getColumnHeaderPrec() {
        return 0;
    }

    @Override
    protected int getDataPrec() {
        return 1;
    }

    void createTableActions(TblBuilder tblBuilder) {
        this.copyTableAction = tblBuilder.getDataTable().getCopyAction();
        ECMLinkResources.configureAction(this.copyTableAction, "copyTable");
        this.pasteTableAction = tblBuilder.getDataTable().getPasteAction();
        ECMLinkResources.configureAction(this.pasteTableAction, "pasteTable");
    }

    MouseListener getPopupListener() {
        return new PopupAdapter(true){

            protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                return SDTableAdapter.this.buildPopupMenu();
            }
        };
    }

    private JPopupMenu buildPopupMenu() {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder((String)null);
        popupMenuBuilder.add(this.copyTableAction);
        popupMenuBuilder.add(this.pasteTableAction);
        this.addExtraPopupActions(popupMenuBuilder);
        return popupMenuBuilder.getPopupMenu();
    }

    public static float[] getRPMIndices(SDRecordModel sDRecordModel) {
        return sDRecordModel.isV1SD ? v1RpmIndices : v2RpmIndices;
    }

    public static float[] getPsiaIndices(SDRecordModel sDRecordModel) {
        return sDRecordModel.isV1SD ? v1PsiaIndices : v2PsiaIndices;
    }
}

