/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.ecmlink.ControlUtil;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ReflectionUtils;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.SwingInvokeUtils;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetSubTab;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.ecmtuning.ecmlink.view.main.MainView;
import com.ecmtuning.ecmlink.view.main.ToolBarView;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.builder.ToolBarBuilder;
import foxtrot.Task;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public abstract class SettingsSubTab
extends RecordSetSubTab {
    private JCheckBox cbAutoSave;
    ToggleAction togglePersistedAction;
    protected List toolbarItems = new ArrayList();
    PropertyChangeListener autoSaveDisplayListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                SettingsSubTab.this.cbAutoSave.setVisible(true);
            } else {
                SettingsSubTab.this.cbAutoSave.setVisible(false);
            }
        }
    };
    private PropertyChangeListener autoSaveValueChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl && SettingsSubTab.this.getRecordModel().getAutoSaveEnabled().booleanValue()) {
                MainActions.handleMainFrameTask(SettingsSubTab.this.autoSaveTabToECUTask, false);
            }
        }
    };
    private Task autoSaveTabToECUTask = new Task(){

        public Object run() throws Exception {
            boolean bl = false;
            try {
                SettingsSubTab.this.saveTabToECU();
                bl = true;
            }
            finally {
                if (!bl) {
                    SettingsSubTab.this.getRecordModel().setAutoSaveEnabled(Boolean.FALSE);
                    SettingsSubTab.this.getRecordModel().checkAndSetDirty();
                }
            }
            return null;
        }
    };

    public SettingsSubTab(RecordSet recordSet, SettingsTab settingsTab) {
        super(recordSet, settingsTab);
        this.initialize();
        RecordModel recordModel = this.getRecordModel();
        recordModel.addPropertyChangeListener("showAutoSave", this.autoSaveDisplayListener);
        this.cbAutoSave = BasicComponentFactory.createCheckBox((ValueModel)new PropertyAdapter((Object)recordModel, "autoSaveEnabled", true), (String)"Save changes to ECU as they are made");
        this.cbAutoSave.setToolTipText("Attempts to update the ECU every time a change is made to this tab");
        this.cbAutoSave.setVisible(recordModel.getShowAutoSave());
        recordModel.addPropertyChangeListener("valueChangedByUser", this.autoSaveValueChangeListener);
        recordModel.setShowAutoSave(Boolean.TRUE);
        PropertyAdapter propertyAdapter = new PropertyAdapter((Object)recordModel, "persistedVisibleWithSavedData", true);
        this.togglePersistedAction = ToggleAction.createCheck((ValueModel)propertyAdapter);
        ECMLinkResources.configureAction((Action)this.togglePersistedAction, "toggleReset");
        recordModel.addPropertyChangeListener("dirty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SettingsSubTab.this.togglePersistedAction.setEnabled(SettingsSubTab.this.getRecordModel().hasSavedVolatileData() || SettingsSubTab.this.getRecordModel().getDirty());
            }
        });
        this.togglePersistedAction.setEnabled(false);
    }

    @Override
    public void tabShown() {
        Container container;
        super.tabShown();
        this.initToolbarItems();
        MainView mainView = MainModel.getInstance().getMainView();
        ToolBarView toolBarView = mainView.getToolBarView();
        JToolBar jToolBar = toolBarView.getToolBar();
        for (int i = 0; i < this.toolbarItems.size(); ++i) {
            jToolBar.add((Component)this.toolbarItems.get(i));
        }
        jToolBar.repaint();
        Container container2 = this.getParent();
        if (container2 != null && !container2.hasFocus() && (container = this.getParentTab().getParent()) != null && !container.hasFocus()) {
            SwingInvokeUtils.requestFocusInWindowLater(this.getDefaultFocusComponent());
        }
    }

    @Override
    public void tabHidden() {
        super.tabHidden();
        MainView mainView = MainModel.getInstance().getMainView();
        ToolBarView toolBarView = mainView.getToolBarView();
        JToolBar jToolBar = toolBarView.getToolBar();
        for (int i = this.toolbarItems.size() - 1; i >= 0; --i) {
            jToolBar.remove((Component)this.toolbarItems.get(i));
        }
        jToolBar.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initToolbarItems() {
        if (this.toolbarItems.size() == 0) {
            List list = this.toolbarItems;
            synchronized (list) {
                if (this.toolbarItems.size() == 0) {
                    ToolBarBuilder toolBarBuilder = new ToolBarBuilder();
                    this.toolbarItems.add(DialogUtil.createToolbarSeparator());
                    this.toolbarItems.add(toolBarBuilder.addToggle(this.togglePersistedAction));
                }
            }
        }
    }

    public Component getDefaultFocusComponent() {
        Object object;
        if (this.localView != null && (object = ReflectionUtils.invokeMethodIfThere(this.localView, "getDefaultFocusComponent")) != null && object instanceof Component) {
            return (Component)object;
        }
        return null;
    }

    @Override
    Border getSubTabBorder() {
        return Borders.DIALOG_BORDER;
    }

    @Override
    void deregisterTab() {
        this.getRecordModel().removePropertyChangeListener("showAutoSave", this.autoSaveDisplayListener);
        this.getRecordModel().removePropertyChangeListener("valueChangedByUser", this.autoSaveValueChangeListener);
        super.deregisterTab();
    }

    @Override
    void saveTabToECU() throws IOException, DeviceException {
        ECMLinkDeviceManager eCMLinkDeviceManager = ControlUtil.findCompatibleActiveManager(this.getRecordSet().getDeviceId());
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet = eCMLinkDeviceManager.getConfigRecordSet();
        Map map = eCMLinkConfigRecordSet.getPersistentRecordMapCopy();
        if (!this.isCompatibleWith(map)) {
            JOptionPane.showMessageDialog(this, "This tab contains some data that is not compatible with\nthe current ECU.", "Incompatible data", 0);
            return;
        }
        this.applyVolatileModel(map);
        if (map.equals(eCMLinkConfigRecordSet.getPersistentRecordMapCopy())) {
            int n = JOptionPane.showOptionDialog(this, "Data on this tab already matches ECU data.\nDo a save all?", "Empty save operation", 0, 3, null, null, null);
            if (n == 0) {
                this.getParentTab().getSaveAllAction().actionPerformed(null);
                return;
            }
            return;
        }
        eCMLinkDeviceManager.sendUpdatedConfigRecords(map);
        if (!this.getParentTab().isLiveView()) {
            Map map2 = eCMLinkConfigRecordSet.getVolatileRecordMap();
            this.applyVolatileModel(map2);
        }
    }

    @Override
    JComponent getCustomButtonBarComponent() {
        return this.cbAutoSave;
    }
}

