/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.control.ecmlink.ControlUtil;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.DatalogFile;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSetFile;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSetFile;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.util.ui.TrackedTabbedPane;
import com.ecmtuning.ecmlink.view.ecmlink.ALSKnockTab;
import com.ecmtuning.ecmlink.view.ecmlink.AuxV1Tab;
import com.ecmtuning.ecmlink.view.ecmlink.DTC1GTab;
import com.ecmtuning.ecmlink.view.ecmlink.DTC2GTab;
import com.ecmtuning.ecmlink.view.ecmlink.DTCE3Tab;
import com.ecmtuning.ecmlink.view.ecmlink.DashTab;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIOTab;
import com.ecmtuning.ecmlink.view.ecmlink.EGRV1V2Tab;
import com.ecmtuning.ecmlink.view.ecmlink.FPSV1V2Tab;
import com.ecmtuning.ecmlink.view.ecmlink.FPSV3V4Tab;
import com.ecmtuning.ecmlink.view.ecmlink.FuelTab;
import com.ecmtuning.ecmlink.view.ecmlink.IdleAirClampTab;
import com.ecmtuning.ecmlink.view.ecmlink.MAFClampTab;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV2Tab;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3Tab;
import com.ecmtuning.ecmlink.view.ecmlink.MiscTab;
import com.ecmtuning.ecmlink.view.ecmlink.NBO2SimTab;
import com.ecmtuning.ecmlink.view.ecmlink.RPMTPSTab;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetSubTab;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetTab;
import com.ecmtuning.ecmlink.view.ecmlink.SDTab;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsSubTab;
import com.ecmtuning.ecmlink.view.ecmlink.TimingTab;
import com.ecmtuning.ecmlink.view.ecmlink.WGSTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SettingsTab
extends RecordSetTab {
    TrackedTabbedPane tabPane;
    private static final Logger logger = Logger.getLogger(SettingsTab.class.getName());
    static final String METHODNAME_CAN_DISPLAY = "canDisplay";
    static final Class[] METHODPARMS_CAN_DISPLAY = new Class[]{Map.class};
    static final Class[] CONSTRUCTORPARMS = new Class[]{RecordSet.class, SettingsTab.class};
    static final Class[] supportedPanels = new Class[]{RPMTPSTab.class, FuelTab.class, TimingTab.class, MAFV3Tab.class, MAFV2Tab.class, MAFClampTab.class, SDTab.class, AuxV1Tab.class, IdleAirClampTab.class, NBO2SimTab.class, ALSKnockTab.class, FPSV1V2Tab.class, FPSV3V4Tab.class, EGRV1V2Tab.class, WGSTab.class, DashTab.class, MiscTab.class, DTC1GTab.class, DTC2GTab.class, DTCE3Tab.class, ECUIOTab.class};

    public SettingsTab(RecordSet recordSet, DatalogFile datalogFile) {
        super(recordSet, datalogFile);
        this.initialize(datalogFile == null);
    }

    public SettingsTab(RecordSetFile recordSetFile) {
        super(recordSetFile);
        this.initialize(false);
    }

    public SettingsTab(RecordSet recordSet) {
        super(recordSet);
        this.initialize(false);
    }

    @Override
    public void tabShown() {
        super.tabShown();
        Component component = this.tabPane.getSelectedComponent();
        if (component != null && component instanceof SettingsSubTab) {
            ((SettingsSubTab)component).tabShown();
        }
    }

    @Override
    public void tabHidden() {
        super.tabHidden();
        Component component = this.tabPane.getSelectedComponent();
        if (component != null && component instanceof SettingsSubTab) {
            ((SettingsSubTab)component).tabHidden();
        }
    }

    @Override
    String getResourcePrefix() {
        return "settingsTab";
    }

    @Override
    protected RecordSetSubTab[] build() {
        this.setLayout(new BorderLayout());
        this.tabPane = new TrackedTabbedPane(2);
        RecordSetSubTab[] recordSetSubTabArray = this.createSupportedTabViews(this.getManagedRecordSet());
        for (int i = 0; i < recordSetSubTabArray.length; ++i) {
            this.tabPane.addSelectedTab(recordSetSubTabArray[i], i == 0);
        }
        this.add((Component)this.tabPane, "Center");
        return recordSetSubTabArray;
    }

    public Action createTabAction(Class clazz) {
        return new TabAction(clazz);
    }

    public Component bringTabForward(Class clazz) {
        int n = this.tabPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (this.tabPane.getComponentAt(i).getClass() != clazz) continue;
            this.tabPane.setSelectedIndex(i);
            return this.tabPane.getComponentAt(i);
        }
        return null;
    }

    @Override
    protected File createDefaultFile(FilenameModel filenameModel) {
        return filenameModel.createNewDeviceSettingsFile();
    }

    @Override
    protected FileFilter getRecordSetFileFilter() {
        return FilenameModel.getDeviceSettingsFileFilter();
    }

    @Override
    protected String getFileExtension() {
        return "ecm";
    }

    @Override
    protected void saveAllRecordsToECU() throws IOException, DeviceException {
        ECMLinkDeviceManager eCMLinkDeviceManager = ControlUtil.findCompatibleActiveManager(this.getManagedRecordSet().getDeviceId());
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet = eCMLinkDeviceManager.getConfigRecordSet();
        Map map = eCMLinkConfigRecordSet.getPersistentRecordMapCopy();
        RecordSetSubTab[] recordSetSubTabArray = this.getSubTabs();
        for (int i = 0; i < recordSetSubTabArray.length; ++i) {
            if (!recordSetSubTabArray[i].isCompatibleWith(map)) {
                JOptionPane.showMessageDialog(this, "SaveAll is not possible because some data in this collection\nis incompatible with the current ECU.  Try to save each tab\none at a time instead.", "Incompatible data", 0);
                return;
            }
            recordSetSubTabArray[i].applyVolatileModel(map);
        }
        eCMLinkDeviceManager.sendUpdatedConfigRecords(map);
        if (!this.isLiveView()) {
            Map map2 = eCMLinkConfigRecordSet.getVolatileRecordMap();
            for (int i = 0; i < recordSetSubTabArray.length; ++i) {
                recordSetSubTabArray[i].applyVolatileModel(map2);
            }
        }
    }

    @Override
    protected RecordSetFile createRecordSetFile(File file) {
        return new ECMLinkConfigRecordSetFile(this.getManagedRecordSet(), file);
    }

    RecordSetSubTab[] createSupportedTabViews(RecordSet recordSet) {
        ArrayList arrayList = new ArrayList();
        Map map = recordSet.getPersistentRecordMap();
        for (int i = 0; i < supportedPanels.length; ++i) {
            Class clazz = supportedPanels[i];
            try {
                Method method = clazz.getMethod(METHODNAME_CAN_DISPLAY, METHODPARMS_CAN_DISPLAY);
                Boolean bl = (Boolean)method.invoke(null, map);
                if (!bl.booleanValue()) continue;
                Constructor constructor = clazz.getConstructor(CONSTRUCTORPARMS);
                arrayList.add(constructor.newInstance(recordSet, this));
                continue;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Failed to load view", exception);
            }
        }
        RecordSetSubTab[] recordSetSubTabArray = new RecordSetSubTab[arrayList.size()];
        arrayList.toArray(recordSetSubTabArray);
        return recordSetSubTabArray;
    }

    class TabAction
    extends AbstractAction {
        final Class tabClass;

        TabAction(Class clazz) {
            this.tabClass = clazz;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SettingsTab.this.bringTabForward(this.tabClass);
        }
    }
}

