/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.DisplaySetListener;
import com.ecmtuning.ecmlink.device.data.TimeSelectionListener;
import com.ecmtuning.ecmlink.device.data.TimeSelectionModel;
import com.ecmtuning.ecmlink.util.ListUtil;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class TableSelectionDataAdapter {
    final float[] columnValues;
    final int maxColumn;
    final float[] rowValues;
    final int maxRow;
    final ListSelectionModel rowSelectionModel;
    final ListSelectionModel colSelectionModel;
    DisplaySet displaySet;
    TimeSelectionModel timeModel;
    final TimeSelectionListener timeListener = new TimeSelectionListener(){

        @Override
        public void selectionChanged(double d, double d2) {
            TableSelectionDataAdapter.this.updateSelection();
        }
    };
    final DisplaySetListener displaySetListener = new DisplaySetListener(){

        @Override
        public void displayChainsOrValuesChanged() {
        }

        @Override
        public void displayReset() {
        }

        @Override
        public void displayTimeChanged() {
        }

        @Override
        public void displayValuesAdded() {
        }
    };

    public TableSelectionDataAdapter(JTable jTable, float[] fArray, float[] fArray2) {
        this.rowSelectionModel = jTable.getSelectionModel();
        this.colSelectionModel = jTable.getColumnModel().getSelectionModel();
        this.columnValues = fArray;
        this.rowValues = fArray2;
        this.maxColumn = fArray.length - 1;
        this.maxRow = fArray2.length - 1;
    }

    public synchronized void registerModels(DisplaySet displaySet, TimeSelectionModel timeSelectionModel) {
        this.deregisterModels();
        this.displaySet = displaySet;
        this.timeModel = timeSelectionModel;
        displaySet.addDisplaySetListener(this.displaySetListener);
        timeSelectionModel.addTimeSelectionListener(this.timeListener);
        this.updateSelection();
    }

    public synchronized void deregisterModels() {
        if (this.timeModel != null) {
            this.timeModel.removeTimeSelectionListener(this.timeListener);
        }
        if (this.displaySet != null) {
            this.displaySet.removeDisplaySetListener(this.displaySetListener);
            this.displaySet.deregisterModels();
        }
        this.timeModel = null;
        this.displaySet = null;
    }

    final void updateSelection() {
        if (this.timeModel.isSelectionActive()) {
            double d = this.timeModel.getAnchorTime();
            float[] fArray = this.displaySet.getMostRecentData(d);
            if (fArray == null || fArray.length != 2 || fArray[0] == Float.MIN_VALUE || fArray[1] == Float.MIN_VALUE) {
                return;
            }
            float f = fArray[0];
            float f2 = fArray[1];
            int n = ListUtil.findClosestIndex(f, this.columnValues);
            int n2 = ListUtil.findClosestIndex(f2, this.rowValues);
            float f3 = this.columnValues[n];
            float f4 = this.rowValues[n2];
            int n3 = n;
            int n4 = n2;
            if (n > 0 && f < f3 * 3.0f / 5.0f + this.columnValues[n - 1] * 2.0f / 5.0f) {
                --n;
            } else if (n < this.maxColumn && f > f3 * 3.0f / 5.0f + this.columnValues[n + 1] * 2.0f / 5.0f) {
                ++n3;
            }
            if (n2 > 0 && f2 < f4 * 3.0f / 5.0f + this.rowValues[n2 - 1] * 2.0f / 5.0f) {
                --n2;
            } else if (n2 < this.maxRow && f2 > f4 * 3.0f / 5.0f + this.rowValues[n2 + 1] * 2.0f / 5.0f) {
                ++n4;
            }
            this.colSelectionModel.setSelectionInterval(n, n3);
            this.rowSelectionModel.setSelectionInterval(n2, n4);
        }
    }
}

