/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.gui.chart.ChtTblBuilder;
import com.ecmtuning.ecmlink.gui.chart.ChtTblDataAdapter;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.InterpListValuesAction;
import com.ecmtuning.ecmlink.util.ui.ScaleListValuesAction;
import com.ecmtuning.ecmlink.util.ui.SetListValuesAction;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.MAFClampDataAdapter;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uifextras.util.PopupAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public final class TimingDataAdapter
extends ChtTblDataAdapter {
    final ListModelPlug mdlTimingTbl;
    final boolean isRPMShifted;
    Action zeroAction;
    Action copyTableAction;
    Action pasteTableAction;

    public TimingDataAdapter(ListModelPlug listModelPlug, boolean bl) {
        this.mdlTimingTbl = listModelPlug;
        this.isRPMShifted = bl;
        super.construct("99999");
        this.createLocalActions();
    }

    @Override
    protected ValueModel createRowHeaderColumnHeaderModel() {
        return new ValueHolder((Object)"RPM");
    }

    @Override
    protected ValueModel createDataColumnHeaderModel() {
        return new ValueHolder((Object)"Adj (\u00b0)");
    }

    @Override
    protected ValueModel createRawDataModel() {
        return this.mdlTimingTbl;
    }

    @Override
    protected ValueModel createRawRowHeaderModel() {
        return new ValueHolder((Object)this.getXIndicesAsListModel());
    }

    @Override
    protected Number calculateNextRawValue(Number number, boolean bl) {
        Float8Field float8Field = (Float8Field)this.mdlTimingTbl.getSubject();
        return bl ? float8Field.nextStepValue((Float)number) : float8Field.previousStepValue((Float)number);
    }

    ArrayListModel getXIndicesAsListModel() {
        return this.isRPMShifted ? MAFClampDataAdapter.xFloatListShifted : MAFClampDataAdapter.xFloatList;
    }

    float[] getXIndicesAsFloatArray() {
        return this.isRPMShifted ? MAFClampDataAdapter.xIndicesShifted : MAFClampDataAdapter.xIndices;
    }

    MouseListener getPopupListener(final HandyJTable handyJTable) {
        return new PopupAdapter(true){

            protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                return TimingDataAdapter.this.buildPopupMenu(handyJTable);
            }
        };
    }

    private JPopupMenu buildPopupMenu(HandyJTable handyJTable) {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder((String)null);
        popupMenuBuilder.add(this.copyTableAction);
        popupMenuBuilder.add(this.pasteTableAction);
        popupMenuBuilder.addSeparator();
        AbstractAction abstractAction = new InterpListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "interpTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        abstractAction = new SetListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "setTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        abstractAction = new ScaleListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "scaleTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        popupMenuBuilder.add(this.zeroAction);
        return popupMenuBuilder.getPopupMenu();
    }

    private void createLocalActions() {
        this.zeroAction = new DispatchingAction("zeroAdjustments");
        ECMLinkResources.configureAction(this.zeroAction, "zeroAdjustments");
    }

    void createTableActions(ChtTblBuilder chtTblBuilder) {
        this.copyTableAction = chtTblBuilder.getDataTable().getCopyAction();
        ECMLinkResources.configureAction(this.copyTableAction, "copyTable");
        this.pasteTableAction = chtTblBuilder.getDataTable().getPasteAction();
        ECMLinkResources.configureAction(this.pasteTableAction, "pasteTable");
    }

    private class DispatchingAction
    extends AbstractAction {
        private final String id;

        DispatchingAction(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id == "zeroAdjustments") {
                List list = (List)TimingDataAdapter.this.rawDataModel.getValue();
                Collections.fill(list, new Float(0.0f));
            }
        }
    }
}

