/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.gui.chart.Chart;
import com.ecmtuning.ecmlink.gui.chart.ChtTblBuilder;
import com.ecmtuning.ecmlink.gui.chart.ChtTblDataAdapter;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.view.ecmlink.TimingDataAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.TimingRecordModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uif.AbstractView;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;

public class TimingRecordView
extends AbstractView {
    private TimingDataAdapter dataAdapter;
    private ChtTblBuilder chtTblBuilder;
    private final TimingRecordModel model;

    public TimingRecordView(TimingRecordModel timingRecordModel) {
        this.model = timingRecordModel;
    }

    public void resetViewport() {
        this.chtTblBuilder.getChart().resetViewport();
    }

    public Component getDefaultFocusComponent() {
        return this.chtTblBuilder.getChart();
    }

    private void initComponents() {
        this.dataAdapter = new TimingDataAdapter(this.model.mdlTimingTbl, this.model.isRPMShifted);
        this.chtTblBuilder = new ChtTblBuilder(this.dataAdapter);
        this.dataAdapter.createTableActions(this.chtTblBuilder);
        this.initTable();
        this.initChart();
    }

    private void initChart() {
        Chart chart = this.chtTblBuilder.getChart();
        FloatRect floatRect = new FloatRect();
        float f = this.model.isRPMShifted ? 2000.0f : 0.0f;
        floatRect.setCorners(-400.0f + f, -17.0f, 8400.0f + f, 16.0f);
        this.dataAdapter.setMaxViewportForDisplayType(ChtTblDataAdapter.DEFAULT_DISPLAY_TYPE, floatRect);
        FloatRect floatRect2 = new FloatRect(0.0f, 0.0f, 500.0f, 1.0f);
        this.dataAdapter.setGridForDisplayType(ChtTblDataAdapter.DEFAULT_DISPLAY_TYPE, floatRect2);
        chart.setXAxisLoc(0.0f + f);
        chart.setYAxisLoc(0.0f);
        this.chtTblBuilder.setStandardPlotDescs();
        this.chtTblBuilder.resetViewport();
        this.chtTblBuilder.addDefaultValueChangeActions(chart, false);
        chart.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
    }

    private void initTable() {
        HandyJTable handyJTable = this.chtTblBuilder.getDataTable();
        this.chtTblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        handyJTable.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.FILL_PREF_GROW_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), rowSpec4);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Timing Adjustments Table", cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.chtTblBuilder.getPanel(), cellConstraints.xy(2, 3));
        return panelBuilder.getPanel();
    }
}

