/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.AirPressureFilter;
import com.ecmtuning.ecmlink.model.UnitsFilter;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WGSRecordModel
extends RecordModel {
    ValueModel mdlEnable;
    ValueModel mdlLockInFirst;
    ValueModel mdlDisableErrCorr;
    ValueModel mdlUseSpeed;
    ValueModelPlug mdlZeroPntPsia;
    ValueModelPlug mdlFullPntPsia;
    ListModelPlug mdlTargetPsia;
    ListModelPlug mdlBaseDC;
    public List volatileTargetPsiaList;
    public List volatileBaseDCList;
    public List persistedTargetPsiaList;
    public List persistedBaseDCList;
    public ValueModel persistedZeroPntPsia;
    public ValueModel persistedFullPntPsia;
    public ValueModel mdlPersistedMAPInputX;
    public ValueModel mdlPersistedMAPSelect;
    final AirPressureFilter airPressureValueFilter;
    boolean doingConstruction = false;
    ArrayList plugsToReset = new ArrayList();

    WGSRecordModel(RecordSet recordSet) {
        UnitsFilter unitsFilter = UnitsHelper.getConversionValueFilter("typeAirPressureFromPSIA");
        this.airPressureValueFilter = ((AirPressureFilter)unitsFilter).createNewInstance();
        this.airPressureValueFilter.setAltitudeFt(ConverterPrefs.getAltitudeFeet(DataPreferences.getConverterPreferences()));
        this.doingConstruction = true;
        try {
            this.initialize(recordSet);
        }
        finally {
            this.doingConstruction = false;
        }
        Map map = recordSet.getPersistentRecordMap();
        BaseRecord baseRecord = RecordSet.getRecord(44, map);
        this.mdlPersistedMAPInputX = baseRecord.getFeaturePlug("mapInputX");
        this.mdlPersistedMAPSelect = baseRecord.getFeaturePlug("mapSelectFeature");
        BaseRecord baseRecord2 = RecordSet.getRecord(50, map);
        this.persistedTargetPsiaList = (ArrayList)baseRecord2.numberListField("WGSTarget").getValue();
        this.volatileTargetPsiaList = this.mdlTargetPsia.getLocalArrayListValue();
        this.persistedBaseDCList = (ArrayList)baseRecord2.numberListField("WGSBase").getValue();
        this.volatileBaseDCList = this.mdlBaseDC.getLocalArrayListValue();
        this.persistedZeroPntPsia = baseRecord2.getField("WGSZeroPnt");
        this.persistedFullPntPsia = baseRecord2.getField("WGSFullPnt");
    }

    @Override
    public void deregisterModel() {
        super.deregisterModel();
        ((ValueModelPlug)this.mdlPersistedMAPInputX).unplug();
        ((ValueModelPlug)this.mdlPersistedMAPSelect).unplug();
    }

    void resetPlugs() {
        Iterator iterator = this.plugsToReset.iterator();
        while (iterator.hasNext()) {
            ((ValueModelPlug)iterator.next()).resetLocalValue();
        }
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(50, map);
        this.mdlEnable = this.track(this.mdlEnable, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("WGSCtl", 128));
        this.mdlLockInFirst = this.track(this.mdlLockInFirst, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("WGSCtl", 64));
        this.mdlDisableErrCorr = this.track(this.mdlDisableErrCorr, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("WGSCtl", 16));
        this.mdlUseSpeed = this.track(this.mdlUseSpeed, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("WGSCtl", 32));
        ValueModelPlug valueModelPlug = baseRecord.numberFieldAsString("WGSZeroPnt", 2);
        UnitsHelper.installFilter(valueModelPlug, this.airPressureValueFilter, "typeAirPressureFromPSIA");
        this.mdlZeroPntPsia = this.track(this.mdlZeroPntPsia, valueModelPlug);
        if (this.doingConstruction) {
            this.plugsToReset.add(valueModelPlug);
        }
        valueModelPlug = baseRecord.numberFieldAsString("WGSFullPnt", 2);
        UnitsHelper.installFilter(valueModelPlug, this.airPressureValueFilter, "typeAirPressureFromPSIA");
        this.mdlFullPntPsia = this.track(this.mdlFullPntPsia, valueModelPlug);
        if (this.doingConstruction) {
            this.plugsToReset.add(valueModelPlug);
        }
        this.mdlTargetPsia = this.track(this.mdlTargetPsia, baseRecord.numberListField("WGSTarget"));
        this.mdlBaseDC = this.track(this.mdlBaseDC, baseRecord.numberListField("WGSBase"));
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsRecordId(50, map);
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        return WGSRecordModel.canDisplay(map);
    }
}

