/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.DataPreferencesAdapter;
import com.ecmtuning.ecmlink.device.records.ColorMapEntry;
import com.ecmtuning.ecmlink.gui.chart.TblBuilder;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.Number2NumberFilter;
import com.ecmtuning.ecmlink.util.model.Number2StringFilter;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.ScaleTableValuesAction;
import com.ecmtuning.ecmlink.util.ui.SetTableValuesAction;
import com.ecmtuning.ecmlink.view.ecmlink.AbstractRecordView;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIOTab;
import com.ecmtuning.ecmlink.view.ecmlink.NumberStringCellRenderer;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.ecmtuning.ecmlink.view.ecmlink.WGSBaseTableAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.WGSRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.WGSTab;
import com.ecmtuning.ecmlink.view.ecmlink.WGSTargetTableAdapter;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uifextras.util.ActionLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;

public class WGSRecordView
extends AbstractRecordView {
    JCheckBox cbWGSEnable;
    JCheckBox cbWGSLockInFirst;
    JCheckBox cbWGSDisableErrCorr;
    JCheckBox cbUseSpeed;
    private JSpinner spnrZeroPnt;
    private JSpinner spnrFullPnt;
    private JLabel lblZeroPnt;
    private JLabel lblFullPnt;
    private JLabel lblZeroPntUnits;
    private JLabel lblFullPntUnits;
    ActionLabel inputsTabActionLabel;
    private final WGSRecordModel model;
    private final SettingsTab parentTab;
    private final WGSTab parentSubTab;
    private WGSTargetTableAdapter wgsTargetTableAdapter;
    private TblBuilder targetTblBuilder;
    private WGSBaseTableAdapter wgsBaseTableAdapter;
    private TblBuilder baseTblBuilder;
    JTextField tfAltitude;
    JLabel lblAltitudeUnits;
    JButton btnAltitudeSet;
    ValueModel rawAltitudeFeetModel = new DataPreferencesAdapter(DataPreferences.getConverterPreferences(), "altitude", new Float(0.0f));
    Trigger altitudeTrigger = new Trigger();
    BufferedValueModel bufferedAltitudeModel = new BufferedValueModel(this.rawAltitudeFeetModel, (ValueModel)this.altitudeTrigger);
    ValueModelPlug filteredAltitudeModel = new ValueModelPlug((ValueModel)this.bufferedAltitudeModel, null);
    PreferenceChangeListener altitudeChangeListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if ("altitude".equals(preferenceChangeEvent.getKey())) {
                WGSRecordView.this.triggerAltitudeFlush();
                ((WGSRecordView)WGSRecordView.this).model.airPressureValueFilter.setAltitudeFt(ConverterPrefs.getAltitudeFeet(DataPreferences.getConverterPreferences()));
                WGSRecordView.this.wgsTargetTableAdapter.resetLocalValue();
                WGSRecordView.this.model.resetPlugs();
            }
        }
    };
    ColorMapEntry[] targetColorMap = new ColorMapEntry[]{new ColorMapEntry(0.0f, 0xFFFFFF), new ColorMapEntry(100.0f, 0xFFFFFF)};
    ColorMapEntry[] baseColorMap = new ColorMapEntry[]{new ColorMapEntry(0.0f, 0xFFFFFF), new ColorMapEntry(1.0f, 0xFFFFFF)};
    ValueHolder mapEnabledHolder = new ValueHolder(false);
    ValueHolder mainEnabledHolder = new ValueHolder(false);

    public WGSRecordView(WGSRecordModel wGSRecordModel, SettingsTab settingsTab, WGSTab wGSTab) {
        this.model = wGSRecordModel;
        this.parentTab = settingsTab;
        this.parentSubTab = wGSTab;
        DataPreferences.getConverterPreferences().addPreferenceChangeListener(this.altitudeChangeListener);
    }

    void deregisterView() {
        DataPreferences.getConverterPreferences().removePreferenceChangeListener(this.altitudeChangeListener);
    }

    private void initComponents() {
        this.cbWGSEnable = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlEnable, (String)"Enable boost control");
        this.cbWGSEnable.setToolTipText("Enabled boost control logic on wastegate solenoid output");
        this.cbWGSLockInFirst = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlLockInFirst, (String)"Use 1st gear only");
        this.cbWGSLockInFirst.setToolTipText("Locks operation in 1st gear; i.e., only the first row will be used");
        this.cbWGSDisableErrCorr = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlDisableErrCorr, (String)"Disable error correction");
        this.cbWGSDisableErrCorr.setToolTipText("Disables error correction logic.  Uses base duty cycle values without modification.");
        this.cbUseSpeed = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlUseSpeed, (String)"Use LatestSpeed for gear selection");
        this.cbUseSpeed.setToolTipText("Forces the ECU to use LatestSpeed for gear selection instead of gear ratio");
        this.wgsTargetTableAdapter = new WGSTargetTableAdapter(this.model);
        this.wgsBaseTableAdapter = new WGSBaseTableAdapter(this.model);
        this.targetTblBuilder = new TblBuilder(this.wgsTargetTableAdapter);
        this.baseTblBuilder = new TblBuilder(this.wgsBaseTableAdapter);
        this.wgsTargetTableAdapter.createTableActions(this.targetTblBuilder);
        this.wgsBaseTableAdapter.createTableActions(this.baseTblBuilder);
        this.initTargetTable();
        this.initBaseTable();
        this.lblZeroPnt = new JLabel("Lock at 0% below:");
        this.lblZeroPntUnits = UnitsHelper.createJLabel("typeAirPressureFromPSIA");
        this.spnrZeroPnt = DialogUtil.createSpinnerTextField(this.model.mdlZeroPntPsia, "Manifold absolute pressure");
        this.lblFullPnt = new JLabel("And then 100% below:");
        this.lblFullPntUnits = UnitsHelper.createJLabel("typeAirPressureFromPSIA");
        this.spnrFullPnt = DialogUtil.createSpinnerTextField(this.model.mdlFullPntPsia, "Manifold absolute pressure");
        DialogUtil.installComponentEnabler((ValueModel)this.mainEnabledHolder, new Component[]{this.cbUseSpeed, this.cbWGSLockInFirst, this.cbWGSDisableErrCorr});
        DialogUtil.installComponentEnabler((ValueModel)this.mapEnabledHolder, new Component[]{this.lblZeroPnt, this.spnrZeroPnt, this.lblZeroPntUnits, this.lblFullPnt, this.spnrFullPnt, this.lblFullPntUnits});
        Action action = this.parentTab.createTabAction(ECUIOTab.class);
        this.inputsTabActionLabel = new ActionLabel(action);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WGSRecordView.this.updateEnabledValue();
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WGSRecordView.this.updateEnabledValue();
            }
        };
        this.model.mdlPersistedMAPInputX.addValueChangeListener(propertyChangeListener);
        this.model.mdlPersistedMAPSelect.addValueChangeListener(propertyChangeListener);
        this.cbWGSEnable.addChangeListener(changeListener);
        this.updateEnabledValue();
        UnitsHelper.installFilter(this.filteredAltitudeModel, "typeDistanceFromFeet");
        this.filteredAltitudeModel.addObjectFilter(0, new Number2NumberFilter(-500.0f, 20000.0f));
        this.filteredAltitudeModel.addObjectFilter(new Number2StringFilter(0));
        this.tfAltitude = DialogUtil.createTextField(this.filteredAltitudeModel, "Current altitude for estimation of atmospheric pressure");
        this.lblAltitudeUnits = UnitsHelper.createJLabel("typeDistanceFromFeet");
        this.btnAltitudeSet = new JButton("Save altitude");
        this.btnAltitudeSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WGSRecordView.this.triggerAltitudeCommit();
            }
        });
    }

    protected final void triggerAltitudeCommit() {
        if (Boolean.TRUE.equals(this.altitudeTrigger.getValue())) {
            this.altitudeTrigger.setValue(null);
        }
        this.altitudeTrigger.setValue((Object)Boolean.TRUE);
    }

    protected final void triggerAltitudeFlush() {
        if (Boolean.FALSE.equals(this.altitudeTrigger.getValue())) {
            this.altitudeTrigger.setValue(null);
        }
        this.altitudeTrigger.setValue((Object)Boolean.FALSE);
    }

    private void initTargetTable() {
        HandyJTable handyJTable = this.targetTblBuilder.getDataTable();
        this.targetTblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        TableCellRenderer tableCellRenderer = ((JTable)((Object)handyJTable)).getDefaultRenderer(String.class);
        NumberStringCellRenderer numberStringCellRenderer = new NumberStringCellRenderer(tableCellRenderer, this.targetColorMap, this.model.volatileTargetPsiaList, this.model.persistedTargetPsiaList, WGSTargetTableAdapter.rpmStrList.getSize());
        ((JTable)((Object)handyJTable)).setDefaultRenderer(String.class, numberStringCellRenderer);
        this.wgsTargetTableAdapter.addPopupAction(this.parentSubTab.getResetTabAction());
        this.wgsTargetTableAdapter.addPopupAction(this.parentSubTab.getSaveTabAction());
        this.wgsTargetTableAdapter.addPopupAction(null);
        AbstractAction abstractAction = new SetTableValuesAction((JTable)((Object)handyJTable), "0");
        ECMLinkResources.configureAction(abstractAction, "zeroAllValues");
        this.wgsTargetTableAdapter.addPopupAction(abstractAction);
        abstractAction = new SetTableValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "setTableValues");
        this.wgsTargetTableAdapter.addPopupAction(abstractAction);
        abstractAction = new ScaleTableValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "scaleTableValues");
        this.wgsBaseTableAdapter.addPopupAction(abstractAction);
        ((Component)((Object)handyJTable)).addMouseListener(this.wgsTargetTableAdapter.getPopupListener());
    }

    private void initBaseTable() {
        HandyJTable handyJTable = this.baseTblBuilder.getDataTable();
        this.baseTblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        TableCellRenderer tableCellRenderer = ((JTable)((Object)handyJTable)).getDefaultRenderer(String.class);
        NumberStringCellRenderer numberStringCellRenderer = new NumberStringCellRenderer(tableCellRenderer, this.baseColorMap, this.model.volatileBaseDCList, this.model.persistedBaseDCList, WGSTargetTableAdapter.rpmStrList.getSize());
        ((JTable)((Object)handyJTable)).setDefaultRenderer(String.class, numberStringCellRenderer);
        this.wgsBaseTableAdapter.addPopupAction(this.parentSubTab.getResetTabAction());
        this.wgsBaseTableAdapter.addPopupAction(this.parentSubTab.getSaveTabAction());
        this.wgsBaseTableAdapter.addPopupAction(null);
        AbstractAction abstractAction = new SetTableValuesAction((JTable)((Object)handyJTable), "0");
        ECMLinkResources.configureAction(abstractAction, "zeroAllValues");
        this.wgsBaseTableAdapter.addPopupAction(abstractAction);
        abstractAction = new SetTableValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "setTableValues");
        this.wgsBaseTableAdapter.addPopupAction(abstractAction);
        abstractAction = new ScaleTableValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "scaleTableValues");
        this.wgsBaseTableAdapter.addPopupAction(abstractAction);
        ((Component)((Object)handyJTable)).addMouseListener(this.wgsBaseTableAdapter.getPopupListener());
    }

    void updateEnabledValue() {
        boolean bl = ((Number)this.model.mdlPersistedMAPInputX.getValue()).intValue() != 0;
        boolean bl2 = ((Number)this.model.mdlPersistedMAPSelect.getValue()).intValue() != 0;
        boolean bl3 = bl && bl2;
        this.mapEnabledHolder.setValue(this.cbWGSEnable.isSelected() && bl3);
        this.mainEnabledHolder.setValue(this.cbWGSEnable.isSelected());
        if (!bl || !bl2) {
            this.inputsTabActionLabel.setForeground(Color.RED);
            String string = "";
            string = !bl && !bl2 ? "input pin & type" : (!bl ? "input pin" : "sensor type");
            this.inputsTabActionLabel.setText("Assign MAP " + string + "\u2026");
        } else {
            this.inputsTabActionLabel.setForeground(Color.BLUE);
            this.inputsTabActionLabel.setText("Edit MAP input pin & type\u2026");
        }
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_GROW_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("\"Boost\" Target (based on absolute pressure)");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(DialogUtil.FILL_PREF_NOGROW_ROWSPEC, interCompGap);
        JScrollPane jScrollPane = this.targetTblBuilder.getDataTableWithScrollPane();
        HandyJTable handyJTable = this.targetTblBuilder.getDataTable();
        handyJTable.setScrollPane(jScrollPane);
        handyJTable.setUsePreferredSizeAsScrollSize(true);
        jScrollPane.setVerticalScrollBarPolicy(21);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), panelBuilder.getColumnCount() - 1));
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interSectGap);
        panelBuilder.addLabel("Altitude:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.tfAltitude);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.lblAltitudeUnits);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.btnAltitudeSet);
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("Base Duty Cycle");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(DialogUtil.FILL_PREF_NOGROW_ROWSPEC, interSectGap);
        jScrollPane = this.baseTblBuilder.getDataTableWithScrollPane();
        handyJTable = this.baseTblBuilder.getDataTable();
        handyJTable.setScrollPane(jScrollPane);
        handyJTable.setUsePreferredSizeAsScrollSize(true);
        jScrollPane.setVerticalScrollBarPolicy(21);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), panelBuilder.getColumnCount() - 1));
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("Options");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.cbWGSEnable, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), 3));
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.cbWGSLockInFirst, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), 3));
        panelBuilder.nextColumn(4);
        panelBuilder.add((Component)this.cbUseSpeed, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), 3));
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.cbWGSDisableErrCorr, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), 3));
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.inputsTabActionLabel);
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.lblZeroPnt);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrZeroPnt);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.lblZeroPntUnits);
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.lblFullPnt);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrFullPnt);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.lblFullPntUnits);
        panelBuilder.nextColumn(2);
        return panelBuilder.getPanel();
    }
}

