/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.gui.chart.BaseTblDataAdapter;
import com.ecmtuning.ecmlink.gui.chart.TblBuilder;
import com.ecmtuning.ecmlink.gui.chart.TblDataAdapter;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.WeakListeners;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.WGSRecordModel;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uifextras.util.PopupAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataListener;

public class WGSTargetTableAdapter
extends TblDataAdapter {
    final WGSRecordModel model;
    static final int indexPSI = UnitsModel.INDEX_BOOST_PRESSURE_PSI;
    static final int indexPSIA = UnitsModel.INDEX_BOOST_PRESSURE_PSIA;
    boolean isPSI;
    PropertyChangeListener pressureUnitsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WGSTargetTableAdapter.this.updatePressureUnits();
        }
    };
    Action copyTableAction;
    Action pasteTableAction;
    private static String[] rpmIndices = new String[]{"2000", "2500", "3000", "3500", "4000", "4500", "5000", "5500", "6000", "6500", "7000", "7500", "8000", "8500", "9000", "9500", "10k"};
    static ArrayListModel rpmStrList = new ArrayListModel(Arrays.asList(rpmIndices));
    private static String[] gearIndices = new String[]{"1st", "2nd", "3rd"};
    private static ArrayListModel gearStrList = new ArrayListModel(Arrays.asList(gearIndices));

    public WGSTargetTableAdapter(WGSRecordModel wGSRecordModel) {
        this.model = wGSRecordModel;
        UnitsModel unitsModel = UnitsModel.getInstance();
        WeakListeners.addPropertyChangeListener(this.pressureUnitsListener, (Object)unitsModel, "boostPressureIndex");
        this.updatePressureUnits();
        super.construct(new String[]{"99999"});
    }

    protected void updatePressureUnits() {
        int n = UnitsModel.getInstance().getBoostPressureIndex();
        this.isPSI = n == indexPSI || n == indexPSIA;
    }

    void resetLocalValue() {
        this.stringDataModel.resetLocalValue();
    }

    @Override
    protected void construct(String[] stringArray) {
        super.construct(stringArray);
    }

    @Override
    protected Number calculateNextRawValue(Number number, boolean bl) {
        Float8Field float8Field = (Float8Field)this.model.mdlTargetPsia.getSubject();
        return bl ? float8Field.nextStepValue((Float)number) : float8Field.previousStepValue((Float)number);
    }

    @Override
    protected ValueModel createRawDataModel() {
        return this.model.mdlTargetPsia;
    }

    @Override
    protected void addDataFilters(ListModelPlug listModelPlug) {
        UnitsHelper.installFilter(listModelPlug, this.model.airPressureValueFilter, "typeAirPressureFromPSIA");
    }

    @Override
    protected int getDataPrec() {
        return this.isPSI ? 1 : 2;
    }

    @Override
    protected ValueModel createRawColumnHeaderModel() {
        return new ValueHolder((Object)rpmStrList);
    }

    @Override
    protected ListModelPlug createStringColumnHeaderModel() {
        ListModelPlug listModelPlug = new ListModelPlug(this.rawColumnHeaderModel, null, true);
        listModelPlug.getLocalArrayListValue().addListDataListener((ListDataListener)new BaseTblDataAdapter.LocalListListener(2));
        return listModelPlug;
    }

    @Override
    protected ValueModel createRawRowHeaderModel() {
        return new ValueHolder((Object)gearStrList);
    }

    @Override
    protected ListModelPlug createStringRowHeaderModel() {
        ListModelPlug listModelPlug = new ListModelPlug(this.rawRowHeaderModel, null, true);
        listModelPlug.getLocalArrayListValue().addListDataListener((ListDataListener)new BaseTblDataAdapter.LocalListListener(1));
        return listModelPlug;
    }

    void createTableActions(TblBuilder tblBuilder) {
        this.copyTableAction = tblBuilder.getDataTable().getCopyAction();
        ECMLinkResources.configureAction(this.copyTableAction, "copyTable");
        this.pasteTableAction = tblBuilder.getDataTable().getPasteAction();
        ECMLinkResources.configureAction(this.pasteTableAction, "pasteTable");
    }

    MouseListener getPopupListener() {
        return new PopupAdapter(true){

            protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                return WGSTargetTableAdapter.this.buildPopupMenu();
            }
        };
    }

    private JPopupMenu buildPopupMenu() {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder((String)null);
        popupMenuBuilder.add(this.copyTableAction);
        popupMenuBuilder.add(this.pasteTableAction);
        this.addExtraPopupActions(popupMenuBuilder);
        return popupMenuBuilder.getPopupMenu();
    }
}

