/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.SerialPortManager;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.main.PortConfigDialog;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uifextras.util.ActionLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public abstract class AbstractConfigDialog
extends AbstractDialog {
    protected JComboBox portComboBox;
    protected DefaultComboBoxModel portComboModel;
    protected ActionLabel configurePortsLabel;
    protected JCheckBox scanPortsCheckBox;
    protected JCheckBox rememberLastPortCheckBox;
    protected JCheckBox autoConnectCheckBox;
    protected JCheckBox pollCheckBox;
    protected final DeviceManager lclDeviceManager;
    JComponent contentPanel;
    private final AbstractAction configurePortsAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PortConfigDialog portConfigDialog = new PortConfigDialog((Frame)AbstractConfigDialog.this.getOwner(), SerialPortManager.getInstance());
            portConfigDialog.open();
            if (!portConfigDialog.hasBeenCanceled()) {
                AbstractConfigDialog.this.updatePortCombo();
                AbstractConfigDialog.this.pack();
            }
        }
    };
    private final PropertyChangeListener serialPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractConfigDialog.this.updatePortCombo();
            AbstractConfigDialog.this.pack();
        }
    };

    protected AbstractConfigDialog(Frame frame, DeviceManager deviceManager) {
        super(frame);
        MainModel mainModel;
        HelpBroker helpBroker;
        this.lclDeviceManager = deviceManager;
        this.setTitle(this.getConfigDialogTitle());
        String string = this.getHelpID();
        if (string != null && (helpBroker = (mainModel = MainModel.getInstance()).getHelpBroker()) != null) {
            JRootPane jRootPane = this.getRootPane();
            helpBroker.enableHelpKey((Component)jRootPane, string, null);
        }
        mainModel = this.getTriggerChannel();
        mainModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() == Boolean.FALSE) {
                    AbstractConfigDialog.this.updateView();
                } else if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    AbstractConfigDialog.this.updateModel();
                }
            }
        });
    }

    protected abstract String getConfigDialogTitle();

    protected abstract String getHelpID();

    protected abstract JPanel buildAdvancedPanel();

    protected abstract Component getECUTypeComponent();

    protected void updateView() {
        this.updatePortCombo();
        this.scanPortsCheckBox.setSelected(this.lclDeviceManager.getDoPortScan());
        this.rememberLastPortCheckBox.setSelected(this.lclDeviceManager.getRememberGoodPort());
        this.autoConnectCheckBox.setSelected(this.lclDeviceManager.getDoAutoConnect());
        this.pollCheckBox.setSelected(this.lclDeviceManager.getDoPoll());
    }

    private void updatePortCombo() {
        Object object = this.portComboBox.getSelectedItem();
        String string = this.lclDeviceManager.getInitialPortId();
        SerialPortManager serialPortManager = SerialPortManager.getInstance();
        ArrayList arrayList = serialPortManager.getUsePortIdList(string);
        this.portComboModel.removeAllElements();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.portComboModel.addElement(iterator.next());
        }
        this.portComboBox.setModel(this.portComboModel);
        if (object != null) {
            this.portComboBox.setSelectedItem(object);
        }
        if (object == null || this.portComboBox.getSelectedIndex() == -1) {
            this.portComboModel.setSelectedItem(string);
        }
    }

    protected void updateModel() {
        String string = (String)this.portComboModel.getSelectedItem();
        this.lclDeviceManager.setInitialPortId(string);
        this.lclDeviceManager.setDoPortScan(this.scanPortsCheckBox.isSelected());
        this.lclDeviceManager.setRememberGoodPort(this.rememberLastPortCheckBox.isSelected());
        this.lclDeviceManager.setDoAutoConnect(this.autoConnectCheckBox.isSelected());
        this.lclDeviceManager.setDoPoll(this.pollCheckBox.isSelected());
    }

    public void open() {
        super.open();
        SerialPortManager serialPortManager = SerialPortManager.getInstance();
        serialPortManager.addPropertyChangeListener("portIdListFromOsModel", this.serialPortListener);
    }

    public void close() {
        super.close();
        SerialPortManager serialPortManager = SerialPortManager.getInstance();
        serialPortManager.removePropertyChangeListener("portIdListFromOsModel", this.serialPortListener);
    }

    protected void setResizable() {
        this.setResizable(true);
    }

    protected synchronized JComponent buildContent() {
        if (this.contentPanel == null) {
            this.initComponents();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buildCenterPanel(), "Center");
            if (this.getHelpID() != null) {
                JButton jButton = DialogUtil.createDefaultHelpButton(this.getHelpID());
                jPanel.add((Component)this.buildButtonBarWithOKCancelAnd(jButton), "South");
            } else {
                jPanel.add((Component)this.buildButtonBarWithOKCancel(), "South");
            }
            this.contentPanel = jPanel;
        }
        return this.contentPanel;
    }

    protected void initComponents() {
        this.portComboModel = new DefaultComboBoxModel();
        this.portComboBox = new JComboBox();
        this.portComboBox.setModel(this.portComboModel);
        this.configurePortsLabel = new ActionLabel("", Color.BLUE, null);
        this.configurePortsAction.putValue("Name", "Configure ports\u2026");
        this.configurePortsLabel.setForeground(Color.BLUE);
        this.configurePortsLabel.setAction((Action)this.configurePortsAction);
        this.scanPortsCheckBox = new JCheckBox("Scan ports for ECU");
        this.scanPortsCheckBox.setToolTipText("Scans all configured ports to find a valid ECU connection");
        this.rememberLastPortCheckBox = new JCheckBox("Remember last good port");
        this.autoConnectCheckBox = new JCheckBox("Automatic connect");
        this.autoConnectCheckBox.setToolTipText("Automatically attempts to connect any time the connection is down");
        this.pollCheckBox = new JCheckBox("Poll connection (keep alive)");
        this.pollCheckBox.setToolTipText("Periodically polls the connection to update connection status");
        this.updateView();
    }

    private JComponent buildCenterPanel() {
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{FormFactory.PREF_COLSPEC};
        RowSpec[] rowSpecArray = new RowSpec[]{DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC, DialogUtil.INTER_SECT_GAP_ROWSPEC, DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC, DialogUtil.INTER_SECT_GAP_ROWSPEC};
        FormLayout formLayout = new FormLayout(columnSpecArray, rowSpecArray);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildBasicPanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildAdvancedPanel(), cellConstraints.xy(1, 3));
        return panelBuilder.getPanel();
    }

    JPanel buildBasicPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.FILL_DEFAULT_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRows(rowSpec, rowSpec2);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("Basic");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(rowSpec, rowSpec3);
        panelBuilder.addLabel("Device type:");
        panelBuilder.nextColumn(2);
        panelBuilder.add(this.getECUTypeComponent());
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(rowSpec, rowSpec3);
        panelBuilder.addLabel("Initial port:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.buildPortPanel());
        panelBuilder.nextLine(2, 4);
        panelBuilder.appendRows(rowSpec, rowSpec3);
        panelBuilder.add((Component)this.scanPortsCheckBox);
        panelBuilder.nextLine(2, 4);
        panelBuilder.appendRows(rowSpec, rowSpec3);
        panelBuilder.add((Component)this.rememberLastPortCheckBox);
        panelBuilder.nextLine(2, 4);
        panelBuilder.appendRows(rowSpec, rowSpec3);
        panelBuilder.add((Component)this.autoConnectCheckBox);
        panelBuilder.nextLine(2, 4);
        panelBuilder.appendRow(rowSpec);
        panelBuilder.add((Component)this.pollCheckBox);
        return panelBuilder.getPanel();
    }

    private final JPanel buildPortPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRow(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        panelBuilder.setColumn(1);
        panelBuilder.add((Component)this.portComboBox);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.configurePortsLabel);
        return panelBuilder.getPanel();
    }
}

