/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.device.DeviceMap;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DatasetManager;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.main.MainResources;
import com.ecmtuning.ecmlink.view.main.ManualAddDialog;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractDialog;
import foxtrot.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;

public class CapturedValuesDialog
extends AbstractDialog {
    private final ArrayListModel mainDisplayItems = new ArrayListModel();
    private final ArrayListModel mainTOCItems = new ArrayListModel();
    private final ArrayListModel auxDisplayItems = new ArrayListModel();
    private final ArrayListModel auxTOCItems = new ArrayListModel();
    private JList mainDisplayList;
    private JList mainTOCList;
    private JList auxDisplayList;
    private JList auxTOCList;
    boolean hasAuxTab;
    private LocationTOC mainCompleteTOC;
    private LocationTOC auxCompleteTOC;
    private int mainDeviceId;
    private int auxDeviceId;
    private int mainSerialNum;
    private int auxSerialNum;
    protected static final String helpID = "capturedvalues";
    protected JButton helpButton = DialogUtil.createDefaultHelpButton("capturedvalues");
    JComponent contentPanel;

    public CapturedValuesDialog(Frame frame) throws IOException, DeviceException {
        super(frame);
        this.checkBundles();
        DeviceManager deviceManager = DeviceManagerFactory.getInstance().getMainDeviceManager();
        if (deviceManager == null) {
            throw new IllegalStateException("Can't have null main DeviceManager");
        }
        LocationTOC locationTOC = new LocationTOC(DatasetManager.getInstance().getLiveMainTOC());
        this.mainDeviceId = deviceManager.getConnectedDeviceId();
        this.mainSerialNum = deviceManager.getConnectedSerialNum();
        this.mainCompleteTOC = DataManager.createCompleteTOC(this.mainDeviceId, this.mainSerialNum, deviceManager.getConnectedFirmwareId());
        LocationTOC locationTOC2 = null;
        DeviceManager deviceManager2 = DeviceManagerFactory.getInstance().getAuxDeviceManager();
        if (deviceManager2 != null) {
            try {
                locationTOC2 = new LocationTOC(DatasetManager.getInstance().getLiveAuxTOC());
                this.auxDeviceId = deviceManager2.getConnectedDeviceId();
                this.auxSerialNum = deviceManager2.getConnectedSerialNum();
                this.auxCompleteTOC = DataManager.createCompleteTOC(this.auxDeviceId, this.auxSerialNum, deviceManager2.getConnectedFirmwareId());
                this.hasAuxTab = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.pushTOCItems(locationTOC, (List)this.mainTOCItems);
        this.pushDisplayItems(this.mainCompleteTOC, (List)this.mainDisplayItems);
        this.registerTOC(locationTOC, this.mainDisplayItems);
        if (this.hasAuxTab) {
            this.pushTOCItems(locationTOC2, (List)this.auxTOCItems);
            this.pushDisplayItems(this.auxCompleteTOC, (List)this.auxDisplayItems);
            this.registerTOC(locationTOC2, this.auxDisplayItems);
        }
        this.setTitle(MainResources.getString("capturedvalues.title"));
        MainModel mainModel = MainModel.getInstance();
        HelpBroker helpBroker = mainModel.getHelpBroker();
        if (helpBroker != null) {
            JRootPane jRootPane = this.getRootPane();
            helpBroker.enableHelpKey((Component)jRootPane, helpID, null);
        }
    }

    protected void setResizable() {
        this.setResizable(true);
    }

    private void checkBundles() {
        if (MainResources.resourceBundle == null) {
            throw new IllegalStateException("ResourceBundle for '" + CapturedValuesDialog.class.getName() + "' failed to load");
        }
        if (MainResources.actionBundle == null) {
            throw new IllegalStateException("ActionBundle for '" + CapturedValuesDialog.class.getName() + "' failed to load");
        }
    }

    private void registerTOC(LocationTOC locationTOC, ArrayListModel arrayListModel) {
        int n = arrayListModel.size();
        for (int i = 0; i < n; ++i) {
            DisplayItem displayItem = (DisplayItem)arrayListModel.get(i);
            boolean bl = displayItem.chain.isDisplayable();
            displayItem.chain.registerTOC(locationTOC, null);
            if (bl == displayItem.chain.isDisplayable()) continue;
            arrayListModel.fireContentsChanged(i);
        }
    }

    private void pushDisplayItems(LocationTOC locationTOC, List list) {
        List list2 = DisplayChain.generateDisplayChains(locationTOC);
        for (DisplayChain displayChain : list2) {
            list.add(new DisplayItem(displayChain));
        }
        this.sortDisplayItems(list);
    }

    private void sortDisplayItems(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((DisplayItem)object).desc.getDisplayName().toLowerCase().compareTo(((DisplayItem)object2).desc.getDisplayName().toLowerCase());
            }
        });
    }

    private void pushTOCItems(LocationTOC locationTOC, List list) {
        for (LocationTOCEntry locationTOCEntry : locationTOC.getTOCEntries()) {
            list.add(new TOCItem(locationTOCEntry));
        }
    }

    private LocationTOC createTOC(int n, List list) {
        ArrayList<LocationTOCEntry> arrayList = new ArrayList<LocationTOCEntry>();
        for (TOCItem tOCItem : list) {
            arrayList.add(tOCItem.entry);
        }
        return new LocationTOC(n, arrayList);
    }

    public void doAccept() {
        SaveToDeviceTask saveToDeviceTask = new SaveToDeviceTask();
        MainActions.handleTask(saveToDeviceTask, true, this.getGlassPane());
        if (!saveToDeviceTask.receivedError) {
            super.doAccept();
        }
    }

    protected synchronized JComponent buildContent() {
        if (this.contentPanel == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buildCenterPanel(), "Center");
            jPanel.add((Component)this.buildButtonBarWithOKCancelAnd(this.helpButton), "South");
            this.contentPanel = jPanel;
        }
        return this.contentPanel;
    }

    protected JComponent buildCenterPanel() {
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.addTab("Main", this.createTab(true));
        if (this.hasAuxTab) {
            jTabbedPane.addTab("Aux", this.createTab(false));
        } else {
            jTabbedPane.addTab("Aux", new JPanel());
            jTabbedPane.setEnabledAt(1, this.hasAuxTab);
        }
        return jTabbedPane;
    }

    private Component createTab(boolean bl) {
        int n = bl ? this.mainDeviceId : this.auxDeviceId;
        ArrayListModel arrayListModel = bl ? this.mainDisplayItems : this.auxDisplayItems;
        ArrayListModel arrayListModel2 = bl ? this.mainTOCItems : this.auxTOCItems;
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(new ColumnSpec("fill:max(min;140dlu):grow"));
        arrayList.add(DialogUtil.UNRELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.UNRELATED_GAP_COLSPEC);
        arrayList.add(new ColumnSpec("fill:max(min;140dlu):grow"));
        ArrayList<RowSpec> arrayList2 = new ArrayList<RowSpec>();
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        arrayList2.add(DialogUtil.RELATED_GAP_ROWSPEC);
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        arrayList2.add(DialogUtil.RELATED_GAP_ROWSPEC);
        arrayList2.add(new RowSpec("fill:max(min;180dlu):grow"));
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        String string = MainResources.getString("capturedvalues.devicetype.prefix") + " " + DeviceMap.getDeviceDisplayName(n);
        panelBuilder.add((Component)new JLabel(string, 4), cellConstraints.xywh(1, 1, 5, 1));
        panelBuilder.addSeparator(MainResources.getString("capturedvalues.displaylist.title"), cellConstraints.xy(1, 3));
        panelBuilder.addSeparator(MainResources.getString("capturedvalues.toclist.title"), cellConstraints.xy(5, 3));
        JList<Object> jList = new JList<Object>();
        jList.setModel((ListModel<Object>)arrayListModel);
        jList.setCellRenderer(new DisplayItemRenderer());
        panelBuilder.add((Component)new JScrollPane(jList), cellConstraints.xy(1, 5));
        JList<Object> jList2 = new JList<Object>();
        jList2.setModel((ListModel<Object>)arrayListModel2);
        jList2.setCellRenderer(new TOCItemRenderer());
        panelBuilder.add((Component)new JScrollPane(jList2), cellConstraints.xy(5, 5));
        if (bl) {
            this.mainDisplayList = jList;
            this.mainTOCList = jList2;
        } else {
            this.auxDisplayList = jList;
            this.auxTOCList = jList2;
        }
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addGridded((JComponent)new JButton(new AddToDeviceAction(bl)));
        buttonStackBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        buttonStackBuilder.nextRow();
        buttonStackBuilder.addGridded((JComponent)new JButton(new RemoveAction(bl)));
        buttonStackBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        buttonStackBuilder.nextRow();
        buttonStackBuilder.addGridded((JComponent)new JButton(new ManualAddAction(bl)));
        buttonStackBuilder.addGlue();
        buttonStackBuilder.addGridded((JComponent)new JButton(new ShowUsageAction(bl)));
        buttonStackBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        buttonStackBuilder.nextRow();
        buttonStackBuilder.addGridded((JComponent)new JButton(new LoadAction(bl)));
        buttonStackBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        buttonStackBuilder.nextRow();
        buttonStackBuilder.addGridded((JComponent)new JButton(new SaveAction(bl)));
        panelBuilder.add((Component)buttonStackBuilder.getPanel(), cellConstraints.xy(3, 5));
        return panelBuilder.getPanel();
    }

    private static class TOCItemRenderer
    extends DefaultListCellRenderer {
        private TOCItemRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (((TOCItem)object).isBold()) {
                DialogUtil.makeBold(this);
            }
            return this;
        }
    }

    private static class DisplayItemRenderer
    extends DefaultListCellRenderer {
        private DisplayItemRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (((DisplayItem)object).isBold()) {
                DialogUtil.makeBold(this);
            }
            return this;
        }
    }

    private class SaveAction
    extends AbstractAction {
        private final boolean main;

        SaveAction(boolean bl) {
            this.main = bl;
            MainResources.configureAction(this, "capturedvalues.save");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class LoadAction
    extends AbstractAction {
        private final boolean main;

        LoadAction(boolean bl) {
            this.main = bl;
            MainResources.configureAction(this, "capturedvalues.load");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ShowUsageAction
    extends AbstractAction {
        private final boolean main;

        ShowUsageAction(boolean bl) {
            this.main = bl;
            MainResources.configureAction(this, "capturedvalues.showusage");
            JList jList = bl ? CapturedValuesDialog.this.mainTOCList : CapturedValuesDialog.this.auxTOCList;
            DialogUtil.registerListSelectionEnabler(jList.getSelectionModel(), this);
            DialogUtil.registerDoubleClickHandler(jList, this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JList jList = this.main ? CapturedValuesDialog.this.mainTOCList : CapturedValuesDialog.this.auxTOCList;
            JList jList2 = this.main ? CapturedValuesDialog.this.mainDisplayList : CapturedValuesDialog.this.auxDisplayList;
            ArrayListModel arrayListModel = this.main ? CapturedValuesDialog.this.mainDisplayItems : CapturedValuesDialog.this.auxDisplayItems;
            jList2.clearSelection();
            ArrayList<Location> arrayList = new ArrayList<Location>();
            Object[] objectArray = jList.getSelectedValues();
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(((TOCItem)objectArray[n]).entry.getLocation());
            }
            n = arrayListModel.size();
            for (int i = 0; i < n; ++i) {
                DisplayChain displayChain = ((DisplayItem)arrayListModel.get((int)i)).chain;
                if (!displayChain.needsAnyLocations(arrayList)) continue;
                jList2.addSelectionInterval(i, i);
            }
        }
    }

    private class ManualAddAction
    extends AbstractAction {
        private final boolean main;

        ManualAddAction(boolean bl) {
            this.main = bl;
            MainResources.configureAction(this, "capturedvalues.manualadd");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object22;
            LocationTOC locationTOC = this.main ? CapturedValuesDialog.this.mainCompleteTOC : CapturedValuesDialog.this.auxCompleteTOC;
            ArrayListModel arrayListModel = this.main ? CapturedValuesDialog.this.mainTOCItems : CapturedValuesDialog.this.auxTOCItems;
            int n = this.main ? CapturedValuesDialog.this.mainDeviceId : CapturedValuesDialog.this.auxDeviceId;
            ArrayListModel arrayListModel2 = this.main ? CapturedValuesDialog.this.mainDisplayItems : CapturedValuesDialog.this.auxDisplayItems;
            ArrayListModel arrayListModel3 = new ArrayListModel();
            for (Object object22 : locationTOC.getTOCEntries()) {
                boolean bl = !((LocationTOCEntry)object22).getDataType().equalsIgnoreCase("data.sys.nodef");
                object = arrayListModel.iterator();
                while (bl && object.hasNext()) {
                    TOCItem tOCItem = (TOCItem)object.next();
                    if (!tOCItem.entry.getLocation().matches(((LocationTOCEntry)object22).getLocation())) continue;
                    bl = false;
                }
                if (!bl) continue;
                arrayListModel3.add((Object)new TOCItem((LocationTOCEntry)object22));
            }
            Collections.sort(arrayListModel3, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((TOCItem)object).getDisplayText().compareTo(((TOCItem)object2).getDisplayText());
                }
            });
            object22 = new ManualAddDialog((JDialog)((Object)CapturedValuesDialog.this), arrayListModel3);
            object22.open();
            if (!object22.hasBeenCanceled()) {
                List list = ((ManualAddDialog)((Object)object22)).getSelectedTOCItems();
                arrayListModel.addAll((Collection)list);
                object = CapturedValuesDialog.this.createTOC(n, (List)arrayListModel);
                CapturedValuesDialog.this.registerTOC((LocationTOC)object, arrayListModel2);
            }
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        private final boolean main;

        RemoveAction(boolean bl) {
            this.main = bl;
            MainResources.configureAction(this, "capturedvalues.remove");
            JList jList = bl ? CapturedValuesDialog.this.mainTOCList : CapturedValuesDialog.this.auxTOCList;
            DialogUtil.registerListSelectionEnabler(jList.getSelectionModel(), this);
            DialogUtil.registerDoubleClickHandler(jList, this);
            this.setEnabled(false);
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            JList jList = this.main ? CapturedValuesDialog.this.mainTOCList : CapturedValuesDialog.this.auxTOCList;
            int n = this.main ? CapturedValuesDialog.this.mainDeviceId : CapturedValuesDialog.this.auxDeviceId;
            ArrayListModel arrayListModel = this.main ? CapturedValuesDialog.this.mainDisplayItems : CapturedValuesDialog.this.auxDisplayItems;
            ArrayListModel arrayListModel2 = this.main ? CapturedValuesDialog.this.mainTOCItems : CapturedValuesDialog.this.auxTOCItems;
            int[] nArray = jList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                TOCItem tOCItem = (TOCItem)arrayListModel2.get(nArray[i]);
                if (tOCItem.entry.isAlwaysPresent()) continue;
                arrayListModel2.remove(nArray[i]);
            }
            jList.clearSelection();
            LocationTOC locationTOC = CapturedValuesDialog.this.createTOC(n, (List)arrayListModel2);
            CapturedValuesDialog.this.registerTOC(locationTOC, arrayListModel);
        }
    }

    private final class AddToDeviceAction
    extends AbstractAction {
        private final boolean main;

        AddToDeviceAction(boolean bl) {
            this.main = bl;
            MainResources.configureAction(this, "capturedvalues.add");
            JList jList = bl ? CapturedValuesDialog.this.mainDisplayList : CapturedValuesDialog.this.auxDisplayList;
            DialogUtil.registerListSelectionEnabler(jList.getSelectionModel(), this);
            DialogUtil.registerDoubleClickHandler(jList, this);
            this.setEnabled(false);
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            Object object2;
            JList jList = this.main ? CapturedValuesDialog.this.mainDisplayList : CapturedValuesDialog.this.auxDisplayList;
            int n = this.main ? CapturedValuesDialog.this.mainDeviceId : CapturedValuesDialog.this.auxDeviceId;
            ArrayListModel arrayListModel = this.main ? CapturedValuesDialog.this.mainDisplayItems : CapturedValuesDialog.this.auxDisplayItems;
            ArrayListModel arrayListModel2 = this.main ? CapturedValuesDialog.this.mainTOCItems : CapturedValuesDialog.this.auxTOCItems;
            LocationTOC locationTOC = this.main ? CapturedValuesDialog.this.mainCompleteTOC : CapturedValuesDialog.this.auxCompleteTOC;
            Object[] objectArray = jList.getSelectedValues();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = (DisplayItem)objectArray[i];
                ((DisplayItem)object2).chain.findMissingTOCEntries(locationTOC, arrayList);
            }
            jList.clearSelection();
            for (Object object2 : arrayList) {
                arrayListModel2.add((Object)new TOCItem((LocationTOCEntry)object2));
            }
            object2 = CapturedValuesDialog.this.createTOC(n, (List)arrayListModel2);
            CapturedValuesDialog.this.registerTOC((LocationTOC)object2, arrayListModel);
        }
    }

    private class SaveToDeviceTask
    extends Task {
        boolean receivedError;

        public Object run() throws Exception {
            this.receivedError = true;
            LocationTOC locationTOC = CapturedValuesDialog.this.createTOC(CapturedValuesDialog.this.mainDeviceId, (List)CapturedValuesDialog.this.mainTOCItems);
            DatasetManager.getInstance().setLiveMainTOC(locationTOC);
            if (CapturedValuesDialog.this.hasAuxTab) {
                locationTOC = CapturedValuesDialog.this.createTOC(CapturedValuesDialog.this.auxDeviceId, (List)CapturedValuesDialog.this.auxTOCItems);
                DatasetManager.getInstance().setLiveAuxTOC(locationTOC);
            }
            this.receivedError = false;
            return null;
        }
    }

    static class TOCItem {
        LocationTOCEntry entry;
        String displayText;

        TOCItem(LocationTOCEntry locationTOCEntry) {
            this.entry = locationTOCEntry;
            this.displayText = this.entry.getListDisplayName();
        }

        boolean isBold() {
            return !this.entry.isAlwaysPresent();
        }

        String getDisplayText() {
            return this.displayText;
        }

        public String toString() {
            return this.getDisplayText();
        }
    }

    static class DisplayItem {
        DisplayChain chain;
        DisplayChainDesc desc;

        DisplayItem(DisplayChain displayChain) {
            this.chain = displayChain;
            this.desc = displayChain.getCurrentChainDesc();
        }

        boolean isBold() {
            return this.chain.isDisplayable();
        }

        String getDisplayText() {
            return this.desc.getDisplayName();
        }

        public String toString() {
            return this.getDisplayText();
        }
    }
}

