/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.util.ui.TrackedTabPanel;
import com.ecmtuning.ecmlink.util.ui.TrackedTabbedPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;

public class CloseTabComponent
extends JPanel {
    private final TrackedTabbedPane pane;
    private final TrackedTabPanel tab;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }
    };

    public CloseTabComponent(final TrackedTabbedPane trackedTabbedPane, final TrackedTabPanel trackedTabPanel) {
        super(new FlowLayout(0, 0, 0));
        if (trackedTabbedPane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = trackedTabbedPane;
        this.tab = trackedTabPanel;
        this.setOpaque(false);
        JLabel jLabel = new JLabel(){

            @Override
            public String getText() {
                int n;
                if (trackedTabbedPane != null && (n = trackedTabbedPane.indexOfTab(trackedTabPanel)) != -1) {
                    return trackedTabbedPane.getTitleAt(n);
                }
                return null;
            }
        };
        this.add(jLabel);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton tabButton = new TabButton();
        this.add(tabButton);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int n = 17;
            this.setPreferredSize(new Dimension(n, n));
            this.setToolTipText("close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = CloseTabComponent.this.pane.indexOfTab(CloseTabComponent.this.tab);
            if (n != -1) {
                CloseTabComponent.this.pane.remove(n);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.getModel().isPressed()) {
                graphics2D.translate(1, 1);
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                graphics2D.setColor(Color.MAGENTA);
            }
            int n = 6;
            graphics2D.drawLine(n, n, this.getWidth() - n - 1, this.getHeight() - n - 1);
            graphics2D.drawLine(this.getWidth() - n - 1, n, n, this.getHeight() - n - 1);
            graphics2D.dispose();
        }
    }
}

