/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DatalogFile;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DatasetManager;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.TimeNavModel;
import com.ecmtuning.ecmlink.device.data.TimeSelectionModel;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.SwingInvokeUtils;
import com.ecmtuning.ecmlink.view.main.DisplaySetView;
import com.ecmtuning.ecmlink.view.main.GraphView;
import com.ecmtuning.ecmlink.view.main.MainResources;
import com.ecmtuning.ecmlink.view.main.tabs.MainTabPanel;
import com.jgoodies.forms.factories.Borders;
import foxtrot.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;

public class DatalogTab
extends MainTabPanel {
    public static final String SELECT_PREVIOUS = "selectPrevious";
    public static final String SELECT_PREVIOUS_EXTEND = "selectPreviousExtendSelection";
    public static final String SELECT_NEXT = "selectNext";
    public static final String SELECT_NEXT_EXTEND = "selectNextExtendSelection";
    public static final String SELECT_PREVIOUS_BY_FACTOR = "selectPreviousByFactor";
    public static final String SELECT_PREVIOUS_BY_FACTOR_EXTEND = "selectPreviousExtendSelectionFactor";
    public static final String SELECT_NEXT_BY_FACTOR = "selectNextFactor";
    public static final String SELECT_NEXT_BY_FACTOR_EXTEND = "selectNextExtendSelectionFactor";
    public static final String SELECT_PREVIOUS_BY_PAGE = "selectPreviousByPage";
    public static final String SELECT_PREVIOUS_BY_PAGE_EXTEND = "selectPreviousExtendSelectionPage";
    public static final String SELECT_NEXT_BY_PAGE = "selectNextPage";
    public static final String SELECT_NEXT_BY_PAGE_EXTEND = "selectNextExtendSelectionPage";
    public static final String SELECT_FIRST = "selectFirst";
    public static final String SELECT_FIRST_EXTEND = "selectFirstExtendSelection";
    public static final String SELECT_LAST = "selectLast";
    public static final String SELECT_LAST_EXTEND = "selectLastExtendSelection";
    public static final String SELECT_SCREEN_FIRST = "selectScreenFirst";
    public static final String SELECT_SCREEN_FIRST_EXTEND = "selectScreenFirstExtendSelection";
    public static final String SELECT_SCREEN_LAST = "selectScreenLast";
    public static final String SELECT_SCREEN_LAST_EXTEND = "selectScreenLastExtendSelection";
    public static final String ZOOM_IN_BY_LARGE_FACTOR = "zoomInByLargeFactor";
    public static final String ZOOM_OUT_BY_LARGE_FACTOR = "zoomOutByLargeFactor";
    public static final double MOVE_JUMP_FACTOR = 0.03;
    public static final double MOVE_PAGE_FACTOR = 0.15;
    public static final double ZOOM_FACTOR = 0.1;
    private final Dataset dataset;
    private final DataPreferences converterPrefs;
    TimeNavModel navModel;
    TimeSelectionModel selectionModel;
    TimeSelectionModel textDisplayTimeModel;
    private DatalogFile lastSavedDatalog;
    private DisplaySetView displaySetView;
    private DisplaySet displaySet;
    private boolean liveViewInd;
    private boolean streamingInd;
    private static DatalogTab liveTabInstance;
    private static boolean actionsRegistered;
    private final PropertyChangeListener streamStateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DatalogTab.this.streamingInd = (Boolean)propertyChangeEvent.getNewValue();
            if (DatalogTab.this.streamingInd) {
                DatalogTab.this.selectionModel.clearSelection();
                DatalogTab.this.setLastSavedDatalog(DatalogTab.this.dataset.getLiveDatalog());
            }
            DatalogTab.this.displaySetView.setStreamState(DatalogTab.this.streamingInd);
        }
    };
    private static Hashtable actionCache;
    private AbstractAction doSaveAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(DatalogTab.this.saveTask, false);
        }
    };
    private AbstractAction doSaveAsAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(DatalogTab.this.saveAsTask, false);
        }
    };
    private Task saveTask = new Task(){

        public Object run() throws Exception {
            if (DatalogTab.this.lastSavedDatalog == null) {
                DatalogTab.this.saveAsTask.run();
            } else {
                DatalogTab.this.lastSavedDatalog.save();
            }
            return null;
        }
    };
    Task saveAsTask = new Task(){

        public Object run() throws Exception {
            File file = DatalogTab.this.createDefaultFile("elg");
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(file);
            jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
            jFileChooser.addChoosableFileFilter(FilenameModel.getDatalogFileFilter());
            jFileChooser.setDialogTitle("Save Datalog");
            File file2 = DialogUtil.invokeSaveAsChooser(jFileChooser, DatalogTab.this, "elg");
            if (file2 != null) {
                if (DatalogTab.this.lastSavedDatalog == null) {
                    DatalogTab.this.setLastSavedDatalog(DatalogTab.this.createDatalogFile(file2));
                }
                DatalogTab.this.lastSavedDatalog.saveAs(file2);
            }
            return null;
        }
    };
    public static final int CHANGE_SELECTION = 1;
    public static final int EXTEND_SELECTION = 2;
    private static DatalogTab currentTab;

    private DatalogTab() {
        DatasetManager datasetManager = DatasetManager.getInstance();
        this.dataset = datasetManager.getLiveDataset();
        this.converterPrefs = DataPreferences.getConverterPreferences();
        this.setLiveView(true);
        this.construct();
        datasetManager.addPropertyChangeListener("streaming", this.streamStateListener);
    }

    public DatalogTab(DatalogFile datalogFile) {
        this.lastSavedDatalog = datalogFile;
        this.dataset = this.lastSavedDatalog.getDataset();
        this.converterPrefs = this.lastSavedDatalog.getConverterPrefs();
        this.setLiveView(false);
        this.construct();
        this.navModel.setCenterTime(this.navModel.getWidthTime() / 2.0);
    }

    private void construct() {
        DatalogTab.registerActions();
        this.navModel = new TimeNavModel();
        this.selectionModel = new TimeSelectionModel();
        this.textDisplayTimeModel = new TimeSelectionModel();
        this.displaySetView = new GraphView(this);
        this.displaySet = this.displaySetView.getDisplaySet();
        this.navModel.setTotalWidthTime(this.displaySet.getDisplayPacketMaxTime());
        this.build();
    }

    private static synchronized void registerActions() {
        if (actionsRegistered) {
            return;
        }
        DatalogTab.registerMainAction("datalog.zoomSelection");
        DatalogTab.registerMainAction("datalog.zoomAll");
        DatalogTab.registerMainAction("datalog.zoomDefault");
        DatalogTab.registerMainAction("datalog.zoomInByFactor");
        DatalogTab.registerMainAction("datalog.zoomOutByFactor");
        DatalogTab.registerMainAction("datalog.selectAll");
        DatalogTab.registerMainAction("datalog.selectNone");
        DatalogTab.registerMainAction("datalog.centerSelection");
        DatalogTab.registerMainAction("datalog.clipToSelection");
        actionsRegistered = true;
    }

    static Action registerMainAction(String string) {
        Action action = MainResources.registerLazyAction(string, new Actions(string));
        return action;
    }

    protected void build() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(Borders.TABBED_DIALOG_BORDER);
        this.add((Component)this.displaySetView.build(), "Center");
    }

    public static synchronized DatalogTab getOrCreateLiveTab() {
        if (liveTabInstance == null || !liveTabInstance.isLiveView()) {
            liveTabInstance = new DatalogTab();
        }
        return liveTabInstance;
    }

    public static synchronized void dropLiveTab() {
        liveTabInstance = null;
    }

    @Override
    public void tabRemoved() {
        super.tabRemoved();
        DatalogTab.clearCurrentTab(this);
        if (this.isLiveView()) {
            this.mainModel.setLiveDatalogTabShown(false);
        } else {
            this.displaySetView.viewRemoved();
        }
    }

    @Override
    public void tabHidden() {
        super.tabHidden();
        DatalogTab.clearCurrentTab(this);
        this.displaySetView.viewHidden();
    }

    @Override
    public void tabShown() {
        super.tabShown();
        DatalogTab.setCurrentTab(this);
        this.displaySetView.viewShown();
        Container container = this.getParent();
        if (container != null && !container.hasFocus() && this.displaySetView != null && this.displaySetView.getDefaultFocusComponent() != null) {
            SwingInvokeUtils.requestFocusInWindowLater(this.displaySetView.getDefaultFocusComponent());
        }
    }

    private void assignNameAndTipText() {
        if (this.isLiveView()) {
            this.setTabName(MainResources.getString(this.getResourcePrefix(), "liveTitle"));
            if (this.lastSavedDatalog == null) {
                this.setToolTip(MainResources.getString(this.getResourcePrefix(), "liveToolTip"));
            } else {
                this.setToolTip(this.lastSavedDatalog.getSaveFile().getAbsolutePath());
            }
        } else {
            if (this.lastSavedDatalog == null) {
                this.lastSavedDatalog = this.createDatalogFile(this.createDefaultFile("elg"));
            }
            this.setTabName(XFormatter.clipAndPrefixWithEllipses(FilenameModel.getFilenameNoExt(this.lastSavedDatalog.getSaveFile()), 25));
            this.setToolTip(this.lastSavedDatalog.getSaveFile().getAbsolutePath());
        }
    }

    File createDefaultFile(String string) {
        MainModel mainModel = MainModel.getInstance();
        FilenameModel filenameModel = mainModel.getFilenameModel();
        return filenameModel.createNewDatalogFile();
    }

    public DatalogFile getLastSavedDatalog() {
        return this.lastSavedDatalog;
    }

    public void setLastSavedDatalog(DatalogFile datalogFile) {
        this.lastSavedDatalog = datalogFile;
        if (this.lastSavedDatalog != null) {
            FilenameModel filenameModel = this.mainModel.getFilenameModel();
            filenameModel.setLastAccessDirectory(this.lastSavedDatalog.getSaveFile().getParent());
        }
        this.assignNameAndTipText();
    }

    public DatalogFile createDatalogFile(File file) {
        return new DatalogFile(this.dataset, this.converterPrefs, System.currentTimeMillis(), file);
    }

    private String getResourcePrefix() {
        return "datalogTab";
    }

    public void setLiveView(boolean bl) {
        if (this.liveViewInd && !bl) {
            DatasetManager.getInstance().removePropertyChangeListener("streaming", this.streamStateListener);
            if (this.streamingInd) {
                this.displaySetView.setStreamState(false);
                this.streamingInd = false;
            }
        }
        this.liveViewInd = bl;
        this.assignNameAndTipText();
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public DataPreferences getConverterPrefs() {
        return this.converterPrefs;
    }

    public TimeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public TimeSelectionModel getTextDisplayTimeModel() {
        return this.textDisplayTimeModel;
    }

    public TimeNavModel getNavModel() {
        return this.navModel;
    }

    public static synchronized Action getLocalAction(String string) {
        Action action = (Action)actionCache.get(string);
        if (action == null) {
            action = new Actions(string);
            actionCache.put(string, action);
        }
        return action;
    }

    Action getSaveAction() {
        return this.doSaveAction;
    }

    Action getSaveAsAction() {
        return this.doSaveAsAction;
    }

    public void zoomToSelection() {
        if (this.selectionModel.isSelectionActive()) {
            if (this.selectionModel.isMomentSelection()) {
                this.centerSelection();
            } else {
                double d = this.selectionModel.getAnchorTime();
                double d2 = this.selectionModel.getExtentTime();
                this.selectionModel.clearSelection();
                this.navModel.setCenterAndWidthTime((d2 + d) / 2.0, Math.abs(d - d2));
            }
        }
    }

    public void zoomAll() {
        this.zoomAll(this.displaySet);
    }

    void zoomAll(DisplaySet displaySet) {
        double d = displaySet.getDisplayPacketMaxTime();
        this.navModel.setCenterAndWidthTime(d / 2.0, d);
    }

    public void zoomByFactor(double d) {
        double d2;
        double d3 = d2 = this.navModel.getWidthTime();
        if (d < 0.0) {
            d = Math.abs(d);
            d3 /= 1.0 + d;
        } else if (d > 0.0) {
            d3 *= 1.0 + d;
        }
        this.navModel.setWidthTime(d3);
    }

    public void selectAll() {
        double d = this.displaySet.getDisplayPacketMaxTime();
        this.selectionModel.setSelectionTime(0.0, d);
    }

    public void selectNone() {
        this.selectionModel.clearSelection();
    }

    public void clipToSelection() {
        if (this.selectionModel.isSelectionActive() && !this.selectionModel.isMomentSelection()) {
            double d;
            double d2 = this.selectionModel.getAnchorTime();
            if (d2 > (d = this.selectionModel.getExtentTime())) {
                double d3 = d2;
                d2 = d;
                d = d3;
            }
            this.displaySet.clipData(d2, d);
            this.selectionModel.clearSelection();
            this.zoomAll();
        }
    }

    public void centerSelection() {
        if (this.selectionModel.isSelectionActive()) {
            this.navModel.setCenterTime((this.selectionModel.getAnchorTime() + this.selectionModel.getExtentTime()) / 2.0);
        }
    }

    public final void changeSelection(int n, double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > this.displaySet.getDisplayPacketMaxTime()) {
            d = this.displaySet.getDisplayPacketMaxTime();
        }
        if (n == 2) {
            this.selectionModel.setExtentTime(d);
        } else {
            this.selectionModel.setMomentSelection(d);
        }
        this.displaySetView.ensureVisible(d);
    }

    public final double getNextTime(int n) {
        double d = this.displaySet.getDisplayPacketMaxTime();
        double d2 = !this.selectionModel.isSelectionActive() ? this.navModel.getCenterTime() : this.selectionModel.getExtentTime();
        double d3 = d2;
        if (n == 1) {
            d3 = this.displaySet.getNextPacketTime(d2);
        } else if (n == 2) {
            d3 = d2 + this.navModel.getWidthTime() * 0.03;
        } else if (n == 3) {
            d3 = d2 + this.navModel.getWidthTime() * 0.15;
        } else {
            if (n == -1) {
                return this.displaySet.getPreviousPacketTime(d2);
            }
            if (n == -2) {
                d3 = d2 - this.navModel.getWidthTime() * 0.03;
            } else if (n == -3) {
                d3 = d2 - this.navModel.getWidthTime() * 0.15;
            }
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        } else if (d3 > d) {
            d3 = d;
        }
        return d3;
    }

    public boolean isLiveView() {
        return this.liveViewInd;
    }

    public boolean isStreaming() {
        return this.streamingInd;
    }

    protected static synchronized DatalogTab getCurrentTab() {
        return currentTab;
    }

    protected static synchronized void setCurrentTab(DatalogTab datalogTab) {
        currentTab = datalogTab;
    }

    protected static synchronized void clearCurrentTab(DatalogTab datalogTab) {
        if (currentTab == datalogTab) {
            currentTab = null;
        }
    }

    static {
        actionCache = new Hashtable();
        currentTab = null;
    }

    static final class Actions
    extends AbstractAction {
        private final String id;

        private Actions(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DatalogTab datalogTab = DatalogTab.getCurrentTab();
            if (datalogTab == null) {
                return;
            }
            if (datalogTab.displaySetView.dispatchActionEvent(this.id, actionEvent)) {
                return;
            }
            if (datalogTab.isStreaming()) {
                // empty if block
            }
            if (this.id == "datalog.zoomSelection") {
                datalogTab.zoomToSelection();
            } else if (this.id == "datalog.zoomAll") {
                datalogTab.zoomAll();
            } else if (this.id == DatalogTab.SELECT_PREVIOUS) {
                datalogTab.changeSelection(1, datalogTab.getNextTime(-1));
            } else if (this.id == DatalogTab.SELECT_NEXT) {
                datalogTab.changeSelection(1, datalogTab.getNextTime(1));
            } else if (this.id == DatalogTab.SELECT_PREVIOUS_EXTEND) {
                datalogTab.changeSelection(2, datalogTab.getNextTime(-1));
            } else if (this.id == DatalogTab.SELECT_NEXT_EXTEND) {
                datalogTab.changeSelection(2, datalogTab.getNextTime(1));
            } else if (this.id == DatalogTab.SELECT_PREVIOUS_BY_FACTOR) {
                datalogTab.changeSelection(1, datalogTab.getNextTime(-2));
            } else if (this.id == DatalogTab.SELECT_NEXT_BY_FACTOR) {
                datalogTab.changeSelection(1, datalogTab.getNextTime(2));
            } else if (this.id == DatalogTab.SELECT_PREVIOUS_BY_FACTOR_EXTEND) {
                datalogTab.changeSelection(2, datalogTab.getNextTime(-2));
            } else if (this.id == DatalogTab.SELECT_NEXT_BY_FACTOR_EXTEND) {
                datalogTab.changeSelection(2, datalogTab.getNextTime(2));
            } else if (this.id == DatalogTab.SELECT_PREVIOUS_BY_PAGE) {
                datalogTab.changeSelection(1, datalogTab.getNextTime(-3));
            } else if (this.id == DatalogTab.SELECT_NEXT_BY_PAGE) {
                datalogTab.changeSelection(1, datalogTab.getNextTime(3));
            } else if (this.id == DatalogTab.SELECT_PREVIOUS_BY_PAGE_EXTEND) {
                datalogTab.changeSelection(2, datalogTab.getNextTime(-3));
            } else if (this.id == DatalogTab.SELECT_NEXT_BY_PAGE_EXTEND) {
                datalogTab.changeSelection(2, datalogTab.getNextTime(3));
            } else if (this.id == DatalogTab.SELECT_FIRST) {
                datalogTab.changeSelection(1, 0.0);
            } else if (this.id == DatalogTab.SELECT_FIRST_EXTEND) {
                datalogTab.changeSelection(2, 0.0);
            } else if (this.id == DatalogTab.SELECT_LAST) {
                datalogTab.changeSelection(1, datalogTab.displaySet.getDisplayPacketMaxTime());
            } else if (this.id == DatalogTab.SELECT_LAST_EXTEND) {
                datalogTab.changeSelection(2, datalogTab.displaySet.getDisplayPacketMaxTime());
            } else if (this.id == DatalogTab.SELECT_SCREEN_FIRST) {
                datalogTab.changeSelection(1, datalogTab.navModel.getDisplayStartTime());
            } else if (this.id == DatalogTab.SELECT_SCREEN_FIRST_EXTEND) {
                datalogTab.changeSelection(2, datalogTab.navModel.getDisplayStartTime());
            } else if (this.id == DatalogTab.SELECT_SCREEN_LAST) {
                datalogTab.changeSelection(1, datalogTab.navModel.getDisplayEndTime());
            } else if (this.id == DatalogTab.SELECT_SCREEN_LAST_EXTEND) {
                datalogTab.changeSelection(2, datalogTab.navModel.getDisplayEndTime());
            } else if (this.id == "datalog.selectAll") {
                datalogTab.selectAll();
            } else if (this.id == "datalog.selectNone") {
                datalogTab.selectNone();
            } else if (this.id == "datalog.centerSelection") {
                datalogTab.centerSelection();
            } else if (this.id == "datalog.clipToSelection") {
                datalogTab.clipToSelection();
            } else if (this.id == "datalog.zoomInByFactor") {
                datalogTab.zoomByFactor(-0.1);
            } else if (this.id == "datalog.zoomOutByFactor") {
                datalogTab.zoomByFactor(0.1);
            } else if (this.id == DatalogTab.ZOOM_IN_BY_LARGE_FACTOR) {
                datalogTab.zoomByFactor(-0.2);
            } else if (this.id == DatalogTab.ZOOM_OUT_BY_LARGE_FACTOR) {
                datalogTab.zoomByFactor(0.2);
            }
        }
    }
}

