/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.DisplaySetListener;
import com.ecmtuning.ecmlink.device.data.TimeNavListener;
import com.ecmtuning.ecmlink.device.data.TimeNavModel;
import com.ecmtuning.ecmlink.device.data.TimeSelectionListener;
import com.ecmtuning.ecmlink.device.data.TimeSelectionModel;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import com.ecmtuning.ecmlink.view.main.MainResources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public abstract class DisplaySetView
implements DisplaySetListener,
TimeSelectionListener,
TimeNavListener {
    protected final DatalogTab parentTab;
    protected final Dataset dataset;
    protected final DisplaySet displaySet;
    protected final TimeSelectionModel selectionModel;
    protected final TimeSelectionModel textDisplayTimeModel;
    protected final TimeNavModel navModel;
    TimeSelectionListener displayTimeListener = new TimeSelectionListener(){

        @Override
        public void selectionChanged(double d, double d2) {
            DisplaySetView.this.textDisplayTimeChanged(d);
        }
    };

    protected DisplaySetView(DatalogTab datalogTab) {
        this.parentTab = datalogTab;
        this.dataset = datalogTab.getDataset();
        this.displaySet = new DisplaySet();
        this.displaySet.registerModels(this.dataset, this.parentTab.getConverterPrefs());
        this.selectionModel = datalogTab.getSelectionModel();
        this.textDisplayTimeModel = datalogTab.getTextDisplayTimeModel();
        this.navModel = datalogTab.getNavModel();
    }

    protected void registerModels() {
        this.displaySet.addDisplaySetListener(this);
        this.selectionModel.addTimeSelectionListener(this);
        this.textDisplayTimeModel.addTimeSelectionListener(this.displayTimeListener);
        this.navModel.addTimeNavListener(this);
    }

    protected void deregisterModels() {
        this.navModel.removeTimeNavListener(this);
        this.textDisplayTimeModel.removeTimeSelectionListener(this.displayTimeListener);
        this.selectionModel.removeTimeSelectionListener(this);
        this.displaySet.removeDisplaySetListener(this);
        this.displaySet.deregisterModels();
    }

    public abstract JComponent build();

    public abstract Component getDefaultFocusComponent();

    public abstract void setStreamState(boolean var1);

    public abstract void textDisplayTimeChanged(double var1);

    abstract void ensureVisible(double var1);

    boolean dispatchActionEvent(String string, ActionEvent actionEvent) {
        return false;
    }

    protected void viewShown() {
    }

    protected void viewHidden() {
    }

    protected void viewRemoved() {
        this.deregisterModels();
    }

    protected void pushComponentsToMenu(JMenu jMenu, List list) {
        int n = list.size();
        JPopupMenu jPopupMenu = jMenu.getPopupMenu();
        for (int i = n - 1; i >= 0; --i) {
            Object e = list.get(i);
            if (e instanceof Action) {
                jPopupMenu.insert((Action)e, 0);
                continue;
            }
            if (!(e instanceof Component)) continue;
            jPopupMenu.insert((Component)e, 0);
        }
    }

    protected void popComponentsFromMenu(JMenu jMenu, List list) {
        int n = list.size();
        JPopupMenu jPopupMenu = jMenu.getPopupMenu();
        for (int i = 0; i < n; ++i) {
            jPopupMenu.remove(0);
        }
    }

    DisplaySet getDisplaySet() {
        return this.displaySet;
    }

    static void installTabAction(ActionMap actionMap, String string) {
        actionMap.put(string, DatalogTab.getLocalAction(string));
    }

    static void installMainAction(ActionMap actionMap, String string) {
        actionMap.put(string, MainResources.getAction(string));
    }

    TimeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    TimeNavModel getNavModel() {
        return this.navModel;
    }
}

