/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.device.data.TimeNavModel;
import com.ecmtuning.ecmlink.device.data.TimeSelectionModel;
import com.ecmtuning.ecmlink.view.main.GraphLineBox;
import com.ecmtuning.ecmlink.view.main.GraphView;
import com.ecmtuning.ecmlink.view.main.GraphViewPrefs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JComponent;

public final class Graph
extends JComponent {
    private final DisplaySet displaySet;
    private final TimeSelectionModel timeSelModel;
    private final TimeNavModel timeNavModel;
    private final GraphView view;
    private final GraphViewPrefs viewPrefs;
    int pixelPanelWidth;
    int pixelPanelHeight;
    int pixelPanelRight;
    int pixelPanelBottom;
    double unitPanelCenter;
    double unitPanelWidth;
    double unitPanelLeft;
    double unitsPerPixelX;
    double unitMaxValue;
    int pixelGraphLeft;
    int pixelGraphWidth;
    int pixelGraphRight;
    double unitGraphLeft;
    double unitGraphWidth;
    static final float[] oneByOneDashArray = new float[]{2.0f, 2.0f};

    Graph(GraphView graphView) {
        this.view = graphView;
        this.viewPrefs = graphView.getViewPrefs();
        this.displaySet = graphView.getDisplaySet();
        this.timeSelModel = graphView.getSelectionModel();
        this.timeNavModel = graphView.getNavModel();
    }

    final int clipXToGraphBounds(int n) {
        if (n < this.pixelGraphLeft) {
            return this.pixelGraphLeft;
        }
        if (n > this.pixelGraphRight) {
            return this.pixelGraphRight;
        }
        return n;
    }

    final boolean isXInGraphBounds(int n) {
        return n >= this.pixelGraphLeft && n <= this.pixelGraphRight;
    }

    final double convertXToTime(int n) {
        return this.unitGraphLeft + this.unitsPerPixelX * (double)(n - this.pixelGraphLeft);
    }

    final double convertXDiffToTime(int n) {
        return this.unitsPerPixelX * (double)n;
    }

    final int convertTimeToX(double d) {
        return (int)Math.round((d - this.unitPanelLeft) / this.unitsPerPixelX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final synchronized void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            DisplaySet displaySet = this.displaySet;
            synchronized (displaySet) {
                this.renderGraph(graphics2D);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    private final void renderGraph(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        ArrayList arrayList = this.displaySet.getDisplayPackets();
        Dimension dimension = this.getSize();
        int n4 = dimension.width;
        int n5 = dimension.height;
        int n6 = n4 - 1;
        int n7 = n5 - 1;
        double d = this.timeNavModel.getCenterTime();
        double d2 = this.timeNavModel.getWidthTime();
        double d3 = d - d2 / 2.0;
        double d4 = this.displaySet.getDisplayPacketMaxTime();
        int n8 = 0;
        double d5 = d3;
        double d6 = d2;
        if (d5 < 0.0) {
            d6 -= (d5 *= -1.0);
            n8 = (int)((double)n4 * d5 / d2 + 0.5);
            d5 = 0.0;
        }
        int n9 = n8;
        double d7 = d5;
        if (d5 + d6 > d4) {
            d6 = d4 - d5;
        }
        double d8 = d6;
        n8 = (int)((double)n4 * d8 / d2 + 0.5);
        int n10 = n9 + n8 - 1;
        double d9 = d8 / (double)(n8 - 1);
        this.pixelPanelWidth = n4;
        this.pixelPanelHeight = n5;
        this.pixelPanelRight = n6;
        this.pixelPanelBottom = n7;
        this.unitPanelCenter = d;
        this.unitPanelWidth = d2;
        this.unitPanelLeft = d3;
        this.unitsPerPixelX = d9;
        this.unitMaxValue = d4;
        this.pixelGraphLeft = n9;
        this.pixelGraphWidth = n8;
        this.pixelGraphRight = n10;
        this.unitGraphLeft = d7;
        this.unitGraphWidth = d8;
        graphics2D.setColor(this.viewPrefs.getGraphBackgroundColor());
        graphics2D.fillRect(0, 0, n4, n5);
        graphics2D.setColor(this.getForeground());
        DisplayChainDesc[] displayChainDescArray = this.view.getDescs();
        if (arrayList.size() < 2 || d4 == 0.0) {
            this.drawTextNotice(graphics2D, n4, n5, "NO DATA");
            return;
        }
        if (displayChainDescArray.length == 0) {
            this.drawTextNotice(graphics2D, n4, n5, "NO DISPLAY VALUES");
            return;
        }
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(n9, 0, n8, n5);
        int n11 = arrayList.size();
        int n12 = this.displaySet.getPreviousPacketIndex(d7);
        int n13 = this.displaySet.getNextPacketIndex(d7 + d8);
        int n14 = n13 >= n11 ? n11 - 1 : n13;
        int n15 = n14 - n12 + 1;
        if (n15 < 0) {
            Logger.getLogger(this.getClass().getName()).warning("Graph invalid state, " + n12 + "-" + n14);
            return;
        }
        int[] nArray = new int[n15];
        int[] nArray2 = new int[n15];
        int n16 = n7 - 3;
        float f = n16 - 3 + 1;
        int n17 = displayChainDescArray.length;
        for (n3 = 0; n3 < n17; ++n3) {
            DisplayChainDesc displayChainDesc = displayChainDescArray[n3];
            if (!displayChainDesc.isDisplayable() || !this.viewPrefs.getShowInGraph(displayChainDesc)) continue;
            float f2 = displayChainDesc.getMin().floatValue();
            float f3 = displayChainDesc.getMax().floatValue();
            float f4 = (f3 - f2) / f;
            n2 = Integer.MIN_VALUE;
            n = Integer.MAX_VALUE;
            int n18 = Integer.MIN_VALUE;
            boolean bl = false;
            int n19 = Integer.MAX_VALUE;
            int n20 = Integer.MIN_VALUE;
            int n21 = Integer.MIN_VALUE;
            int n22 = 0;
            for (int i = n12; i <= n14; ++i) {
                TSDataPacket tSDataPacket = (TSDataPacket)arrayList.get(i);
                float f5 = Math.min(f3, Math.max(f2, tSDataPacket.data[n3]));
                int n23 = n9 + (int)(0.5 + (tSDataPacket.timestampMicros - d7) / d9);
                int n24 = n16 - (int)(0.5f + (f5 - f2) / f4);
                if (n24 < 3) {
                    n24 = 3;
                } else if (n24 > n7) {
                    n24 = n7;
                }
                if (n23 == n18) {
                    if (!bl) {
                        bl = true;
                        n19 = Math.min(nArray2[n22 - 1], n24);
                        n20 = Math.max(nArray2[n22 - 1], n24);
                    } else {
                        n19 = Math.min(n19, n24);
                        n20 = Math.max(n20, n24);
                    }
                    n21 = n24;
                    continue;
                }
                if (bl) {
                    bl = false;
                    if (n19 != n20) {
                        int n25 = n19;
                        int n26 = n20;
                        int n27 = nArray2[n22 - 1];
                        int n28 = n21;
                        if (n27 == n25) {
                            nArray[n22] = n18;
                            nArray2[n22++] = n26;
                            if (n28 != n26) {
                                nArray[n22] = n18;
                                nArray2[n22++] = n28;
                            }
                        } else if (n27 == n26) {
                            nArray[n22] = n18;
                            nArray2[n22++] = n25;
                            if (n28 != n25) {
                                nArray[n22] = n18;
                                nArray2[n22++] = n28;
                            }
                        } else if (n28 == n25) {
                            nArray[n22] = n18;
                            nArray2[n22++] = n26;
                            nArray[n22] = n18;
                            nArray2[n22++] = n25;
                        } else if (n28 == n26) {
                            nArray[n22] = n18;
                            nArray2[n22++] = n25;
                            nArray[n22] = n18;
                            nArray2[n22++] = n26;
                        } else {
                            nArray[n22] = n18;
                            nArray2[n22++] = n25;
                            nArray[n22] = n18;
                            nArray2[n22++] = n26;
                            nArray[n22] = n18;
                            nArray2[n22++] = n28;
                        }
                    }
                    if (n22 > 1) {
                        n2 = nArray2[n22 - 1];
                        n = nArray2[n22 - 2];
                    } else {
                        n = Integer.MIN_VALUE;
                        n2 = Integer.MIN_VALUE;
                    }
                }
                n18 = n23;
                if (n2 == n24 && n2 == n) {
                    nArray[n22 - 1] = n23;
                    continue;
                }
                nArray[n22] = n23;
                nArray2[n22++] = n24;
                n = n2;
                n2 = n24;
            }
            if (n22 <= true) continue;
            graphics2D.setColor(this.viewPrefs.getLineColor(displayChainDesc));
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(GraphLineBox.createLineStroke(this.viewPrefs.getThickLine(displayChainDesc), this.viewPrefs.getDashedLine(displayChainDesc)));
            graphics2D.drawPolyline(nArray, nArray2, n22);
            graphics2D.setStroke(stroke);
        }
        if (this.timeSelModel.isSelectionActive()) {
            if (this.timeSelModel.isMomentSelection()) {
                graphics2D.setColor(Color.white);
                double d10 = this.timeSelModel.getAnchorTime();
                int n29 = n9 + (int)(0.5 + (d10 - d7) / d9);
                graphics2D.drawLine(n29, 0, n29, n7);
            } else {
                double d11 = this.timeSelModel.getAnchorTime();
                double d12 = this.timeSelModel.getExtentTime();
                int n30 = n9 + (int)(0.5 + (d11 - d7) / d9);
                n2 = n9 + (int)(0.5 + (d12 - d7) / d9);
                if (!(n30 < n9 && n2 < n9 || n30 > n10 && n2 > n10)) {
                    if (n2 < n30) {
                        n = n30;
                        n30 = n2;
                        n2 = n;
                    }
                    graphics2D.setColor(this.viewPrefs.getSelectColor());
                    graphics2D.fillRect(n30, 0, n2 - n30 + 1, n5);
                    graphics2D.setColor(this.viewPrefs.getSelectColor().brighter());
                    graphics2D.drawRect(n30, 0, n2 - n30, n5 - 1);
                }
            }
        }
        graphics2D.setClip(shape);
        if (n9 > 0) {
            this.drawHashArea(graphics2D, 0, 0, n9, n5, false);
            n3 = n9 - 1;
            int n31 = n5 - 1;
            graphics2D.setColor(this.viewPrefs.getHashMarkColor().brighter());
            graphics2D.drawLine(0, 0, n3, 0);
            graphics2D.drawLine(n3, 0, n3, n31);
            graphics2D.drawLine(n3 - 1, 0, n3 - 1, n31);
            graphics2D.drawLine(n3, n31, 0, n31);
        }
        if (n10 < n6) {
            this.drawHashArea(graphics2D, n10 + 1, 0, n6 - n10, n5, true);
            n3 = n10 + 1;
            int n32 = n4 - 1;
            int n33 = n5 - 1;
            graphics2D.setColor(this.viewPrefs.getHashMarkColor().brighter());
            graphics2D.drawLine(n3, 0, n3, n33);
            graphics2D.drawLine(n3 + 1, 0, n3 + 1, n33);
            graphics2D.drawLine(n3, n33, n32, n33);
            graphics2D.drawLine(n32, n33, n32, 0);
        }
        if (!this.timeSelModel.isSelectionActive()) {
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 5.0f, oneByOneDashArray, 0.0f);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(this.viewPrefs.getHashMarkColor().brighter());
            int n34 = n6 / 2;
            if (n34 < n9) {
                n34 = n9;
            }
            graphics2D.drawLine(n34, 0, n34, n7);
            graphics2D.setStroke(stroke);
        }
    }

    static final boolean isInBounds(double d, double d2, double d3) {
        return d >= d2 && d < d2 + d3;
    }

    private final void drawHashArea(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.viewPrefs.getHashMarkColor());
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(n, n2, n3, n4);
        int n7 = n6;
        if (!bl) {
            for (int i = n - n7; i < n5; i += 8) {
                graphics2D.drawLine(i, 0, i + n7, n6);
                graphics2D.drawLine(i, n6, i + n7, 0);
            }
        } else {
            for (int i = n5 + n7; i > n; i -= 8) {
                graphics2D.drawLine(i, 0, i - n7, n6);
                graphics2D.drawLine(i, n6, i - n7, 0);
            }
        }
        graphics2D.setClip(shape);
        graphics2D.setColor(color);
    }

    private final void drawTextNotice(Graphics2D graphics2D, int n, int n2, String string) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(new Color(0.5f, 0.5f, 0.5f, 0.3f));
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont((float)n / 10.0f).deriveFont(1);
        graphics2D.setFont(font2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        int n3 = (n - (int)rectangle2D.getWidth()) / 2;
        int n4 = (n2 - (int)rectangle2D.getHeight()) / 2 + fontMetrics.getAscent();
        graphics2D.drawString(string, n3, n4);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }
}

