/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DatasetManager;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.main.MainResources;
import com.ecmtuning.ecmlink.view.main.ManualAddDialog;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;

public class GraphDisplayedValuesDialog
extends AbstractDialog {
    private final ArrayListModel availableItems = new ArrayListModel();
    private final ArrayListModel toDisplayItems = new ArrayListModel();
    private JList availableList;
    private JList toDisplayList;
    private final LocationTOC mainDatasetTOC;
    private final LocationTOC auxDatasetTOC;
    private LocationTOC mainLiveTOC = LocationTOC.EMPTY_TOC;
    private LocationTOC auxLiveTOC = LocationTOC.EMPTY_TOC;
    private final boolean isLive;
    private ValueHolder useAsDefaultModel = new ValueHolder(false);
    protected static final String helpID = "displayvalues";
    protected JButton helpButton = DialogUtil.createDefaultHelpButton("displayvalues");
    JComponent contentPanel;

    public GraphDisplayedValuesDialog(Frame frame, Dataset dataset, DisplayChain[] displayChainArray) {
        super(frame);
        DisplayItem displayItem;
        this.checkBundles();
        this.isLive = dataset.isLiveDataset();
        if (displayChainArray != null && displayChainArray.length > 0) {
            for (int i = 0; i < displayChainArray.length; ++i) {
                displayItem = new DisplayItem(displayChainArray[i]);
                this.toDisplayItems.add((Object)displayItem);
            }
        }
        this.mainDatasetTOC = dataset.getMainDataTOC() == null ? LocationTOC.EMPTY_TOC : dataset.getMainDataTOC();
        this.auxDatasetTOC = dataset.getAuxDataTOC() == null ? LocationTOC.EMPTY_TOC : dataset.getAuxDataTOC();
        this.refreshLiveTOCs();
        this.refreshLists();
        this.setTitle(MainResources.getString("displayvalues.title"));
        MainModel mainModel = MainModel.getInstance();
        displayItem = mainModel.getHelpBroker();
        if (displayItem != null) {
            JRootPane jRootPane = this.getRootPane();
            displayItem.enableHelpKey(jRootPane, helpID, null);
        }
    }

    protected void setResizable() {
        this.setResizable(true);
    }

    private void checkBundles() {
        if (MainResources.resourceBundle == null) {
            throw new IllegalStateException("ResourceBundle for '" + GraphDisplayedValuesDialog.class.getName() + "' failed to load");
        }
        if (MainResources.actionBundle == null) {
            throw new IllegalStateException("ActionBundle for '" + GraphDisplayedValuesDialog.class.getName() + "' failed to load");
        }
    }

    public DisplayChain[] getChainsToDisplay() {
        DisplayChain[] displayChainArray = new DisplayChain[this.toDisplayItems.size()];
        for (int i = 0; i < displayChainArray.length; ++i) {
            displayChainArray[i] = ((DisplayItem)this.toDisplayItems.get((int)i)).chain;
        }
        return displayChainArray;
    }

    public boolean useAsDefaultSelected() {
        return this.useAsDefaultModel.booleanValue();
    }

    public void setUseAsDefault(boolean bl) {
        this.useAsDefaultModel.setValue(bl);
    }

    private void refreshLiveTOCs() {
        if (this.isLive) {
            try {
                this.mainLiveTOC = new LocationTOC(DatasetManager.getInstance().getLiveMainTOC());
            }
            catch (Exception exception) {
                // empty catch block
            }
            DeviceManager deviceManager = DeviceManagerFactory.getInstance().getAuxDeviceManager();
            if (deviceManager != null) {
                try {
                    this.auxLiveTOC = new LocationTOC(DatasetManager.getInstance().getLiveAuxTOC());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void refreshLists() {
        ArrayList arrayList = new ArrayList();
        this.pushDisplayItems(this.mainDatasetTOC, arrayList);
        this.pushDisplayItems(this.auxDatasetTOC, arrayList);
        this.pushDisplayItems(this.mainLiveTOC, arrayList);
        this.pushDisplayItems(this.auxLiveTOC, arrayList);
        Iterator iterator = this.availableItems.iterator();
        while (iterator.hasNext()) {
            DisplayItem displayItem = (DisplayItem)iterator.next();
            if (displayItem.isInList(arrayList, true)) continue;
            iterator.remove();
        }
        for (DisplayItem displayItem : arrayList) {
            if (displayItem.isInList((List)this.toDisplayItems)) continue;
            displayItem.insertIfNew((List)this.availableItems);
        }
        this.registerTOCs(this.availableItems);
        this.registerTOCs(this.toDisplayItems);
    }

    private void registerTOCs(ArrayListModel arrayListModel) {
        int n = arrayListModel.size();
        for (int i = 0; i < n; ++i) {
            DisplayItem displayItem = (DisplayItem)arrayListModel.get(i);
            boolean bl = displayItem.chain.isDisplayable();
            displayItem.chain.registerTOC(this.mainDatasetTOC, this.auxDatasetTOC);
            if (bl == displayItem.chain.isDisplayable()) continue;
            arrayListModel.fireContentsChanged(i);
        }
    }

    private void pushDisplayItems(LocationTOC locationTOC, List list) {
        if (locationTOC == null) {
            return;
        }
        List list2 = DisplayChain.generateDisplayChains(locationTOC);
        for (DisplayChain displayChain : list2) {
            DisplayItem displayItem = new DisplayItem(displayChain);
            displayItem.insertIfNew(list);
        }
    }

    protected synchronized JComponent buildContent() {
        if (this.contentPanel == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.buildCenterPanel(), "Center");
            jPanel.add((Component)this.buildButtonBarWithOKCancelAnd(this.helpButton), "South");
            this.contentPanel = jPanel;
        }
        return this.contentPanel;
    }

    private Component buildCenterPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(new ColumnSpec("fill:max(min;100dlu):grow"));
        arrayList.add(DialogUtil.UNRELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.UNRELATED_GAP_COLSPEC);
        arrayList.add(new ColumnSpec("fill:max(min;100dlu):grow"));
        ArrayList<RowSpec> arrayList2 = new ArrayList<RowSpec>();
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        arrayList2.add(DialogUtil.RELATED_GAP_ROWSPEC);
        arrayList2.add(new RowSpec("fill:max(min;150dlu):grow"));
        arrayList2.add(DialogUtil.RELATED_GAP_ROWSPEC);
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{{1, 5}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(MainResources.getString("displayvalues.availablelist.title"), cellConstraints.xy(1, 1));
        panelBuilder.addSeparator(MainResources.getString("displayvalues.todisplaylist.title"), cellConstraints.xy(5, 1));
        DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer();
        this.availableList = new JList();
        this.availableList.setModel(this.availableItems);
        this.availableList.setCellRenderer(displayItemRenderer);
        panelBuilder.add((Component)new JScrollPane(this.availableList), cellConstraints.xy(1, 3));
        this.toDisplayList = new JList();
        this.toDisplayList.setModel(this.toDisplayItems);
        this.toDisplayList.setCellRenderer(displayItemRenderer);
        panelBuilder.add((Component)new JScrollPane(this.toDisplayList), cellConstraints.xy(5, 3));
        JCheckBox jCheckBox = BasicComponentFactory.createCheckBox((ValueModel)this.useAsDefaultModel, (String)MainResources.getStringDef("displayvalues.useasdefault.text", "Use as default"));
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addGridded((JComponent)new JButton(new AddToDisplayAction()));
        buttonStackBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        buttonStackBuilder.nextRow();
        buttonStackBuilder.addGridded((JComponent)new JButton(new RemoveAction()));
        buttonStackBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        buttonStackBuilder.nextRow();
        buttonStackBuilder.addGridded((JComponent)new JButton(new ManualAddAction()));
        buttonStackBuilder.addGlue();
        buttonStackBuilder.addGridded((JComponent)new JButton(new LoadAction()));
        buttonStackBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        buttonStackBuilder.nextRow();
        buttonStackBuilder.addGridded((JComponent)new JButton(new SaveAction()));
        buttonStackBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        buttonStackBuilder.nextRow();
        buttonStackBuilder.addGridded((JComponent)jCheckBox);
        panelBuilder.add((Component)buttonStackBuilder.getPanel(), cellConstraints.xy(3, 3));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixed((JComponent)new JButton(new MoveItemsAction(true)));
        buttonBarBuilder.addFixed((JComponent)new JButton(new MoveItemsAction(false)));
        panelBuilder.add((Component)buttonBarBuilder.getPanel(), cellConstraints.xy(5, 5));
        return panelBuilder.getPanel();
    }

    private static class DisplayItemRenderer
    extends DefaultListCellRenderer {
        private DisplayItemRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            DisplayItem displayItem = (DisplayItem)object;
            if (displayItem.isRawItem()) {
                DialogUtil.makeItalic(this);
            } else if (displayItem.isDisplayable()) {
                DialogUtil.makeBold(this);
            } else {
                this.setEnabled(false);
            }
            return this;
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            MainResources.configureAction(this, "displayvalues.save");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class LoadAction
    extends AbstractAction {
        LoadAction() {
            MainResources.configureAction(this, "displayvalues.load");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ManualAddAction
    extends AbstractAction {
        ManualAddAction() {
            MainResources.configureAction(this, "displayvalues.manualadd");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object2;
            ArrayListModel arrayListModel = new ArrayListModel();
            this.addRawDisplayItems(GraphDisplayedValuesDialog.this.mainDatasetTOC, arrayListModel);
            this.addRawDisplayItems(GraphDisplayedValuesDialog.this.auxDatasetTOC, arrayListModel);
            this.addRawDisplayItems(GraphDisplayedValuesDialog.this.mainLiveTOC, arrayListModel);
            this.addRawDisplayItems(GraphDisplayedValuesDialog.this.auxLiveTOC, arrayListModel);
            for (Object object2 : GraphDisplayedValuesDialog.this.toDisplayItems) {
                ((DisplayItem)object2).removeFromList((List)arrayListModel);
            }
            object2 = new ManualAddDialog((JDialog)((Object)GraphDisplayedValuesDialog.this), arrayListModel);
            object2.open();
            if (!object2.hasBeenCanceled()) {
                List list = ((ManualAddDialog)((Object)object2)).getSelectedTOCItems();
                for (DisplayItem displayItem : list) {
                    displayItem.setDisplayText(null);
                }
                GraphDisplayedValuesDialog.this.toDisplayItems.addAll((Collection)((ManualAddDialog)((Object)object2)).getSelectedTOCItems());
            }
        }

        private void addRawDisplayItems(LocationTOC locationTOC, ArrayListModel arrayListModel) {
            if (locationTOC != null) {
                List list = locationTOC.getTOCEntries();
                for (LocationTOCEntry locationTOCEntry : list) {
                    DisplayChain displayChain = DisplayChain.createRawChain(locationTOCEntry.getLocation());
                    DisplayItem displayItem = new DisplayItem(displayChain);
                    displayItem.setDisplayText(locationTOCEntry.getListDisplayName());
                    displayItem.insertIfNew((List)arrayListModel);
                }
            }
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        RemoveAction() {
            MainResources.configureAction(this, "displayvalues.remove");
            JList jList = GraphDisplayedValuesDialog.this.toDisplayList;
            DialogUtil.registerListSelectionEnabler(jList.getSelectionModel(), this);
            DialogUtil.registerDoubleClickHandler(jList, this);
            this.setEnabled(false);
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = GraphDisplayedValuesDialog.this.toDisplayList.getSelectedIndices();
            Arrays.sort(nArray);
            for (n = 0; n < nArray.length; ++n) {
                DisplayItem displayItem = (DisplayItem)GraphDisplayedValuesDialog.this.toDisplayItems.get(nArray[n]);
                if (displayItem.chain.isRawChain()) continue;
                displayItem.insertIfNew((List)GraphDisplayedValuesDialog.this.availableItems);
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                GraphDisplayedValuesDialog.this.toDisplayItems.remove(nArray[n]);
            }
        }
    }

    private final class AddToDisplayAction
    extends AbstractAction {
        AddToDisplayAction() {
            MainResources.configureAction(this, "displayvalues.add");
            JList jList = GraphDisplayedValuesDialog.this.availableList;
            DialogUtil.registerListSelectionEnabler(jList.getSelectionModel(), this);
            DialogUtil.registerDoubleClickHandler(jList, this);
            this.setEnabled(false);
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = GraphDisplayedValuesDialog.this.availableList.getSelectedIndices();
            Arrays.sort(nArray);
            for (n = 0; n < nArray.length; ++n) {
                DisplayItem displayItem = (DisplayItem)GraphDisplayedValuesDialog.this.availableItems.get(nArray[n]);
                GraphDisplayedValuesDialog.this.toDisplayItems.add((Object)displayItem);
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                GraphDisplayedValuesDialog.this.availableItems.remove(nArray[n]);
            }
        }
    }

    private final class MoveItemsAction
    extends AbstractAction {
        final boolean moveUp;

        MoveItemsAction(boolean bl) {
            this.moveUp = bl;
            MainResources.configureAction(this, bl ? "displayvalues.moveup" : "displayvalues.movedown");
            JList jList = GraphDisplayedValuesDialog.this.toDisplayList;
            DialogUtil.registerListSelectionEnabler(jList.getSelectionModel(), this);
            this.setEnabled(false);
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (GraphDisplayedValuesDialog.this.toDisplayItems.size() < 2) {
                return;
            }
            int[] nArray = GraphDisplayedValuesDialog.this.toDisplayList.getSelectedIndices();
            Arrays.sort(nArray);
            if (this.moveUp && nArray[0] == 0) {
                return;
            }
            if (!this.moveUp && nArray[nArray.length - 1] == GraphDisplayedValuesDialog.this.toDisplayItems.getSize() - 1) {
                return;
            }
            GraphDisplayedValuesDialog.this.toDisplayList.clearSelection();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (n = 0; n < nArray.length; ++n) {
                arrayList.add(GraphDisplayedValuesDialog.this.toDisplayItems.remove(nArray[n] - n));
            }
            for (n = 0; n < nArray.length; ++n) {
                int n2 = nArray[n] + (this.moveUp ? -1 : 1);
                if (n2 < 0) {
                    n2 = 0;
                }
                GraphDisplayedValuesDialog.this.toDisplayItems.add(n2, arrayList.get(n));
                GraphDisplayedValuesDialog.this.toDisplayList.getSelectionModel().addSelectionInterval(n2, n2);
            }
        }
    }

    private final class EditPrefsAction
    extends AbstractAction {
        EditPrefsAction() {
            MainResources.configureAction(this, "displayvalues.prefs");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    static final class DisplayItem {
        final DisplayChain chain;
        final DisplayChainDesc desc;
        final String displayCompareName;
        String displayText;
        static final Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((DisplayItem)object).compareTo((DisplayItem)object2);
            }
        };

        DisplayItem(DisplayChain displayChain) {
            this.chain = displayChain;
            this.desc = displayChain.getCurrentChainDesc();
            this.displayCompareName = this.desc.getDisplayName().toLowerCase();
        }

        int compareTo(DisplayItem displayItem) {
            return this.displayCompareName.compareTo(displayItem.displayCompareName);
        }

        boolean isRawItem() {
            return this.chain.isRawChain();
        }

        boolean isDisplayable() {
            return this.chain.isDisplayable();
        }

        boolean isInList(List list, boolean bl) {
            String string = this.chain.getChainKeySpec();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DisplayItem displayItem = (DisplayItem)iterator.next();
                String string2 = displayItem.chain.getChainKeySpec();
                if (!string.equals(string2)) continue;
                if (bl) {
                    iterator.remove();
                }
                return true;
            }
            return false;
        }

        boolean isInList(List list) {
            return this.isInList(list, false);
        }

        void removeFromList(List list) {
            this.isInList(list, true);
        }

        void insertIfNew(List list) {
            if (!this.isInList(list)) {
                int n = Collections.binarySearch(list, this, comparator);
                if (n < 0) {
                    n = -n - 1;
                }
                list.add(n, this);
            }
        }

        public void setDisplayText(String string) {
            this.displayText = string;
        }

        public String toString() {
            return this.displayText == null ? this.desc.getDisplayName() : this.displayText;
        }

        static final void sort(List list) {
            Collections.sort(list, comparator);
        }
    }
}

