/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.main.GraphLineBox;
import com.ecmtuning.ecmlink.view.main.GraphView;
import com.ecmtuning.ecmlink.view.main.GraphViewPrefs;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class GraphLegend
extends JPanel {
    private final GraphView view;
    private final GraphViewPrefs viewPrefs;
    LegendItem[] legendItems = new LegendItem[0];
    ArrayList columnSeparators = new ArrayList();
    ArrayList rowSeparators = new ArrayList();
    boolean reconfigScheduled = false;
    Runnable reconfigRunnable = new Runnable(){

        @Override
        public void run() {
            GraphLegend.this.reconfigureLayout();
        }
    };
    Object reconfigMutex = new Object();
    boolean updateUIScheduled = false;
    Runnable updateUIRunnable = new Runnable(){

        @Override
        public void run() {
            GraphLegend.this.updateLegendUI();
        }
    };
    Object updateUIMutex = new Object();
    public static final String SELECT_PREVIOUS = "selectPrevious";
    public static final String SELECT_NEXT = "selectNext";
    public static final String SELECT_UP = "selectUp";
    public static final String SELECT_DOWN = "selectDown";
    public static final String TOGGLE_SHOW_IN_GRAPH = "toggleShowInGraph";
    Action toggleShowInGraphAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphLineBox graphLineBox = (GraphLineBox)actionEvent.getSource();
            GraphLegend.this.toggleShowInGraph(graphLineBox);
        }
    };
    private final Action selectPreviousAction = new FocusTransferAction(-1, 0);
    private final Action selectNextAction = new FocusTransferAction(1, 0);
    private final Action selectUpAction = new FocusTransferAction(0, -1);
    private final Action selectDownAction = new FocusTransferAction(0, 1);
    KeyListener lineBoxKeyListener = new KeyListener(){
        boolean spaceDown;

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.process(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.process(keyEvent);
        }

        protected void process(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                this.spaceDown = keyEvent.getKeyChar() == ' ';
                GraphLineBox graphLineBox = (GraphLineBox)keyEvent.getSource();
                graphLineBox.setDrawAsPressed(this.spaceDown);
                graphLineBox.repaint();
            } else if (keyEvent.getID() == 402 && this.spaceDown && keyEvent.getKeyChar() == ' ') {
                this.spaceDown = false;
                GraphLineBox graphLineBox = (GraphLineBox)keyEvent.getSource();
                graphLineBox.setDrawAsPressed(this.spaceDown);
                graphLineBox.repaint();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    };
    MouseAdapter lineBoxMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            GraphLineBox graphLineBox = (GraphLineBox)mouseEvent.getSource();
            graphLineBox.setDrawAsFocused(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            GraphLineBox graphLineBox = (GraphLineBox)mouseEvent.getSource();
            graphLineBox.setDrawAsFocused(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            GraphLineBox graphLineBox = (GraphLineBox)mouseEvent.getSource();
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isPopupTrigger()) {
                graphLineBox.setDrawAsPressed(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            GraphLineBox graphLineBox = (GraphLineBox)mouseEvent.getSource();
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isPopupTrigger()) {
                graphLineBox.setDrawAsPressed(false);
                if (graphLineBox.contains(mouseEvent.getPoint())) {
                    GraphLegend.this.toggleShowInGraph(graphLineBox);
                }
            }
        }
    };

    GraphLegend(GraphView graphView) {
        this.view = graphView;
        this.viewPrefs = graphView.getViewPrefs();
    }

    synchronized void clearData() {
        int n = this.legendItems.length;
        for (int i = 0; i < n; ++i) {
            this.legendItems[i].valueLbl.setText("");
        }
    }

    synchronized LegendItem findLegendItem(GraphLineBox graphLineBox) {
        for (int i = 0; i < this.legendItems.length; ++i) {
            LegendItem legendItem = this.legendItems[i];
            if (legendItem.lineBox != graphLineBox) continue;
            return legendItem;
        }
        return null;
    }

    synchronized DisplayChainDesc findDescAt(Point point) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.columnSeparators.size(); ++n2) {
            JSeparator jSeparator = (JSeparator)this.columnSeparators.get(n2);
            if (point.x < jSeparator.getX()) continue;
            n3 = n2 + 1;
        }
        n2 = 0;
        for (n = 0; n < this.rowSeparators.size(); ++n) {
            JSeparator jSeparator = (JSeparator)this.rowSeparators.get(n);
            if (point.y < jSeparator.getY()) continue;
            n2 = n + 1;
        }
        n = n2 * (this.columnSeparators.size() + 1) + n3;
        if (n < this.legendItems.length) {
            return this.legendItems[n].desc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleReconfig() {
        Object object = this.reconfigMutex;
        synchronized (object) {
            if (!this.reconfigScheduled) {
                SwingUtilities.invokeLater(this.reconfigRunnable);
                this.reconfigScheduled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleUpdateUI() {
        Object object = this.updateUIMutex;
        synchronized (object) {
            if (!this.updateUIScheduled) {
                SwingUtilities.invokeLater(this.updateUIRunnable);
                this.updateUIScheduled = true;
            }
        }
    }

    synchronized void updateData(float[] fArray) {
        if (fArray.length != this.legendItems.length || this.legendItems.length == 0) {
            return;
        }
        int n = this.legendItems.length;
        for (int i = 0; i < n; ++i) {
            LegendItem legendItem = this.legendItems[i];
            if (legendItem.enabled && fArray[i] != Float.MIN_VALUE) {
                legendItem.valueLbl.setText(legendItem.desc.format(fArray[i]));
                continue;
            }
            legendItem.valueLbl.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void reconfigureLayout() {
        this.reconfigScheduled = false;
        this.removeAll();
        GraphView graphView = this.view;
        synchronized (graphView) {
            this._reconfigureLayout();
        }
        this.repaint();
    }

    private void _reconfigureLayout() {
        JSeparator jSeparator;
        int n;
        ActionMap actionMap;
        GraphLineBox graphLineBox;
        int n2;
        DisplayChainDesc[] displayChainDescArray = this.view.getDescs();
        int n3 = displayChainDescArray.length;
        this.legendItems = new LegendItem[n3];
        if (n3 == 0) {
            return;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.legendItems[n2] = new LegendItem();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            graphLineBox = this.legendItems[n2].lineBox;
            actionMap = graphLineBox.getActionMap();
            actionMap.put(SELECT_NEXT, this.selectNextAction);
            actionMap.put(SELECT_PREVIOUS, this.selectPreviousAction);
            actionMap.put(SELECT_UP, this.selectUpAction);
            actionMap.put(SELECT_DOWN, this.selectDownAction);
            actionMap.put(TOGGLE_SHOW_IN_GRAPH, this.toggleShowInGraphAction);
            InputMap inputMap = graphLineBox.getInputMap(0);
            inputMap.put(KeyStroke.getKeyStroke(39, 0), SELECT_NEXT);
            inputMap.put(KeyStroke.getKeyStroke(37, 0), SELECT_PREVIOUS);
            inputMap.put(KeyStroke.getKeyStroke(38, 0), SELECT_UP);
            inputMap.put(KeyStroke.getKeyStroke(40, 0), SELECT_DOWN);
            inputMap.put(KeyStroke.getKeyStroke(32, 0), TOGGLE_SHOW_IN_GRAPH);
        }
        n2 = this.viewPrefs.getLegendColumnCount();
        graphLineBox = FormFactory.createGapColumnSpec((ConstantSize)Sizes.DLUX2);
        actionMap = FormFactory.createGapRowSpec((ConstantSize)Sizes.DLUY2);
        int[] nArray = new int[n2];
        ArrayList<GraphLineBox> arrayList = new ArrayList<GraphLineBox>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(graphLineBox);
            arrayList.add((GraphLineBox)new ColumnSpec((Size)Sizes.dluX((int)16)));
            arrayList.add(graphLineBox);
            arrayList.add((GraphLineBox)DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
            arrayList.add(graphLineBox);
            arrayList.add((GraphLineBox)DialogUtil.FILL_MIN_GROW_COLSPEC);
            arrayList.add(graphLineBox);
            arrayList.add((GraphLineBox)DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
            if (i == n2 - 1) {
                arrayList.add(graphLineBox);
            } else {
                arrayList.add(graphLineBox);
                arrayList.add((GraphLineBox)DialogUtil.CENTERED_PREF_NOGROW_COLSPEC);
            }
            nArray[i] = 6 + i * 10;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n4 = 1 + (n3 - 1) / n2;
        for (int i = 0; i < n4; ++i) {
            arrayList2.add(FormFactory.createGapRowSpec((ConstantSize)Sizes.DLUY3));
            arrayList2.add(DialogUtil.CENTER_PREF_NOGROW_ROWSPEC);
            if (i == n4 - 1) {
                arrayList2.add(actionMap);
                continue;
            }
            arrayList2.add(actionMap);
            arrayList2.add(DialogUtil.CENTER_PREF_NOGROW_ROWSPEC);
        }
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{nArray});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        CellConstraints cellConstraints = new CellConstraints();
        this.columnSeparators.clear();
        for (n = 0; n < n2 - 1; ++n) {
            jSeparator = new JSeparator(1);
            this.columnSeparators.add(jSeparator);
            panelBuilder.add((Component)jSeparator, cellConstraints.xywh(10 + n * 10, 1, 1, arrayList2.size()));
        }
        this.rowSeparators.clear();
        for (n = 0; n < n4 - 1; ++n) {
            jSeparator = new JSeparator(0);
            this.rowSeparators.add(jSeparator);
            panelBuilder.add((Component)jSeparator, cellConstraints.xyw(1, 4 + n * 4, arrayList.size()));
        }
        for (n = 0; n < n3; ++n) {
            int n5 = n % n2 * 10;
            int n6 = n / n2 * 4;
            LegendItem legendItem = this.legendItems[n];
            panelBuilder.add((Component)legendItem.lineBox, cellConstraints.xy(n5 + 2, n6 + 2, CellConstraints.FILL, CellConstraints.FILL));
            panelBuilder.add((Component)legendItem.nameLbl, cellConstraints.xy(n5 + 4, n6 + 2));
            panelBuilder.add((Component)legendItem.valueLbl, cellConstraints.xy(n5 + 6, n6 + 2));
            panelBuilder.add((Component)legendItem.unitsLbl, cellConstraints.xy(n5 + 8, n6 + 2));
        }
        this.updateLegendUI();
    }

    public synchronized void updateLegendUI() {
        this.updateUIScheduled = false;
        this._updateLegendUI();
    }

    private void _updateLegendUI() {
        DisplayChainDesc[] displayChainDescArray = this.view.getDescs();
        Font font = this.viewPrefs.getLegendFont().deriveFont(1);
        Font font2 = this.viewPrefs.getLegendFont().deriveFont(2);
        if (displayChainDescArray == null || font == null || font2 == null || this.legendItems == null || displayChainDescArray.length != this.legendItems.length) {
            return;
        }
        for (int i = 0; i < this.legendItems.length; ++i) {
            LegendItem legendItem = this.legendItems[i];
            legendItem.updateLegendUI(displayChainDescArray[i], font, font2);
        }
        this.view.setDisplayedLegendValues();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.viewPrefs.getAntialiasedText()) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintComponent(graphics);
    }

    void toggleShowInGraph(GraphLineBox graphLineBox) {
        LegendItem legendItem = this.findLegendItem(graphLineBox);
        if (legendItem != null) {
            graphLineBox.setShowInGraph(!graphLineBox.showInGraph);
            this.viewPrefs.setShowInGraph(legendItem.desc, graphLineBox.showInGraph);
        }
    }

    private class LegendItem {
        final JLabel nameLbl = new JLabel();
        final JLabel valueLbl = new JLabel();
        final JLabel unitsLbl = new JLabel();
        final GraphLineBox lineBox = new GraphLineBox();
        DisplayChainDesc desc;
        boolean enabled;
        boolean showInGraph;

        LegendItem() {
            this.lineBox.addMouseListener(GraphLegend.this.lineBoxMouseListener);
            this.lineBox.addKeyListener(GraphLegend.this.lineBoxKeyListener);
        }

        void updateLegendUI(DisplayChainDesc displayChainDesc, Font font, Font font2) {
            this.desc = displayChainDesc;
            this.enabled = displayChainDesc.isDisplayable();
            this.showInGraph = GraphLegend.this.viewPrefs.getShowInGraph(displayChainDesc);
            int n = GraphLegend.this.viewPrefs.getLegendFontSizeOverride(displayChainDesc);
            if (n != -1) {
                font2 = font2.deriveFont((float)n);
                font = font.deriveFont((float)n);
            }
            Color color = GraphLegend.this.viewPrefs.getLabelColor(displayChainDesc);
            this.nameLbl.setText(displayChainDesc.getDisplayName());
            this.nameLbl.setFont(displayChainDesc.isRawChain() ? font2 : font);
            this.nameLbl.setEnabled(this.enabled);
            this.nameLbl.setForeground(color);
            this.valueLbl.setText("");
            this.valueLbl.setFont(displayChainDesc.isRawChain() ? font2 : font);
            this.valueLbl.setEnabled(this.enabled);
            this.valueLbl.setHorizontalAlignment(4);
            this.valueLbl.setForeground(color);
            this.unitsLbl.setText(displayChainDesc.getUnits());
            this.unitsLbl.setFont(font2);
            this.unitsLbl.setEnabled(this.enabled);
            this.unitsLbl.setForeground(color);
            this.lineBox.setGraphBGColor(GraphLegend.this.viewPrefs.getGraphBackgroundColor());
            this.lineBox.setLineColor(GraphLegend.this.viewPrefs.getLineColor(displayChainDesc));
            this.lineBox.setThickLine(GraphLegend.this.viewPrefs.getThickLine(displayChainDesc));
            this.lineBox.setDashedLine(GraphLegend.this.viewPrefs.getDashedLine(displayChainDesc));
            this.lineBox.setEnabled(this.enabled);
            this.lineBox.setShowInGraph(this.showInGraph);
        }
    }

    class FocusTransferAction
    extends AbstractAction {
        final int xoff;
        final int yoff;

        public FocusTransferAction(int n, int n2) {
            this.xoff = n;
            this.yoff = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphLegend graphLegend = GraphLegend.this;
            synchronized (graphLegend) {
                int n;
                int n2 = GraphLegend.this.legendItems.length;
                int n3 = GraphLegend.this.viewPrefs.getLegendColumnCount();
                int n4 = n2 / n3 + (n2 % n3 == 0 ? 0 : 1);
                int n5 = -1;
                for (n = 0; n < n2; ++n) {
                    if (GraphLegend.this.legendItems[n].lineBox != actionEvent.getSource()) continue;
                    n5 = n;
                    break;
                }
                if (n5 == -1) {
                    return;
                }
                n = n5 % n3;
                int n6 = n5 / n3;
                int n7 = n;
                int n8 = n6;
                int n9 = Integer.MAX_VALUE;
                while (n9 != n5) {
                    n7 += this.xoff;
                    n8 += this.yoff;
                    while (n7 < 0) {
                        n7 += n3;
                    }
                    while (n8 < 0) {
                        n8 += n4;
                    }
                    n9 = (n8 %= n4) * n3 + (n7 %= n3);
                    if (n9 >= n2 || !GraphLegend.this.legendItems[n9].lineBox.isEnabled()) continue;
                }
                GraphLegend.this.legendItems[n9].lineBox.requestFocusInWindow();
            }
        }
    }
}

