/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.jgoodies.binding.BindingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JComponent;

public final class GraphLineBox
extends JComponent {
    public static final float[] DASHED_LINE_ARRAY = new float[]{4.0f, 2.0f};
    public static final float THICK_LINE_WIDTH = 2.6f;
    public static final float THIN_LINE_WIDTH = 1.0f;
    private Color graphBGColor;
    private Color lineColor;
    private boolean thickLine;
    private boolean dashedLine;
    boolean showInGraph;
    boolean drawAsFocused;
    boolean drawAsPressed;

    public static final Stroke createLineStroke(float f, float[] fArray) {
        return new BasicStroke(f, 0, 2, 5.0f, fArray, 0.0f);
    }

    public static final Stroke createLineStroke(boolean bl, boolean bl2) {
        return GraphLineBox.createLineStroke(bl ? 2.6f : 1.0f, (float[])(bl2 ? DASHED_LINE_ARRAY : null));
    }

    public GraphLineBox() {
        this.setFocusable(true);
        DialogUtil.addRepaintFocusListener(this);
    }

    public void setGraphBGColor(Color color) {
        if (!BindingUtils.equals((Object)this.graphBGColor, (Object)color)) {
            this.graphBGColor = color;
            this.repaint();
        }
    }

    public void setLineColor(Color color) {
        if (!BindingUtils.equals((Object)this.lineColor, (Object)color)) {
            this.lineColor = color;
            this.repaint();
        }
    }

    public void setThickLine(boolean bl) {
        if (this.thickLine != bl) {
            this.thickLine = bl;
            this.repaint();
        }
    }

    public void setDashedLine(boolean bl) {
        if (this.dashedLine != bl) {
            this.dashedLine = bl;
            this.repaint();
        }
    }

    public void setShowInGraph(boolean bl) {
        if (bl != this.showInGraph) {
            this.showInGraph = bl;
            this.repaint();
        }
    }

    public void setDrawAsFocused(boolean bl) {
        if (bl != this.drawAsFocused) {
            this.drawAsFocused = bl;
            this.repaint();
        }
    }

    public void setDrawAsPressed(boolean bl) {
        if (bl != this.drawAsPressed) {
            this.drawAsPressed = bl;
            this.repaint();
        }
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        boolean bl = this.drawAsFocused | this.isFocusOwner();
        if (this.isEnabled()) {
            graphics2D.setColor(this.graphBGColor);
            graphics2D.fillRect(0, 0, n, n2);
            if (this.showInGraph) {
                graphics2D.setColor(this.lineColor);
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(GraphLineBox.createLineStroke(this.thickLine ? 3.0f : 2.0f, (float[])(this.dashedLine ? DASHED_LINE_ARRAY : null)));
                float f = (float)n / 6.5f;
                int n3 = Math.round((float)n2 / 2.0f);
                graphics2D.drawLine(Math.round(f), n3, Math.round((float)n - f), n3);
                graphics2D.setStroke(stroke);
            }
            if (bl & !this.drawAsPressed) {
                graphics2D.setColor(this.getBackground().brighter());
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
            } else {
                graphics2D.setColor(this.getBackground().darker());
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                if (bl && this.drawAsPressed) {
                    graphics2D.setColor(this.getBackground().brighter());
                    graphics2D.drawRect(1, 1, n - 3, n2 - 3);
                }
            }
        } else {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(this.getBackground().darker());
            graphics2D.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
            graphics2D.setStroke(stroke);
        }
    }
}

