/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.data.TimeNavListener;
import com.ecmtuning.ecmlink.device.data.TimeNavModel;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphScrollBar
extends JScrollBar {
    private static final int NAV_TO_SCROLL_TIME_FACTOR = 10000;
    TimeNavModel navModel;
    boolean doingLocalScrollbarUpdate;
    boolean doingLocalNavUpdate;
    TimeNavListener navListener = new TimeNavListener(){

        @Override
        public void navigationChanged(double d, double d2, double d3) {
            GraphScrollBar.this.updateScrollbarModel();
        }
    };
    ChangeListener barListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            GraphScrollBar.this.updateNavModel();
        }
    };

    public GraphScrollBar() {
        super(0);
        this.updateScrollbarModel();
    }

    public synchronized void connect(TimeNavModel timeNavModel) {
        this.disconnect();
        timeNavModel.addTimeNavListener(this.navListener);
        this.navModel = timeNavModel;
        this.updateScrollbarModel();
        BoundedRangeModel boundedRangeModel = this.getModel();
        boundedRangeModel.addChangeListener(this.barListener);
    }

    public synchronized void disconnect() {
        if (this.navModel != null) {
            this.navModel.removeTimeNavListener(this.navListener);
            BoundedRangeModel boundedRangeModel = this.getModel();
            boundedRangeModel.removeChangeListener(this.barListener);
        }
        this.navModel = null;
        this.updateScrollbarModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateScrollbarModel() {
        if (this.doingLocalNavUpdate) {
            return;
        }
        try {
            this.doingLocalScrollbarUpdate = true;
            if (this.navModel == null) {
                BoundedRangeModel boundedRangeModel = this.getModel();
                boundedRangeModel.setValueIsAdjusting(true);
                boundedRangeModel.setMinimum(0);
                boundedRangeModel.setMaximum(100);
                boundedRangeModel.setExtent(100);
                boundedRangeModel.setValue(0);
                boundedRangeModel.setValueIsAdjusting(false);
            } else {
                int n = (int)Math.round((this.navModel.getWidthTime() + this.navModel.getTotalWidthTime()) / 10000.0);
                int n2 = (int)Math.round(this.navModel.getWidthTime() / 10000.0);
                int n3 = (int)Math.round(this.navModel.getCenterTime() / 10000.0);
                BoundedRangeModel boundedRangeModel = this.getModel();
                boundedRangeModel.setValueIsAdjusting(true);
                boundedRangeModel.setMinimum(0);
                boundedRangeModel.setMaximum(n);
                boundedRangeModel.setExtent(n2);
                boundedRangeModel.setValue(n3);
                boundedRangeModel.setValueIsAdjusting(false);
                this.setBlockIncrement((int)Math.round(this.navModel.getWidthTime() * 0.15 / 10000.0));
                this.setUnitIncrement((int)Math.round(this.navModel.getWidthTime() * 0.03 / 10000.0));
            }
        }
        finally {
            this.doingLocalScrollbarUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateNavModel() {
        if (!this.doingLocalScrollbarUpdate && this.navModel != null) {
            try {
                this.doingLocalNavUpdate = true;
                BoundedRangeModel boundedRangeModel = this.getModel();
                double d = (double)boundedRangeModel.getValue() * 10000.0;
                this.navModel.setCenterTime(d);
            }
            finally {
                this.doingLocalNavUpdate = false;
            }
        }
    }
}

