/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.control.DeviceUIController;
import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DatalogFile;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.DisplaySetListener;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.util.ui.SwingInvokeUtils;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import com.ecmtuning.ecmlink.view.main.DisplaySetView;
import com.ecmtuning.ecmlink.view.main.Graph;
import com.ecmtuning.ecmlink.view.main.GraphDisplayedValuesDialog;
import com.ecmtuning.ecmlink.view.main.GraphLegend;
import com.ecmtuning.ecmlink.view.main.GraphScrollBar;
import com.ecmtuning.ecmlink.view.main.GraphViewItemPrefsDialog;
import com.ecmtuning.ecmlink.view.main.GraphViewPrefs;
import com.ecmtuning.ecmlink.view.main.GraphViewPrefsDialog;
import com.ecmtuning.ecmlink.view.main.GraphViewPrefsListener;
import com.ecmtuning.ecmlink.view.main.MainResources;
import com.ecmtuning.ecmlink.view.main.MainView;
import com.ecmtuning.ecmlink.view.main.MenuBarView;
import com.ecmtuning.ecmlink.view.main.TextDisplayTimePanel;
import com.ecmtuning.ecmlink.view.main.ToolBarView;
import com.jgoodies.binding.adapter.PreferencesAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.builder.MenuBuilder;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uif.builder.ToolBarBuilder;
import com.jgoodies.uifextras.util.PopupAdapter;
import foxtrot.Task;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class GraphView
extends DisplaySetView
implements GraphViewPrefsListener {
    private final Graph graph;
    private final GraphLegend legend;
    private final TextDisplayTimePanel timePanel;
    private JComponent streamButton;
    private JComponent captureButton;
    private List timePanelViewEditButtons = new ArrayList();
    private final GraphScrollBar graphScrollBar;
    private double nextLegendUpdateMicros;
    private final GraphViewPrefs viewPrefs;
    GraphMouseListener graphMouseListener = new GraphMouseListener();
    int lastDeviceId;
    int lastSerialNum;
    DisplaySetListener dsListener = new DisplaySetListener(){

        @Override
        public void displayReset() {
            GraphView.this.getAndSetDefaultDisplayChains();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void displayChainsOrValuesChanged() {
            int n = GraphView.this.viewPrefs.getLastLiveDeviceId();
            int n2 = GraphView.this.viewPrefs.getLastLiveSerialNum();
            if (GraphView.this.parentTab.isLiveView() || GraphView.this.lastSerialNum == n2 && GraphView.this.lastDeviceId == n) {
                DisplayChain[] displayChainArray;
                DisplaySet displaySet = GraphView.this.displaySet;
                synchronized (displaySet) {
                    displayChainArray = GraphView.this.displaySet.getDisplayChains();
                }
                GraphView.this.viewPrefs.setDefaultDisplayChains(Arrays.asList(displayChainArray));
            }
        }

        @Override
        public void displayValuesAdded() {
        }

        @Override
        public void displayTimeChanged() {
        }
    };
    FocusListener graphFocusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Color color = UIManager.getColor("Button.focus");
            if (color == null) {
                color = Color.white;
            }
            GraphView.this.graph.setBorder(BorderFactory.createLineBorder(color, 2));
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            GraphView.this.graph.setBorder(BorderFactory.createLineBorder(GraphView.this.graph.getBackground().darker(), 2));
        }
    };
    private DisplayChainDesc[] descs;
    private static boolean actionsRegistered;
    static final int OP_TYPE_AVERAGE = 0;
    static final int OP_TYPE_MIN = 1;
    static final int OP_TYPE_MAX = 2;
    boolean doHide = true;
    private AbstractAction doExportAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(GraphView.this.exportTask, false);
        }
    };
    Task exportTask = new Task(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws Exception {
            Serializable serializable;
            Object object;
            if (!this.checkExportData()) {
                return null;
            }
            DatalogFile datalogFile = GraphView.this.parentTab.getLastSavedDatalog();
            File file = null;
            if (datalogFile != null && ((String)(object = ((File)(serializable = datalogFile.getSaveFile())).getAbsolutePath())).endsWith("elg")) {
                object = BasicStrings.replace((String)object, ".elg", ".csv");
                file = new File((String)object);
            }
            if (file == null) {
                file = GraphView.this.parentTab.createDefaultFile("csv");
            }
            serializable = new JFileChooser();
            ((JFileChooser)serializable).setSelectedFile(file);
            ((JFileChooser)serializable).addChoosableFileFilter(((JFileChooser)serializable).getAcceptAllFileFilter());
            ((JFileChooser)serializable).addChoosableFileFilter(FilenameModel.getDatalogExportFileFilter());
            ((JFileChooser)serializable).setDialogTitle("Export Datalog");
            ((JFileChooser)serializable).setMultiSelectionEnabled(false);
            object = DialogUtil.invokeSaveAsChooser((JFileChooser)serializable, GraphView.this.parentTab, "csv");
            if (object != null) {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
                char c = decimalFormatSymbols.getDecimalSeparator() == ',' ? (char)';' : ',';
                DisplaySet displaySet = GraphView.this.displaySet;
                synchronized (displaySet) {
                    DisplayChainDesc[] displayChainDescArray = GraphView.this.getDescs();
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((File)object));
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Timestamp (us)");
                    for (int i = 0; i < displayChainDescArray.length; ++i) {
                        DisplayChainDesc displayChainDesc = displayChainDescArray[i];
                        if (!displayChainDesc.isDisplayable() || !GraphView.this.viewPrefs.getShowInGraph(displayChainDesc)) continue;
                        stringBuffer.append(c);
                        stringBuffer.append(displayChainDesc.getDisplayName());
                        stringBuffer.append(" (");
                        stringBuffer.append(displayChainDesc.getUnits());
                        stringBuffer.append(')');
                    }
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.newLine();
                    ArrayList arrayList = GraphView.this.displaySet.getDisplayPackets();
                    for (TSDataPacket tSDataPacket : arrayList) {
                        float[] fArray = tSDataPacket.data;
                        stringBuffer.setLength(0);
                        stringBuffer.append(XFormatter.format(tSDataPacket.timestampMicros, 0));
                        for (int i = 0; i < displayChainDescArray.length; ++i) {
                            DisplayChainDesc displayChainDesc = displayChainDescArray[i];
                            if (!displayChainDesc.isDisplayable() || !GraphView.this.viewPrefs.getShowInGraph(displayChainDesc)) continue;
                            stringBuffer.append(c);
                            if (fArray[i] == Float.MIN_VALUE) continue;
                            stringBuffer.append(displayChainDesc.format(fArray[i]));
                        }
                        bufferedWriter.write(stringBuffer.toString());
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.close();
                }
            }
            return null;
        }

        private boolean checkExportData() {
            DisplayChainDesc[] displayChainDescArray = GraphView.this.getDescs();
            boolean bl = false;
            for (int i = 0; !bl && i < displayChainDescArray.length; ++i) {
                if (!displayChainDescArray[i].isDisplayable() || !GraphView.this.viewPrefs.getShowInGraph(displayChainDescArray[i])) continue;
                bl = true;
            }
            ArrayList arrayList = GraphView.this.displaySet.getDisplayPackets();
            if (!bl || arrayList.size() < 2) {
                JOptionPane.showMessageDialog(MainModel.getDefaultParentFrame(), "No displayable data to export.", "Export Error", 0);
                return false;
            }
            return true;
        }
    };
    protected List viewMenuItems = new ArrayList();
    protected List toolbarItems = new ArrayList();
    boolean firstTimeShown = true;

    public GraphView(DatalogTab datalogTab) {
        super(datalogTab);
        GraphView.registerActions();
        this.viewPrefs = new GraphViewPrefs();
        this.viewPrefs.addGraphViewPrefsListener(this);
        this.navModel.setMinWidth(1000000.0);
        this.zoomDefault();
        this.getAndSetDefaultDisplayChains();
        this.graph = new Graph(this);
        this.legend = new GraphLegend(this);
        this.timePanel = new TextDisplayTimePanel();
        this.graphScrollBar = new GraphScrollBar();
        this.registerModels();
        this.graph.addMouseMotionListener(this.graphMouseListener);
        this.graph.addMouseListener(this.graphMouseListener);
        this.graph.addMouseListener(this.getGraphPopupListener());
        this.graph.addMouseWheelListener(this.graphMouseListener);
        this.legend.addMouseListener(this.getLegendMouseListener());
        if (!this.parentTab.isLiveView() && this.viewPrefs.getAutoZoomOnFileOpen()) {
            this.parentTab.zoomAll(this.displaySet);
        }
        if (!this.parentTab.isLiveView() && this.viewPrefs.getAutoAllOnFileOpen()) {
            this.showAll();
        }
        this.navModel.setMaxWidth(this.getMaxDisplayWidth());
    }

    @Override
    protected void registerModels() {
        this.displaySet.addDisplaySetListener(this.dsListener);
        super.registerModels();
    }

    @Override
    protected void deregisterModels() {
        this.displaySet.removeDisplaySetListener(this.dsListener);
        super.deregisterModels();
    }

    protected void getAndSetDefaultDisplayChains() {
        DeviceConfigData deviceConfigData = this.dataset.getMainConfigData();
        int n = 0;
        int n2 = 0;
        if (deviceConfigData != null) {
            n = deviceConfigData.getDeviceId();
            n2 = deviceConfigData.getDeviceSerialNumber();
        }
        if (n != this.lastDeviceId || n2 != this.lastSerialNum) {
            this.lastDeviceId = n;
            this.lastSerialNum = n2;
            if (this.parentTab.isLiveView()) {
                this.viewPrefs.setLastLiveDeviceIdAndSerialNum(this.lastDeviceId, this.lastSerialNum);
            }
            this.displaySet.setDisplayChains(this.viewPrefs.getDefaultDisplayChains());
        }
    }

    private void zoomDefault() {
        this.navModel.setWidthTime(this.viewPrefs.getDefaultDisplayWidthSecs() * 1000000.0);
    }

    GraphViewPrefs getViewPrefs() {
        return this.viewPrefs;
    }

    private double getMaxDisplayWidth() {
        return Math.max(this.viewPrefs.getDefaultDisplayWidthSecs() * 1000000.0, this.displaySet.getDisplayPacketMaxTime() * 2.1);
    }

    @Override
    public JComponent build() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.graph, "Center");
        jPanel.add((Component)this.buildLegendPanel(), "South");
        this.graph.setBorder(BorderFactory.createLineBorder(this.graph.getBackground().darker(), 2));
        this.configureGraph();
        this.configureLegend();
        this.configureTimePanel();
        return jPanel;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.graph;
    }

    private void configureLegend() {
        this.legend.reconfigureLayout();
        this.legend.setBorder(BorderFactory.createLineBorder(this.legend.getBackground().darker(), 1));
    }

    private void configureGraph() {
        this.graph.addFocusListener(this.graphFocusListener);
        this.graph.setFocusable(true);
        this.configureGraphActions();
    }

    private void configureTimePanel() {
        Font font = this.viewPrefs.getLegendFont();
        Font font2 = font.deriveFont(1);
        this.timePanel.setLabelFont(font.deriveFont(1), font.deriveFont(2));
        this.streamButton.setFont(font2);
        this.captureButton.setFont(font2);
        for (JComponent jComponent : this.timePanelViewEditButtons) {
            jComponent.setFont(font2);
        }
    }

    private JComponent buildLegendPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.graphScrollBar, "North");
        jPanel.add((Component)this.legend, "Center");
        jPanel.add((Component)this.buildTimePanel(), "South");
        return jPanel;
    }

    private JComponent buildTimePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(4, 0, 0, 0));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.getLayout().setRowSpec(1, new RowSpec("f:d"));
        this.streamButton = DialogUtil.createListButton("startStream", false);
        this.captureButton = DialogUtil.createListButton("startCapture", false);
        buttonBarBuilder.addGridded(this.streamButton);
        buttonBarBuilder.addGridded(this.captureButton);
        DeviceUIController deviceUIController = MainModel.getInstance().getDeviceUIController();
        List list = deviceUIController.getGraphViewEditActions(this.parentTab, true);
        if (list.size() > 0) {
            this.timePanelViewEditButtons.clear();
            buttonBarBuilder.addUnrelatedGap();
            for (Action action : list) {
                JButton jButton = DialogUtil.createListButton(action, null, false);
                this.timePanelViewEditButtons.add(jButton);
                buttonBarBuilder.addFixed((JComponent)jButton);
            }
        }
        jPanel.add((Component)buttonBarBuilder.getPanel(), "West");
        jPanel.add((Component)this.timePanel, "East");
        return jPanel;
    }

    private void configureGraphActions() {
        ActionMap actionMap = this.graph.getActionMap();
        GraphView.installTabAction(actionMap, "selectPrevious");
        GraphView.installTabAction(actionMap, "selectPreviousExtendSelection");
        GraphView.installTabAction(actionMap, "selectNext");
        GraphView.installTabAction(actionMap, "selectNextExtendSelection");
        GraphView.installTabAction(actionMap, "selectPreviousByFactor");
        GraphView.installTabAction(actionMap, "selectPreviousExtendSelectionFactor");
        GraphView.installTabAction(actionMap, "selectNextFactor");
        GraphView.installTabAction(actionMap, "selectNextExtendSelectionFactor");
        GraphView.installTabAction(actionMap, "selectPreviousByPage");
        GraphView.installTabAction(actionMap, "selectPreviousExtendSelectionPage");
        GraphView.installTabAction(actionMap, "selectNextPage");
        GraphView.installTabAction(actionMap, "selectNextExtendSelectionPage");
        GraphView.installTabAction(actionMap, "selectFirst");
        GraphView.installTabAction(actionMap, "selectFirstExtendSelection");
        GraphView.installTabAction(actionMap, "selectLast");
        GraphView.installTabAction(actionMap, "selectLastExtendSelection");
        GraphView.installTabAction(actionMap, "selectScreenFirst");
        GraphView.installTabAction(actionMap, "selectScreenFirstExtendSelection");
        GraphView.installTabAction(actionMap, "selectScreenLast");
        GraphView.installTabAction(actionMap, "selectScreenLastExtendSelection");
        GraphView.installMainAction(actionMap, "datalog.selectNone");
        GraphView.installMainAction(actionMap, "datalog.selectAll");
        GraphView.installMainAction(actionMap, "datalog.centerSelection");
        GraphView.installMainAction(actionMap, "datalog.zoomInByFactor");
        GraphView.installMainAction(actionMap, "datalog.zoomOutByFactor");
        GraphView.installMainAction(actionMap, "datalog.zoomSelection");
        GraphView.installMainAction(actionMap, "datalog.zoomAll");
        GraphView.installTabAction(actionMap, "zoomInByLargeFactor");
        GraphView.installTabAction(actionMap, "zoomOutByLargeFactor");
        InputMap inputMap = this.graph.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "selectNext");
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "selectNextExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "selectPrevious");
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "selectPreviousExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(39, 128), "selectNextFactor");
        inputMap.put(KeyStroke.getKeyStroke(39, 192), "selectNextExtendSelectionFactor");
        inputMap.put(KeyStroke.getKeyStroke(37, 128), "selectPreviousByFactor");
        inputMap.put(KeyStroke.getKeyStroke(37, 192), "selectPreviousExtendSelectionFactor");
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "selectNextPage");
        inputMap.put(KeyStroke.getKeyStroke(33, 64), "selectNextExtendSelectionPage");
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "selectPreviousByPage");
        inputMap.put(KeyStroke.getKeyStroke(34, 64), "selectPreviousExtendSelectionPage");
        inputMap.put(KeyStroke.getKeyStroke(45, 128), "datalog.zoomAll");
        inputMap.put(KeyStroke.getKeyStroke(48, 128), "datalog.zoomAll");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "selectScreenFirst");
        inputMap.put(KeyStroke.getKeyStroke(36, 64), "selectScreenFirstExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "selectScreenLast");
        inputMap.put(KeyStroke.getKeyStroke(35, 64), "selectScreenLastExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(36, 128), "selectFirst");
        inputMap.put(KeyStroke.getKeyStroke(36, 192), "selectFirstExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(35, 128), "selectLast");
        inputMap.put(KeyStroke.getKeyStroke(35, 192), "selectLastExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "datalog.zoomInByFactor");
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "datalog.zoomOutByFactor");
        inputMap.put(KeyStroke.getKeyStroke(38, 128), "datalog.zoomInByFactor");
        inputMap.put(KeyStroke.getKeyStroke(40, 128), "datalog.zoomOutByFactor");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "datalog.zoomInByFactor");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "datalog.zoomOutByFactor");
        inputMap.put(KeyStroke.getKeyStroke(33, 128), "zoomInByLargeFactor");
        inputMap.put(KeyStroke.getKeyStroke(34, 128), "zoomOutByLargeFactor");
        inputMap.put(KeyStroke.getKeyStroke(47, 128), "datalog.selectAll");
        inputMap.put(KeyStroke.getKeyStroke(92, 128), "datalog.selectNone");
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "datalog.zoomSelection");
        inputMap.put(KeyStroke.getKeyStroke(32, 128), "datalog.centerSelection");
    }

    private synchronized void invalidateDescs() {
        this.descs = null;
        this.graph.repaint();
        this.legend.scheduleReconfig();
    }

    synchronized DisplayChainDesc[] getDescs() {
        if (this.descs == null) {
            this.descs = this.displaySet.getDisplayChainDescs();
            Color[] colorArray = this.viewPrefs.getDefaultGraphColors();
            int n = this.descs.length;
            for (int i = 0; i < n; ++i) {
                DisplayChainDesc displayChainDesc = this.descs[i];
                displayChainDesc.setOverridePrefs(this.viewPrefs.getCachedDescPrefs(displayChainDesc));
                Color color = this.viewPrefs.getLineColor(displayChainDesc);
                if (color != null) continue;
                int n2 = i % colorArray.length;
                color = colorArray[n2];
                this.viewPrefs.setLineColor(displayChainDesc, color);
                this.viewPrefs.getPersistedDescPrefs(displayChainDesc).putColor("linecolor", color);
            }
        }
        return this.descs;
    }

    @Override
    public void graphViewPrefsChanged(boolean bl) {
        if (bl) {
            this.graph.repaint();
            this.legend.scheduleUpdateUI();
        } else {
            this.invalidateDescs();
        }
        this.configureTimePanel();
    }

    @Override
    public void displayChainsOrValuesChanged() {
        this.invalidateDescs();
    }

    @Override
    public void displayTimeChanged() {
        this.navModel.setMaxWidth(this.getMaxDisplayWidth());
        this.navModel.setTotalWidthTime(this.displaySet.getDisplayPacketMaxTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void displayValuesAdded() {
        this.navModel.setMaxWidth(this.getMaxDisplayWidth());
        double d = this.displaySet.getDisplayPacketMaxTime();
        double d2 = this.navModel.getWidthTime();
        this.navModel.setChanging(true);
        try {
            if (d < d2 / 2.0) {
                this.navModel.setCenterTime(0.0);
            } else {
                this.navModel.setCenterTime(d - d2 / 2.0);
            }
            this.navModel.setTotalWidthTime(d);
        }
        finally {
            this.navModel.setChanging(false);
        }
        this.textDisplayTimeModel.setAnchorTime(d);
    }

    @Override
    public void displayReset() {
        this.navModel.setMaxWidth(this.getMaxDisplayWidth());
        this.navModel.setTotalWidthTime(this.displaySet.getDisplayPacketMaxTime());
        this.invalidateDescs();
    }

    @Override
    public void setStreamState(boolean bl) {
        if (bl) {
            this.graphMouseListener.clearState();
            this.nextLegendUpdateMicros = 0.0;
            this.graphScrollBar.setEnabled(false);
            this.zoomDefault();
        } else {
            this.graphScrollBar.setEnabled(true);
            if (this.viewPrefs.getAutoZoomOnStreamStop()) {
                this.parentTab.zoomAll();
            }
        }
    }

    @Override
    public void textDisplayTimeChanged(double d) {
        if (this.parentTab.isStreaming()) {
            if (d >= this.nextLegendUpdateMicros) {
                this.nextLegendUpdateMicros = d + 1000000.0 / (double)this.viewPrefs.getLegendUpdateHz();
                this.setDisplayedLegendValues();
            }
        } else {
            this.setDisplayedLegendValues();
        }
    }

    void setDisplayedLegendValues() {
        if (this.textDisplayTimeModel.isSelectionActive()) {
            double d = this.textDisplayTimeModel.getAnchorTime();
            float[] fArray = this.displaySet.getMostRecentData(d);
            this.legend.updateData(fArray);
        } else {
            this.legend.clearData();
        }
    }

    @Override
    public void selectionChanged(double d, double d2) {
        this.graph.repaint();
        if (!this.parentTab.isStreaming()) {
            if (d2 != Double.MIN_VALUE) {
                this.textDisplayTimeModel.setAnchorTime(d2);
            } else {
                this.textDisplayTimeModel.setAnchorTime(this.navModel.getCenterTime());
            }
        }
    }

    @Override
    public void navigationChanged(double d, double d2, double d3) {
        this.graph.repaint();
        if (!this.parentTab.isStreaming() && !this.selectionModel.isSelectionActive()) {
            this.textDisplayTimeModel.setAnchorTime(d);
        }
    }

    @Override
    void ensureVisible(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > this.displaySet.getDisplayPacketMaxTime()) {
            d = this.displaySet.getDisplayPacketMaxTime();
        }
        if (d <= this.graph.unitPanelLeft) {
            this.navModel.setCenterTime(d + 0.47 * this.navModel.getWidthTime());
        } else if (d >= (this.graph.unitPanelLeft + this.graph.unitPanelWidth) * 0.999) {
            this.navModel.setCenterTime(d - 0.47 * this.navModel.getWidthTime());
        }
    }

    protected MouseListener getLegendMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.popupMenu(mouseEvent, GraphView.this.legend.findDescAt(mouseEvent.getPoint()));
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.popupMenu(mouseEvent, GraphView.this.legend.findDescAt(mouseEvent.getPoint()));
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DisplayChainDesc displayChainDesc;
                if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() > 0 && mouseEvent.getClickCount() % 2 == 0 && (displayChainDesc = GraphView.this.legend.findDescAt(mouseEvent.getPoint())) != null) {
                    new EditItemPrefsAction(displayChainDesc).actionPerformed(null);
                }
            }

            private void popupMenu(MouseEvent mouseEvent, DisplayChainDesc displayChainDesc) {
                JPopupMenu jPopupMenu = this.buildPopupMenu(displayChainDesc);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }

            JMenu buildItemMenu(final DisplayChainDesc displayChainDesc) {
                MenuBuilder menuBuilder = new MenuBuilder(new JMenu(displayChainDesc.getDisplayName()));
                if (displayChainDesc.isDisplayable()) {
                    DataPreferences dataPreferences = GraphView.this.viewPrefs.getCachedDescPrefs(displayChainDesc);
                    DataPreferences dataPreferences2 = GraphView.this.viewPrefs.getPersistedDescPrefs(displayChainDesc);
                    PreferencesAdapter preferencesAdapter = new PreferencesAdapter((Preferences)dataPreferences, "showingraph", (Object)Boolean.TRUE);
                    ToggleAction toggleAction = ToggleAction.createCheck((ValueModel)preferencesAdapter);
                    MainResources.configureAction((Action)toggleAction, "graphview.showItem");
                    menuBuilder.addToggle(toggleAction);
                    preferencesAdapter = new PreferencesAdapter((Preferences)dataPreferences2, "displayonall", (Object)Boolean.TRUE);
                    preferencesAdapter.addValueChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                                new RemoveItemAction(displayChainDesc).actionPerformed(null);
                            }
                        }
                    });
                    toggleAction = ToggleAction.createCheck((ValueModel)preferencesAdapter);
                    MainResources.configureAction((Action)toggleAction, "graphview.showInDisplayAll");
                    menuBuilder.addToggle(toggleAction);
                }
                return menuBuilder.getMenu();
            }

            protected JPopupMenu buildPopupMenu(DisplayChainDesc displayChainDesc) {
                PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder(displayChainDesc == null ? null : displayChainDesc.getDisplayName());
                if (displayChainDesc != null) {
                    popupMenuBuilder.add((Action)new EditItemPrefsAction(displayChainDesc));
                    popupMenuBuilder.add((Action)new RemoveItemAction(displayChainDesc));
                    popupMenuBuilder.add((JMenuItem)this.buildItemMenu(displayChainDesc));
                    popupMenuBuilder.addSeparator();
                }
                GraphView.this.addStandardPopupItems(popupMenuBuilder);
                return popupMenuBuilder.getPopupMenu();
            }
        };
    }

    protected MouseListener getGraphPopupListener() {
        return new PopupAdapter(false){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!GraphView.this.graphMouseListener.mouseWasDragged) {
                    super.mouseReleased(mouseEvent);
                }
            }

            protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                return GraphView.this.buildGraphPopupMenu();
            }
        };
    }

    JMenu buildZoomMenu() {
        MenuBuilder menuBuilder = new MenuBuilder(new JMenu("Zoom"));
        menuBuilder.add(MainResources.getAction("datalog.zoomAll"));
        menuBuilder.add(MainResources.getAction("datalog.zoomSelection"));
        menuBuilder.add(MainResources.getAction("datalog.zoomDefault"));
        return menuBuilder.getMenu();
    }

    JMenu buildSelectMenu() {
        MenuBuilder menuBuilder = new MenuBuilder(new JMenu("Selection"));
        menuBuilder.add(MainResources.getAction("selectAll"));
        menuBuilder.add(MainResources.getAction("selectNone"));
        menuBuilder.add(MainActions.getAction("clipSelection"));
        menuBuilder.add(MainResources.getAction("datalog.centerSelection"));
        menuBuilder.addSeparator();
        menuBuilder.add(MainResources.getAction("datalog.averageSelection"));
        menuBuilder.add(MainResources.getAction("datalog.minSelection"));
        menuBuilder.add(MainResources.getAction("datalog.maxSelection"));
        return menuBuilder.getMenu();
    }

    JPopupMenu buildGraphPopupMenu() {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder((String)null);
        popupMenuBuilder.add((JMenuItem)this.buildZoomMenu());
        popupMenuBuilder.add((JMenuItem)this.buildSelectMenu());
        popupMenuBuilder.addSeparator();
        this.addStandardPopupItems(popupMenuBuilder);
        return popupMenuBuilder.getPopupMenu();
    }

    private final void addStandardPopupItems(PopupMenuBuilder popupMenuBuilder) {
        popupMenuBuilder.add((Action)new SaveDefaultConfiguration(0));
        popupMenuBuilder.addSeparator();
        DeviceUIController deviceUIController = MainModel.getInstance().getDeviceUIController();
        this.addActionsWithSeparator(deviceUIController.getGraphViewEditActions(this.parentTab, false), popupMenuBuilder);
        this.addActionsWithSeparator(deviceUIController.getGraphViewExtActions(this.parentTab), popupMenuBuilder);
        popupMenuBuilder.add(MainResources.getAction("graphview.editGraphPrefs"));
        popupMenuBuilder.add(MainActions.getAction("openUnitsPreferences"));
        popupMenuBuilder.add(MainActions.getAction("displayValues"));
        popupMenuBuilder.add(MainActions.getAction("capturedValues"));
    }

    private void addActionsWithSeparator(List list, PopupMenuBuilder popupMenuBuilder) {
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            popupMenuBuilder.add((Action)iterator.next());
        }
        popupMenuBuilder.addSeparator();
    }

    private static synchronized void registerActions() {
        if (actionsRegistered) {
            return;
        }
        DatalogTab.registerMainAction("graphview.editGraphPrefs");
        DatalogTab.registerMainAction("graphview.hideAll");
        DatalogTab.registerMainAction("graphview.showAll");
        DatalogTab.registerMainAction("datalog.averageSelection");
        DatalogTab.registerMainAction("datalog.minSelection");
        DatalogTab.registerMainAction("datalog.maxSelection");
        actionsRegistered = true;
    }

    @Override
    boolean dispatchActionEvent(String string, ActionEvent actionEvent) {
        if (string == "graphview.editGraphPrefs") {
            this.doEditPrefs();
            return true;
        }
        if (string == "graphview.hideAll") {
            this.hideAll();
            return true;
        }
        if (string == "graphview.showAll") {
            this.showAll();
            return true;
        }
        if (string == "datalog.zoomDefault") {
            this.zoomDefault();
            return true;
        }
        if (this.parentTab.isStreaming()) {
            return false;
        }
        if (string == "datalog.averageSelection") {
            this.doSelectionOp(0);
            return true;
        }
        if (string == "datalog.minSelection") {
            this.doSelectionOp(1);
            return true;
        }
        if (string == "datalog.maxSelection") {
            this.doSelectionOp(2);
            return true;
        }
        return super.dispatchActionEvent(string, actionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSelectionOp(int n) {
        if (!this.selectionModel.isSelectionActive() || this.selectionModel.isMomentSelection()) {
            return;
        }
        DisplaySet displaySet = this.displaySet;
        synchronized (displaySet) {
            Object object3;
            Object object2;
            DisplayChainDesc[] displayChainDescArray = this.getDescs();
            boolean[] blArray = new boolean[displayChainDescArray.length];
            for (int i = 0; i < displayChainDescArray.length; ++i) {
                object2 = displayChainDescArray[i];
                blArray[i] = ((DisplayChainDesc)object2).isDisplayable();
            }
            double[] dArray = new double[displayChainDescArray.length];
            Arrays.fill(dArray, 0.0);
            object2 = new int[displayChainDescArray.length];
            Arrays.fill((int[])object2, 0);
            float[] fArray = new float[displayChainDescArray.length];
            float[] fArray2 = new float[displayChainDescArray.length];
            Arrays.fill(fArray, Float.MAX_VALUE);
            Arrays.fill(fArray2, Float.MIN_VALUE);
            ArrayList arrayList = this.displaySet.getDisplayPackets();
            for (Object object3 : arrayList) {
                if (!this.selectionModel.isTimeInSelection(((TSDataPacket)object3).timestampMicros)) continue;
                float[] fArray3 = ((TSDataPacket)object3).data;
                for (int i = 0; i < fArray3.length; ++i) {
                    if (!blArray[i]) continue;
                    int n2 = i;
                    dArray[n2] = dArray[n2] + (double)fArray3[i];
                    Object object4 = object2;
                    int n3 = i;
                    object4[n3] = object4[n3] + true;
                    if (fArray3[i] > fArray2[i]) {
                        fArray2[i] = fArray3[i];
                    }
                    if (!(fArray3[i] < fArray[i])) continue;
                    fArray[i] = fArray3[i];
                }
            }
            object3 = new float[displayChainDescArray.length];
            Arrays.fill((float[])object3, 0.0f);
            for (int i = 0; i < ((Object)object3).length; ++i) {
                if (object2[i] <= 0) continue;
                object3[i] = (float)(dArray[i] / (double)object2[i]);
            }
            if (n == 0) {
                this.legend.updateData((float[])object3);
            } else if (n == 1) {
                this.legend.updateData(fArray);
            } else if (n == 2) {
                this.legend.updateData(fArray2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideAll() {
        DisplayChainDesc[] displayChainDescArray = null;
        DisplaySet displaySet = this.displaySet;
        synchronized (displaySet) {
            displayChainDescArray = this.getDescs();
        }
        if (displayChainDescArray != null) {
            for (int i = 0; i < displayChainDescArray.length; ++i) {
                if (displayChainDescArray[i] == null) continue;
                this.viewPrefs.setShowInGraph(displayChainDescArray[i], !this.doHide && this.viewPrefs.getDefaultShowInGraph(displayChainDescArray[i]));
            }
            this.doHide = !this.doHide;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAll() {
        List list = this.viewPrefs.getDefaultDisplayChains();
        int n = list.size();
        List list2 = null;
        DisplaySet displaySet = this.displaySet;
        synchronized (displaySet) {
            list2 = this.displaySet.generateAllDisplayable(list);
            Iterator iterator = list2.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                DisplayChain displayChain = (DisplayChain)iterator.next();
                if (++n2 <= n || this.viewPrefs.getDisplayOnAll(displayChain.getCurrentChainDesc())) continue;
                iterator.remove();
            }
        }
        this.displaySet.setDisplayChains(list2);
    }

    private void doEditPrefs() {
        JFrame jFrame = MainModel.getDefaultParentFrame();
        GraphViewPrefsDialog graphViewPrefsDialog = new GraphViewPrefsDialog(jFrame, this.viewPrefs);
        graphViewPrefsDialog.setUseAsDefault(this.parentTab.isLiveView());
        graphViewPrefsDialog.open();
        if (!graphViewPrefsDialog.hasBeenCanceled() && graphViewPrefsDialog.useAsDefaultSelected()) {
            this.viewPrefs.persistCachedViewPrefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initViewMenuItems() {
        if (this.viewMenuItems.size() == 0) {
            List list = this.viewMenuItems;
            synchronized (list) {
                if (this.viewMenuItems.size() == 0) {
                    DeviceUIController deviceUIController = MainModel.getInstance().getDeviceUIController();
                    List list2 = deviceUIController.getGraphViewEditActions(this.parentTab, false);
                    if (list2.size() > 0) {
                        this.viewMenuItems.addAll(list2);
                        this.viewMenuItems.add(new JPopupMenu.Separator());
                    }
                    this.viewMenuItems.add(MainResources.getAction("datalog.zoomAll"));
                    this.viewMenuItems.add(MainResources.getAction("datalog.zoomSelection"));
                    this.viewMenuItems.add(MainResources.getAction("datalog.zoomDefault"));
                    this.viewMenuItems.add(new JPopupMenu.Separator());
                    this.viewMenuItems.add(MainResources.getAction("selectAll"));
                    this.viewMenuItems.add(MainResources.getAction("selectNone"));
                    this.viewMenuItems.add(MainActions.getAction("clipSelection"));
                    this.viewMenuItems.add(MainResources.getAction("datalog.centerSelection"));
                    this.viewMenuItems.add(new JPopupMenu.Separator());
                    this.viewMenuItems.add(MainResources.getAction("graphview.hideAll"));
                    this.viewMenuItems.add(MainResources.getAction("graphview.showAll"));
                    this.viewMenuItems.add(new JPopupMenu.Separator());
                    this.viewMenuItems.add(MainResources.getAction("graphview.editGraphPrefs"));
                    this.viewMenuItems.add(new JPopupMenu.Separator());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initToolbarItems() {
        if (this.toolbarItems.size() == 0) {
            List list = this.toolbarItems;
            synchronized (list) {
                if (this.toolbarItems.size() == 0) {
                    ToolBarBuilder toolBarBuilder = new ToolBarBuilder();
                    this.toolbarItems.add(DialogUtil.createToolbarSeparator());
                    this.toolbarItems.add(toolBarBuilder.add(MainResources.getAction("datalog.zoomAll")));
                    this.toolbarItems.add(toolBarBuilder.add(MainResources.getAction("datalog.zoomSelection")));
                    this.toolbarItems.add(toolBarBuilder.add(MainResources.getAction("datalog.zoomDefault")));
                    this.toolbarItems.add(DialogUtil.createToolbarSeparator());
                    this.toolbarItems.add(toolBarBuilder.add(MainResources.getAction("graphview.editGraphPrefs")));
                }
            }
        }
    }

    @Override
    protected void viewShown() {
        MainActions mainActions = MainModel.getInstance().getMainActions();
        mainActions.installActionHook("saveFile", this.parentTab.getSaveAction(), "Saves datalog to disk");
        mainActions.installActionHook("saveFileAs", this.parentTab.getSaveAsAction(), "Saves datalog to disk as new file");
        mainActions.installActionHook("exportFile", this.doExportAction, "Export the current display to disk in CSV format for import into Excel");
        mainActions.installActionHook("closeFile", MainActions.CLOSE_TAB_ACTION, "Close current tab");
        mainActions.installActionHook("selectAll", MainResources.getAction("datalog.selectAll"));
        mainActions.installActionHook("selectNone", MainResources.getAction("datalog.selectNone"));
        mainActions.installActionHook("clipSelection", MainResources.getAction("datalog.clipToSelection"));
        mainActions.installActionHook("displayValues", new EditDisplayedValuesAction());
        MainView mainView = MainModel.getInstance().getMainView();
        this.initViewMenuItems();
        MenuBarView menuBarView = mainView.getMenuBarView();
        this.pushComponentsToMenu(menuBarView.getViewMenu(), this.viewMenuItems);
        Action action = MainResources.getAction("graphview.editGraphPrefs");
        action.setEnabled(true);
        this.initToolbarItems();
        ToolBarView toolBarView = mainView.getToolBarView();
        JToolBar jToolBar = toolBarView.getToolBar();
        for (int i = 0; i < this.toolbarItems.size(); ++i) {
            jToolBar.add((Component)this.toolbarItems.get(i));
        }
        jToolBar.repaint();
        super.viewShown();
        if (this.firstTimeShown) {
            SwingInvokeUtils.requestFocusInWindowLater(this.graph);
            this.firstTimeShown = false;
        }
        this.timePanel.connect(this.textDisplayTimeModel, this.selectionModel);
        this.graphScrollBar.connect(this.navModel);
    }

    @Override
    protected void viewHidden() {
        super.viewHidden();
        this.graphScrollBar.disconnect();
        this.timePanel.disconnect();
        MainActions mainActions = MainModel.getInstance().getMainActions();
        mainActions.uninstallActionHook("displayValues");
        mainActions.uninstallActionHook("clipSelection");
        mainActions.uninstallActionHook("selectNone");
        mainActions.uninstallActionHook("selectAll");
        mainActions.uninstallActionHook("closeFile");
        mainActions.uninstallActionHook("exportFile");
        mainActions.uninstallActionHook("saveFileAs");
        mainActions.uninstallActionHook("saveFile");
        MainView mainView = MainModel.getInstance().getMainView();
        MenuBarView menuBarView = mainView.getMenuBarView();
        this.popComponentsFromMenu(menuBarView.getViewMenu(), this.viewMenuItems);
        ToolBarView toolBarView = mainView.getToolBarView();
        JToolBar jToolBar = toolBarView.getToolBar();
        for (int i = this.toolbarItems.size() - 1; i >= 0; --i) {
            jToolBar.remove((Component)this.toolbarItems.get(i));
        }
        jToolBar.repaint();
        Action action = MainResources.getAction("graphview.editGraphPrefs");
        action.setEnabled(false);
    }

    class RemoveItemAction
    extends AbstractAction {
        final DisplayChainDesc descToRemove;

        RemoveItemAction(DisplayChainDesc displayChainDesc) {
            this.descToRemove = displayChainDesc;
            MainResources.configureAction(this, "graphview.removeItem");
            String string = this.getValue("Name").toString();
            MessageFormat messageFormat = new MessageFormat(string);
            string = messageFormat.format(new String[]{displayChainDesc.getDisplayName()});
            this.putValue("Name", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DisplayChain[] displayChainArray = GraphView.this.displaySet.getDisplayChains();
            DisplayChainDesc[] displayChainDescArray = GraphView.this.getDescs();
            if (displayChainDescArray == null || displayChainArray == null || displayChainDescArray.length != displayChainArray.length) {
                return;
            }
            ArrayList<DisplayChain> arrayList = new ArrayList<DisplayChain>();
            boolean bl = false;
            for (int i = 0; i < displayChainDescArray.length; ++i) {
                if (displayChainDescArray[i] == this.descToRemove) {
                    bl = true;
                    continue;
                }
                arrayList.add(displayChainArray[i]);
            }
            if (bl) {
                GraphView.this.displaySet.setDisplayChains(arrayList);
            }
        }
    }

    class SaveDefaultConfiguration
    extends AbstractAction {
        static final int TYPE_ALL = 0;
        static final int TYPE_LIST_ONLY = 1;
        final int type;

        public SaveDefaultConfiguration(int n) {
            this.type = n;
            if (n == 0) {
                MainResources.configureAction(this, "graphview.saveAllDefaults");
            } else if (n == 1) {
                MainResources.configureAction(this, "graphview.saveDefaultList");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DisplayChain[] displayChainArray;
            DisplayChainDesc[] displayChainDescArray = null;
            DisplaySet displaySet = GraphView.this.displaySet;
            synchronized (displaySet) {
                displayChainArray = GraphView.this.displaySet.getDisplayChains();
                displayChainDescArray = GraphView.this.getDescs();
            }
            if (this.type == 0) {
                GraphView.this.viewPrefs.persistCachedViewPrefs();
                if (displayChainDescArray != null) {
                    for (int i = 0; i < displayChainDescArray.length; ++i) {
                        if (displayChainDescArray[i] == null) continue;
                        GraphView.this.viewPrefs.persistCachedDescPrefs(displayChainDescArray[i]);
                    }
                }
            }
            GraphView.this.viewPrefs.setDefaultDisplayChains(Arrays.asList(displayChainArray));
        }
    }

    class EditItemPrefsAction
    extends AbstractAction {
        final DisplayChainDesc desc;

        public EditItemPrefsAction(DisplayChainDesc displayChainDesc) {
            this.desc = displayChainDesc;
            MainResources.configureAction(this, "graphview.editItemPrefs");
            String string = this.getValue("Name").toString();
            MessageFormat messageFormat = new MessageFormat(string);
            string = messageFormat.format(new String[]{displayChainDesc.getDisplayName()});
            this.putValue("Name", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = MainModel.getDefaultParentFrame();
            GraphViewItemPrefsDialog graphViewItemPrefsDialog = new GraphViewItemPrefsDialog(jFrame, GraphView.this.viewPrefs, this.desc, GraphView.this.parentTab.getConverterPrefs());
            graphViewItemPrefsDialog.setUseAsDefault(GraphView.this.parentTab.isLiveView());
            graphViewItemPrefsDialog.open();
            if (!graphViewItemPrefsDialog.hasBeenCanceled() && graphViewItemPrefsDialog.useAsDefaultSelected()) {
                GraphView.this.viewPrefs.persistCachedDescPrefs(this.desc);
            }
        }
    }

    private final class EditDisplayedValuesAction
    extends AbstractAction {
        private EditDisplayedValuesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DisplayChain[] displayChainArray;
            AbstractDialog abstractDialog;
            JFrame jFrame = MainModel.getDefaultParentFrame();
            if (OptionalMessageDialog.isShowingMsg("displayvalues.editnotice.msg")) {
                abstractDialog = new OptionalMessageDialog(jFrame, "displayvalues.editnotice.msg", MainResources.getResourceBundle());
                abstractDialog.setDoCancel(false);
                abstractDialog.setOkText("Continue");
                DialogUtil.safeDispatchThreadCall(abstractDialog, "open");
                if (abstractDialog.hasBeenCanceled()) {
                    return;
                }
            }
            abstractDialog = new GraphDisplayedValuesDialog(jFrame, GraphView.this.dataset, GraphView.this.displaySet.getDisplayChains());
            int n = GraphView.this.viewPrefs.getLastLiveDeviceId();
            int n2 = GraphView.this.viewPrefs.getLastLiveSerialNum();
            abstractDialog.setUseAsDefault(GraphView.this.parentTab.isLiveView() || GraphView.this.lastSerialNum == n2 && GraphView.this.lastDeviceId == n);
            abstractDialog.open();
            if (!abstractDialog.hasBeenCanceled() && (displayChainArray = abstractDialog.getChainsToDisplay()) != null) {
                GraphView.this.displaySet.setDisplayChains(displayChainArray);
                if (abstractDialog.useAsDefaultSelected()) {
                    GraphView.this.viewPrefs.setDefaultDisplayChains(Arrays.asList(displayChainArray));
                }
            }
        }
    }

    final class GraphMouseListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener {
        static final int STATE_NONE = 0;
        static final int STATE_DRAG_SELECT = 1;
        static final int STATE_DRAG_MOVE_ZOOM = 2;
        int mouseState;
        Point lastMousePressedPoint;
        Point lastMouseDragPoint;
        int lastMouseZoomy;
        double centerTimeWhenPressed;
        public boolean pressGainedFocus;
        public boolean pressWasPopup;
        public boolean mouseWasDragged;

        public GraphMouseListener() {
            this.clearState();
        }

        public synchronized void clearState() {
            this.setMouseState(0);
            this.lastMousePressedPoint = null;
        }

        private void setMouseState(int n) {
            this.mouseState = n;
        }

        @Override
        public final synchronized void mousePressed(MouseEvent mouseEvent) {
            this.lastMousePressedPoint = mouseEvent.getPoint();
            this.lastMouseZoomy = mouseEvent.getPoint().y;
            this.centerTimeWhenPressed = GraphView.this.navModel.getCenterTime();
            if (!GraphView.this.graph.isFocusOwner()) {
                GraphView.this.graph.requestFocusInWindow();
                this.pressGainedFocus = true;
            } else {
                this.pressGainedFocus = false;
            }
            this.pressWasPopup = mouseEvent.isPopupTrigger();
            this.mouseWasDragged = false;
            if (GraphView.this.parentTab.isStreaming()) {
                // empty if block
            }
        }

        @Override
        public final synchronized void mouseReleased(MouseEvent mouseEvent) {
            this.setMouseState(0);
            if (GraphView.this.parentTab.isStreaming()) {
                // empty if block
            }
        }

        @Override
        public final synchronized void mouseClicked(MouseEvent mouseEvent) {
            if (GraphView.this.parentTab.isStreaming()) {
                // empty if block
            }
            if (!this.pressWasPopup && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n = mouseEvent.getClickCount() % 2;
                if (n == 1) {
                    double d = GraphView.this.graph.convertXToTime(mouseEvent.getPoint().x);
                    if (!this.pressGainedFocus && !GraphView.this.selectionModel.isTimeInSelection(d)) {
                        GraphView.this.selectionModel.setMomentSelection(GraphView.this.graph.convertXToTime(mouseEvent.getPoint().x));
                    }
                } else if (n == 0) {
                    double d = GraphView.this.graph.convertXToTime(mouseEvent.getPoint().x);
                    if (GraphView.this.selectionModel.isMomentSelection()) {
                        GraphView.this.navModel.setCenterTime(GraphView.this.selectionModel.getAnchorTime());
                        GraphView.this.selectionModel.clearSelection();
                    } else if (GraphView.this.selectionModel.isTimeInSelection(d)) {
                        GraphView.this.parentTab.zoomToSelection();
                    }
                }
            }
        }

        @Override
        public final synchronized void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public final synchronized void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public final synchronized void mouseDragged(MouseEvent mouseEvent) {
            if (GraphView.this.parentTab.isStreaming()) {
                // empty if block
            }
            if (this.pressWasPopup) {
                return;
            }
            boolean bl = this.mouseWasDragged = this.mouseWasDragged || Math.abs(mouseEvent.getPoint().x - this.lastMousePressedPoint.x) > 2 || Math.abs(mouseEvent.getPoint().y - this.lastMousePressedPoint.y) > 2;
            if (!this.mouseWasDragged) {
                return;
            }
            boolean bl2 = SwingUtilities.isLeftMouseButton(mouseEvent);
            boolean bl3 = SwingUtilities.isRightMouseButton(mouseEvent);
            if (this.mouseState == 0) {
                boolean bl4;
                boolean bl5 = bl2 && mouseEvent.isControlDown() || bl2 && mouseEvent.isShiftDown() || bl3;
                boolean bl6 = bl4 = bl2 && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown();
                if (this.lastMousePressedPoint != null) {
                    if (bl5) {
                        int n = mouseEvent.getPoint().x - this.lastMousePressedPoint.x;
                        GraphView.this.navModel.setCenterTime(GraphView.this.navModel.getCenterTime() - GraphView.this.viewPrefs.getDragPanFactor() * GraphView.this.graph.convertXDiffToTime(n));
                        this.setMouseState(2);
                    } else if (bl4) {
                        int n = GraphView.this.graph.clipXToGraphBounds(this.lastMousePressedPoint.x);
                        int n2 = GraphView.this.graph.clipXToGraphBounds(mouseEvent.getPoint().x);
                        GraphView.this.selectionModel.setSelectionTime(GraphView.this.graph.convertXToTime(n), GraphView.this.graph.convertXToTime(n2));
                        this.setMouseState(1);
                    }
                }
            } else if (this.mouseState == 2) {
                int n = mouseEvent.getPoint().x - this.lastMouseDragPoint.x;
                GraphView.this.navModel.setCenterTime(GraphView.this.navModel.getCenterTime() - GraphView.this.viewPrefs.getDragPanFactor() * GraphView.this.graph.convertXDiffToTime(n));
                int n3 = mouseEvent.getPoint().y - this.lastMouseZoomy;
                int n4 = GraphView.this.viewPrefs.getDragZoomTrigger();
                int n5 = n3 / n4;
                if (n5 != 0) {
                    this.lastMouseZoomy = mouseEvent.getPoint().y;
                    GraphView.this.parentTab.zoomByFactor(0.1f * (float)n5);
                }
            } else if (this.mouseState == 1) {
                int n = GraphView.this.graph.clipXToGraphBounds(mouseEvent.getPoint().x);
                GraphView.this.selectionModel.setExtentTime(GraphView.this.graph.convertXToTime(n));
            }
            this.lastMouseDragPoint = mouseEvent.getPoint();
        }

        @Override
        public final synchronized void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (GraphView.this.parentTab.isStreaming()) {
                // empty if block
            }
            if (mouseWheelEvent.getWheelRotation() == 0) {
                return;
            }
            if (mouseWheelEvent.isControlDown() || mouseWheelEvent.isShiftDown()) {
                float f = (float)mouseWheelEvent.getWheelRotation() * 0.1f;
                GraphView.this.parentTab.zoomByFactor(f);
            } else {
                double d = 0.03 * GraphView.this.navModel.getWidthTime();
                GraphView.this.navModel.setCenterTime(GraphView.this.navModel.getCenterTime() + d * (double)mouseWheelEvent.getWheelRotation());
                if (SwingUtilities.isLeftMouseButton(mouseWheelEvent)) {
                    this.mouseDragged(mouseWheelEvent);
                }
            }
        }
    }
}

