/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.DisplayChainDescUI;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPref;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.main.GraphViewPrefs;
import com.ecmtuning.ecmlink.view.main.MainResources;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.util.Resizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class GraphViewItemPrefsDialog
extends AbstractDialog {
    private final List descEditPrefs;
    private final List viewDescEditPrefs;
    private final List convEditPrefsSections;
    private final ValueHolder saveAsDefaultModel = new ValueHolder(false);
    JComponent contentPanel;

    public GraphViewItemPrefsDialog(Frame frame, GraphViewPrefs graphViewPrefs, DisplayChainDesc displayChainDesc, DataPreferences dataPreferences) {
        super(frame);
        DataPreferences dataPreferences2 = graphViewPrefs.getCachedDescPrefs(displayChainDesc);
        this.descEditPrefs = DisplayChainDescUI.getDescEditPrefs(displayChainDesc, dataPreferences2);
        this.viewDescEditPrefs = graphViewPrefs.getViewDescEditPrefs(displayChainDesc, (Component)((Object)this));
        this.convEditPrefsSections = displayChainDesc.getSourceChain().getEditPrefsSections(dataPreferences);
        this.setTitle(MainResources.getString("graphitemprefs.title"));
    }

    protected void setResizable() {
        this.setResizable(true);
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.FOUR2THREE.resizeDialogContent(jComponent);
    }

    public void setUseAsDefault(boolean bl) {
        this.saveAsDefaultModel.setValue(bl);
    }

    public boolean useAsDefaultSelected() {
        return this.saveAsDefaultModel.booleanValue();
    }

    protected JComponent buildContent() {
        if (this.contentPanel == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buildCenterPane(), "Center");
            jPanel.add((Component)this.buildButtonBarWithOKCancelApply(), "South");
            this.contentPanel = jPanel;
        }
        return this.contentPanel;
    }

    private JPanel buildCenterPane() {
        FormLayout formLayout = new FormLayout("");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.appendRow(DialogUtil.FILL_PREF_GROW_ROWSPEC);
        panelBuilder.appendColumn(DialogUtil.FILL_DEFAULT_GROW_COLSPEC);
        panelBuilder.add(this.buildMainPrefsPanel());
        panelBuilder.nextColumn();
        if (!this.convEditPrefsSections.isEmpty()) {
            panelBuilder.appendColumn(DialogUtil.UNRELATED_GAP_COLSPEC);
            panelBuilder.appendColumn(DialogUtil.CENTERED_PREF_NOGROW_COLSPEC);
            panelBuilder.appendColumn(DialogUtil.UNRELATED_GAP_COLSPEC);
            panelBuilder.appendColumn(DialogUtil.FILL_DEFAULT_GROW_COLSPEC);
            panelBuilder.nextColumn();
            panelBuilder.add((Component)new JSeparator(1));
            panelBuilder.nextColumn(2);
            panelBuilder.add(this.buildConverterPrefsPanel());
            panelBuilder.nextColumn();
            formLayout.setColumnGroups((int[][])new int[][]{{1, 5}});
        }
        panelBuilder.appendGlueRow();
        return panelBuilder.getPanel();
    }

    private Component buildMainPrefsPanel() {
        PanelBuilder panelBuilder = EditPref.createPanelBuilder();
        EditPref.addPrefsSection("Final overrides", this.descEditPrefs, panelBuilder, this.getTriggerChannel());
        panelBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        panelBuilder.nextLine();
        EditPref.addPrefsSection("View preferences", this.viewDescEditPrefs, panelBuilder, this.getTriggerChannel());
        JCheckBox jCheckBox = new JCheckBox("Save as defaults");
        jCheckBox.setModel((ButtonModel)new ToggleButtonAdapter((ValueModel)this.saveAsDefaultModel));
        jCheckBox.setToolTipText("Use these settings as defaults for new datalog tabs");
        panelBuilder.appendRow(new RowSpec("max(20dlu;d)"));
        panelBuilder.nextRow();
        panelBuilder.appendRow(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        panelBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        panelBuilder.add((Component)jCheckBox, new CellConstraints(1, panelBuilder.getRow(), 6, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        panelBuilder.nextLine(2);
        return panelBuilder.getPanel();
    }

    private Component buildConverterPrefsPanel() {
        PanelBuilder panelBuilder = EditPref.createPanelBuilder();
        for (EditPrefsSection editPrefsSection : this.convEditPrefsSections) {
            EditPref.addPrefsSection(editPrefsSection, panelBuilder, this.getTriggerChannel());
            panelBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
            panelBuilder.nextLine();
        }
        return panelBuilder.getPanel();
    }
}

