/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplayChainDesc;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.MemoryBackedPreferences;
import com.ecmtuning.ecmlink.device.data.prefsedit.BooleanEditPref;
import com.ecmtuning.ecmlink.device.data.prefsedit.ColorEditPref;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPref;
import com.ecmtuning.ecmlink.device.data.prefsedit.FontEditPref;
import com.ecmtuning.ecmlink.device.data.prefsedit.TextEditPref;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.GenericListenerAdapter;
import com.ecmtuning.ecmlink.view.main.GraphViewPrefsListener;
import com.ecmtuning.ecmlink.view.main.MainResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

final class GraphViewPrefs {
    static final String PREFS_KEY_AUTO_ALL_ON_FILE_OPEN = "autoallonfileopen";
    static final String PREFS_KEY_AUTO_ALL_ON_STREAM = "autoallonstream";
    static final String PREFS_KEY_AUTO_ZOOM_ON_FILE_OPEN = "autozoomonfileopen";
    static final String PREFS_KEY_AUTO_ZOOM_ON_STREAM = "autozoomonstream";
    static final String PREFS_KEY_DEFAULT_WIDTH_SECS = "defaultwidthsecs";
    static final String PREFS_KEY_LEGEND_UPDATE_HZ = "legendupdatehz";
    static final String PREFS_KEY_DRAG_PAN_FACTOR = "dragpanfactor";
    static final String PREFS_KEY_DRAG_ZOOM_TRIGGER = "dragzoomtrigger";
    static final String PREFS_KEY_DEFAULT_CHAINS = "defaultchains";
    static final String PREFS_KEY_GRAPH_COLORS = "graphcolors";
    static final String PREFS_KEY_LAST_LIVE_SERIAL_NUM = "lastliveserialnum";
    static final String PREFS_KEY_LAST_LIVE_DEVICE_ID = "lastlivedeviceid";
    static final String PREFS_KEY_DEVICE_CHAINS = "devchains";
    static final String PREFS_KEY_LEGEND_FONT = "font";
    static final String PREFS_KEY_LEGEND_COLUMNS = "legendcols";
    static final String PREFS_KEY_ANTIALIASED_TEXT = "antialias";
    static final String PREFS_KEY_BACKGROUND_COLOR = "graphbackground";
    static final String[] CACHED_VIEW_PREFS_KEYS = new String[]{"font", "legendcols", "antialias", "graphbackground"};
    static final String PREFS_KEY_SELECT_COLOR = "selectcolor";
    static final String PREFS_KEY_HASH_MARK_COLOR = "markcolor";
    static final String PREFS_KEY_DISPLAY_ON_ALL = "displayonall";
    static final String PREFS_KEY_FONT_SIZE_OVERRIDE = "fontsize";
    static final String PREFS_KEY_LINE_COLOR = "linecolor";
    static final String PREFS_KEY_LABEL_COLOR = "labelcolor";
    static final String PREFS_KEY_SHOW_IN_GRAPH = "showingraph";
    static final String PREFS_KEY_DASHED_LINE = "dashedline";
    static final String PREFS_KEY_THICK_LINE = "thickline";
    static final String[] CACHED_DESC_PREFS_KEYS = new String[]{"displayonall", "fontsize", "linecolor", "labelcolor", "showingraph", "dashedline", "thickline"};
    static final double DEFAULT_WIDTH_SECS = 10.0;
    static final double DEFAULT_DRAG_PAN_FACTOR = 1.0;
    static final int DEFAULT_DRAG_ZOOM_TRIGGER = 10;
    static Color[] DEFAULT_GRAPH_COLORS = new Color[]{Color.red, Color.green, Color.blue, Color.orange, Color.magenta, Color.yellow, Color.cyan};
    static final Color DEFAULT_SELECT_COLOR = new Color(0.4f, 0.4f, 0.4f, 0.5f);
    static final Color DEFAULT_HASH_MARK_COLOR = new Color(0.3f, 0.3f, 0.3f);
    static final Color DEFAULT_BACKGROUND_COLOR = Color.black;
    static final int DEFAULT_LEGEND_COLUMNS = 4;
    static final int DEFAULT_LEGEND_UPDATE_HZ = 5;
    static final boolean DEFAULT_ANTIALIASED_TEXT = true;
    static final int UNDEFINED_FONT_SIZE = -1;
    static final Font DEFAULT_LEGEND_FONT = Font.decode("Arial-plain-16");
    private static final String[] LAST_RESORT_DISPLAY_NAMES = new String[]{"RPM", "Airflow", "FrontO2", "Timing", "IntTemp", "CoolTemp", "KnockRet", "Speed", "ThrotPos"};
    private static final DataPreferences persistedViewPrefs = DataPreferences.getViewPreferences("graphdisplay");
    private final DataPreferences cachedViewPrefs = new DataPreferences(null, new MemoryBackedPreferences());
    private final HashMap cachedDescPrefs = new HashMap();
    private final GenericListenerAdapter adapter = new GenericListenerAdapter(GraphViewPrefsListener.class);
    private PreferenceChangeListener preferenceChangeListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String[] stringArray = new String[]{GraphViewPrefs.PREFS_KEY_LEGEND_COLUMNS, GraphViewPrefs.PREFS_KEY_LEGEND_FONT, "displayname", "displaymax", "displaymin", "displayprec", "displayunits"};
            if (BasicStrings.contains(stringArray, preferenceChangeEvent.getKey())) {
                GraphViewPrefs.this.firePrefsChanged(false);
            } else {
                GraphViewPrefs.this.firePrefsChanged(true);
            }
        }
    };

    GraphViewPrefs() {
        this.cachedViewPrefs.becomeCopyOf(this.getPersistedViewPrefs());
        this.cachedViewPrefs.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    void addGraphViewPrefsListener(GraphViewPrefsListener graphViewPrefsListener) {
        this.adapter.addListener(graphViewPrefsListener);
    }

    void removeGraphViewPrefsListener(GraphViewPrefsListener graphViewPrefsListener) {
        this.adapter.removeListener(graphViewPrefsListener);
    }

    protected void firePrefsChanged(boolean bl) {
        this.adapter.fire("graphViewPrefsChanged", bl);
    }

    final DataPreferences getPersistedViewPrefs() {
        return persistedViewPrefs;
    }

    final DataPreferences getCachedViewPrefs() {
        return this.cachedViewPrefs;
    }

    final void persistCachedViewPrefs() {
        persistedViewPrefs.copyValuesFrom(this.cachedViewPrefs, CACHED_VIEW_PREFS_KEYS);
    }

    final void persistCachedDescPrefs(DisplayChainDesc displayChainDesc) {
        DataPreferences dataPreferences = this.getPersistedDescPrefs(displayChainDesc);
        DataPreferences dataPreferences2 = this.getCachedDescPrefs(displayChainDesc);
        dataPreferences.copyValuesFrom(dataPreferences2, DisplayChainDesc.ALL_PREFS_KEYS);
        dataPreferences.copyValuesFrom(dataPreferences2, CACHED_DESC_PREFS_KEYS);
    }

    final synchronized DataPreferences getCachedDescPrefs(DisplayChainDesc displayChainDesc) {
        DataPreferences dataPreferences = (DataPreferences)this.cachedDescPrefs.get(displayChainDesc.getPrefsKeyPrefix());
        if (dataPreferences == null) {
            dataPreferences = new DataPreferences(null, new MemoryBackedPreferences());
            dataPreferences.becomeCopyOf(this.getPersistedDescPrefs(displayChainDesc));
            dataPreferences.addPreferenceChangeListener(this.preferenceChangeListener);
            this.cachedDescPrefs.put(displayChainDesc.getPrefsKeyPrefix(), dataPreferences);
        }
        return dataPreferences;
    }

    final DataPreferences getPersistedDescPrefs(DisplayChainDesc displayChainDesc) {
        return DataPreferences.getPreferences(displayChainDesc);
    }

    final List getViewDescEditPrefs(DisplayChainDesc displayChainDesc, Component component) {
        ArrayList<EditPref> arrayList = new ArrayList<EditPref>();
        DataPreferences dataPreferences = this.getCachedDescPrefs(displayChainDesc);
        DataPreferences dataPreferences2 = this.getPersistedDescPrefs(displayChainDesc);
        BooleanEditPref booleanEditPref = new BooleanEditPref((Preferences)dataPreferences, PREFS_KEY_SHOW_IN_GRAPH, true);
        arrayList.add(booleanEditPref);
        booleanEditPref.configureLabelAndTooltip(MainResources.getActionBundle(), "graphview.showItem");
        booleanEditPref = new BooleanEditPref((Preferences)dataPreferences2, PREFS_KEY_DISPLAY_ON_ALL, true);
        arrayList.add(booleanEditPref);
        booleanEditPref.configureLabelAndTooltip(MainResources.getActionBundle(), "graphview.showInDisplayAll");
        booleanEditPref = new BooleanEditPref((Preferences)dataPreferences, PREFS_KEY_DASHED_LINE, false);
        arrayList.add(booleanEditPref);
        booleanEditPref.configureLabelAndTooltip(MainResources.getActionBundle(), "graphview.dashedLine");
        booleanEditPref = new BooleanEditPref((Preferences)dataPreferences, PREFS_KEY_THICK_LINE, false);
        arrayList.add(booleanEditPref);
        booleanEditPref.configureLabelAndTooltip(MainResources.getActionBundle(), "graphview.thickLine");
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_FONT_SIZE_OVERRIDE, Integer.class);
        arrayList.add(textEditPref);
        textEditPref.set("Font size override", "The font size to use for this one item instead of the default", null);
        int n = this.getLegendFont().getSize();
        textEditPref.getFilteredModel().setFilterBypassValues(null, Integer.toString(n), new Integer(n));
        textEditPref.createAsSpinner(1.0);
        textEditPref.installFinalClipFilter(1.0f, 100.0f, 0);
        textEditPref.installDefaultBtn(Integer.toString(n));
        Color color = dataPreferences.getColor(PREFS_KEY_LINE_COLOR, Color.red);
        ColorEditPref colorEditPref = new ColorEditPref(dataPreferences, PREFS_KEY_LINE_COLOR, color, component);
        arrayList.add(colorEditPref);
        colorEditPref.set("Line color", "The color to use when drawing this line", null);
        Color color2 = dataPreferences.getColor(PREFS_KEY_LABEL_COLOR, Color.black);
        colorEditPref = new ColorEditPref(dataPreferences, PREFS_KEY_LABEL_COLOR, color2, component);
        arrayList.add(colorEditPref);
        colorEditPref.set("Label color", "The color to use when display this item in the graph legend", null);
        return arrayList;
    }

    final List getCachedViewEditPrefs(Component component) {
        ArrayList<EditPref> arrayList = new ArrayList<EditPref>();
        ColorEditPref colorEditPref = new ColorEditPref(this.cachedViewPrefs, PREFS_KEY_BACKGROUND_COLOR, DEFAULT_BACKGROUND_COLOR, component);
        arrayList.add(colorEditPref);
        colorEditPref.set("Background color", "The background color of the graph area", null);
        FontEditPref fontEditPref = new FontEditPref(this.cachedViewPrefs, PREFS_KEY_LEGEND_FONT, DEFAULT_LEGEND_FONT, component);
        arrayList.add(fontEditPref);
        fontEditPref.set("Legend font", "The font to use for displaying legend text", null);
        TextEditPref textEditPref = new TextEditPref((Preferences)this.cachedViewPrefs, PREFS_KEY_LEGEND_COLUMNS, 4);
        arrayList.add(textEditPref);
        textEditPref.set("Legend columns", "The number of columns to display in the legend", null);
        textEditPref.createAsSpinner(1.0);
        textEditPref.installFinalClipFilter(2.0f, 6.0f, 0);
        BooleanEditPref booleanEditPref = new BooleanEditPref((Preferences)this.cachedViewPrefs, PREFS_KEY_ANTIALIASED_TEXT, true);
        arrayList.add(booleanEditPref);
        booleanEditPref.set("Anti-alias legend text", "Performs anti-aliasing (smoothing) of legend text", null);
        return arrayList;
    }

    final List getPersistedViewEditPrefs() {
        ArrayList<EditPref> arrayList = new ArrayList<EditPref>();
        BooleanEditPref booleanEditPref = new BooleanEditPref((Preferences)persistedViewPrefs, PREFS_KEY_AUTO_ZOOM_ON_FILE_OPEN, false);
        arrayList.add(booleanEditPref);
        booleanEditPref.set("File auto-zoom-all", "Zooms graph to show all data when opening a new file", null);
        booleanEditPref = new BooleanEditPref((Preferences)persistedViewPrefs, PREFS_KEY_AUTO_ALL_ON_FILE_OPEN, false);
        arrayList.add(booleanEditPref);
        booleanEditPref.set("File auto-display-all", "Displays all possible values when opening a new file", null);
        booleanEditPref = new BooleanEditPref((Preferences)persistedViewPrefs, PREFS_KEY_AUTO_ZOOM_ON_STREAM, false);
        arrayList.add(booleanEditPref);
        booleanEditPref.set("Stream auto-zoom-all", "Zooms graph to show all data when a new stream is stopped", null);
        TextEditPref textEditPref = new TextEditPref((Preferences)persistedViewPrefs, PREFS_KEY_DRAG_PAN_FACTOR, 1.0);
        arrayList.add(textEditPref);
        textEditPref.set("Drag pan-factor", "Factor to apply to pan movement while dragging", null);
        textEditPref.createAsSpinner(0.1);
        textEditPref.installFinalClipFilter(1.0f, 5.0f, 1);
        textEditPref = new TextEditPref((Preferences)persistedViewPrefs, PREFS_KEY_DRAG_ZOOM_TRIGGER, 10);
        arrayList.add(textEditPref);
        textEditPref.set("Drag zoom-trigger", "Pixels of y-movement required to trigger a zoom while dragging", "pixels");
        textEditPref.createAsSpinner(1.0);
        textEditPref.installFinalClipFilter(1.0f, 100.0f, 0);
        textEditPref = new TextEditPref((Preferences)persistedViewPrefs, PREFS_KEY_DEFAULT_WIDTH_SECS, 10.0);
        arrayList.add(textEditPref);
        textEditPref.set("Default graph width", "The default width of the graph display when first opened or reset", "secs");
        textEditPref.createAsSpinner(0.5);
        textEditPref.installFinalClipFilter(1.0f, Float.MAX_VALUE, 1);
        textEditPref = new TextEditPref((Preferences)persistedViewPrefs, PREFS_KEY_LEGEND_UPDATE_HZ, 5);
        arrayList.add(textEditPref);
        textEditPref.set("Legend update rate", "The number of times per second to update graph legend while streaming data", "Hz");
        textEditPref.createAsSpinner(1.0);
        textEditPref.installFinalClipFilter(1.0f, 30.0f, 0);
        return arrayList;
    }

    public final boolean getAutoAllOnFileOpen() {
        return this.getPersistedViewPrefs().getBoolean(PREFS_KEY_AUTO_ALL_ON_FILE_OPEN, false);
    }

    public final boolean getAutoAllOnStreamStart() {
        return this.getPersistedViewPrefs().getBoolean(PREFS_KEY_AUTO_ALL_ON_STREAM, false);
    }

    public final boolean getAutoZoomOnFileOpen() {
        return this.getPersistedViewPrefs().getBoolean(PREFS_KEY_AUTO_ZOOM_ON_FILE_OPEN, false);
    }

    public final boolean getAutoZoomOnStreamStop() {
        return this.getPersistedViewPrefs().getBoolean(PREFS_KEY_AUTO_ZOOM_ON_STREAM, false);
    }

    final double getDefaultDisplayWidthSecs() {
        return this.getPersistedViewPrefs().getDouble(PREFS_KEY_DEFAULT_WIDTH_SECS, 10.0);
    }

    final int getLegendUpdateHz() {
        return this.getPersistedViewPrefs().getInt(PREFS_KEY_LEGEND_UPDATE_HZ, 5);
    }

    final double getDragPanFactor() {
        return this.getPersistedViewPrefs().getDouble(PREFS_KEY_DRAG_PAN_FACTOR, 1.0);
    }

    final int getDragZoomTrigger() {
        return this.getPersistedViewPrefs().getInt(PREFS_KEY_DRAG_ZOOM_TRIGGER, 10);
    }

    final List getDefaultDisplayChains() {
        this.getPersistedViewPrefs().removeAll(PREFS_KEY_DEVICE_CHAINS);
        ArrayList<DisplayChain> arrayList = this.getPersistedViewPrefs().getDisplayChains(PREFS_KEY_DEFAULT_CHAINS, null);
        if (arrayList == null) {
            int n = 3;
            LocationTOC locationTOC = DataManager.createCompleteTOC(n, 0, 65535);
            List list = DisplayChain.generateDisplayChains(locationTOC);
            arrayList = new ArrayList<DisplayChain>();
            for (int i = 0; i < LAST_RESORT_DISPLAY_NAMES.length; ++i) {
                for (DisplayChain displayChain : list) {
                    DisplayChainDesc displayChainDesc = displayChain.getCurrentChainDesc();
                    if (!displayChainDesc.getDisplayName().equals(LAST_RESORT_DISPLAY_NAMES[i])) continue;
                    arrayList.add(displayChain);
                }
            }
        }
        return arrayList;
    }

    final void setDefaultDisplayChains(List list) {
        this.getPersistedViewPrefs().putDisplayChains(PREFS_KEY_DEFAULT_CHAINS, list);
    }

    final Color[] getDefaultGraphColors() {
        return this.getPersistedViewPrefs().getColors(PREFS_KEY_GRAPH_COLORS, DEFAULT_GRAPH_COLORS);
    }

    final int getLastLiveDeviceId() {
        return this.getPersistedViewPrefs().getInt(PREFS_KEY_LAST_LIVE_DEVICE_ID, 0);
    }

    final int getLastLiveSerialNum() {
        return this.getPersistedViewPrefs().getInt(PREFS_KEY_LAST_LIVE_SERIAL_NUM, 0);
    }

    final void setLastLiveDeviceIdAndSerialNum(int n, int n2) {
        this.getPersistedViewPrefs().putInt(PREFS_KEY_LAST_LIVE_DEVICE_ID, n);
        this.getPersistedViewPrefs().putInt(PREFS_KEY_LAST_LIVE_SERIAL_NUM, n2);
    }

    final Font getLegendFont() {
        return this.cachedViewPrefs.getFont(PREFS_KEY_LEGEND_FONT, DEFAULT_LEGEND_FONT);
    }

    final boolean getAntialiasedText() {
        return this.cachedViewPrefs.getBoolean(PREFS_KEY_ANTIALIASED_TEXT, true);
    }

    final int getLegendColumnCount() {
        return this.cachedViewPrefs.getInt(PREFS_KEY_LEGEND_COLUMNS, 4);
    }

    final Color getGraphBackgroundColor() {
        return this.cachedViewPrefs.getColor(PREFS_KEY_BACKGROUND_COLOR, DEFAULT_BACKGROUND_COLOR);
    }

    final Color getSelectColor() {
        return this.cachedViewPrefs.getColor(PREFS_KEY_SELECT_COLOR, DEFAULT_SELECT_COLOR);
    }

    final Color getHashMarkColor() {
        return this.cachedViewPrefs.getColor(PREFS_KEY_HASH_MARK_COLOR, DEFAULT_HASH_MARK_COLOR);
    }

    final Color getLineColor(DisplayChainDesc displayChainDesc) {
        return this.getCachedDescPrefs(displayChainDesc).getColor(PREFS_KEY_LINE_COLOR, null);
    }

    final void setLineColor(DisplayChainDesc displayChainDesc, Color color) {
        DataPreferences dataPreferences = this.getCachedDescPrefs(displayChainDesc);
        if (color == null) {
            dataPreferences.remove(PREFS_KEY_LINE_COLOR);
        } else {
            dataPreferences.putColor(PREFS_KEY_LINE_COLOR, color);
        }
    }

    final int getLegendFontSizeOverride(DisplayChainDesc displayChainDesc) {
        return this.getCachedDescPrefs(displayChainDesc).getInt(PREFS_KEY_FONT_SIZE_OVERRIDE, -1);
    }

    final Color getLabelColor(DisplayChainDesc displayChainDesc) {
        return this.getCachedDescPrefs(displayChainDesc).getColor(PREFS_KEY_LABEL_COLOR, Color.BLACK);
    }

    final void setLableColor(DisplayChainDesc displayChainDesc, Color color) {
        DataPreferences dataPreferences = this.getCachedDescPrefs(displayChainDesc);
        if (color == null) {
            dataPreferences.remove(PREFS_KEY_LABEL_COLOR);
        } else {
            dataPreferences.putColor(PREFS_KEY_LABEL_COLOR, color);
        }
    }

    final boolean getShowInGraph(DisplayChainDesc displayChainDesc) {
        return this.getCachedDescPrefs(displayChainDesc).getBoolean(PREFS_KEY_SHOW_IN_GRAPH, true);
    }

    final boolean getDefaultShowInGraph(DisplayChainDesc displayChainDesc) {
        return this.getPersistedDescPrefs(displayChainDesc).getBoolean(PREFS_KEY_SHOW_IN_GRAPH, true);
    }

    final boolean getDisplayOnAll(DisplayChainDesc displayChainDesc) {
        return this.getPersistedDescPrefs(displayChainDesc).getBoolean(PREFS_KEY_DISPLAY_ON_ALL, true);
    }

    final void setShowInGraph(DisplayChainDesc displayChainDesc, boolean bl) {
        if (bl) {
            this.getCachedDescPrefs(displayChainDesc).remove(PREFS_KEY_SHOW_IN_GRAPH);
        } else {
            this.getCachedDescPrefs(displayChainDesc).putBoolean(PREFS_KEY_SHOW_IN_GRAPH, bl);
        }
    }

    final boolean getThickLine(DisplayChainDesc displayChainDesc) {
        return this.getCachedDescPrefs(displayChainDesc).getBoolean(PREFS_KEY_THICK_LINE, false);
    }

    final boolean getDashedLine(DisplayChainDesc displayChainDesc) {
        return this.getCachedDescPrefs(displayChainDesc).getBoolean(PREFS_KEY_DASHED_LINE, false);
    }
}

