/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.data.prefsedit.EditPref;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.main.GraphViewPrefs;
import com.ecmtuning.ecmlink.view.main.MainResources;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.util.Resizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GraphViewPrefsDialog
extends AbstractDialog {
    private final GraphViewPrefs prefs;
    private final ValueHolder saveAsDefaultModel = new ValueHolder(false);
    JComponent contentPanel;

    public GraphViewPrefsDialog(Frame frame, GraphViewPrefs graphViewPrefs) {
        super(frame);
        this.prefs = graphViewPrefs;
        this.setTitle(MainResources.getString("graphprefs.title"));
    }

    protected void setResizable() {
        this.setResizable(true);
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.FOUR2THREE.resizeDialogContent(jComponent);
    }

    public void setUseAsDefault(boolean bl) {
        this.saveAsDefaultModel.setValue(bl);
    }

    public boolean useAsDefaultSelected() {
        return this.saveAsDefaultModel.booleanValue();
    }

    protected JComponent buildContent() {
        if (this.contentPanel == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buildTabbedPane(), "Center");
            jPanel.add((Component)this.buildButtonBarWithOKCancelApply(), "South");
            this.contentPanel = jPanel;
        }
        return this.contentPanel;
    }

    private JTabbedPane buildTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Local view settings", this.buildLocalTab());
        jTabbedPane.addTab("Global settings", this.buildGeneralTab());
        return jTabbedPane;
    }

    private Component buildLocalTab() {
        PanelBuilder panelBuilder = EditPref.createPanelBuilder();
        panelBuilder.setDefaultDialogBorder();
        List list = this.prefs.getCachedViewEditPrefs((Component)((Object)this));
        EditPref.addPrefsSection("Local preferences", list, panelBuilder, this.getTriggerChannel());
        JCheckBox jCheckBox = new JCheckBox("Save as defaults");
        jCheckBox.setModel((ButtonModel)new ToggleButtonAdapter((ValueModel)this.saveAsDefaultModel));
        jCheckBox.setToolTipText("Use these settings as defaults for new datalog tabs");
        panelBuilder.appendRow(new RowSpec("max(20dlu;d)"));
        panelBuilder.nextRow();
        panelBuilder.appendRow(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        panelBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        panelBuilder.add((Component)jCheckBox, new CellConstraints(1, panelBuilder.getRow(), 6, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        panelBuilder.nextLine(2);
        return panelBuilder.getPanel();
    }

    private Component buildGeneralTab() {
        PanelBuilder panelBuilder = EditPref.createPanelBuilder();
        panelBuilder.setDefaultDialogBorder();
        List list = this.prefs.getPersistedViewEditPrefs();
        EditPref.addPrefsSection("General preferences", list, panelBuilder, this.getTriggerChannel());
        return panelBuilder.getPanel();
    }
}

