/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.view.main.Animations;
import com.jgoodies.animation.old.AnimatedPanel;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uifextras.convenience.DefaultAboutToolPanel;
import com.jgoodies.uifextras.panel.GradientBackgroundPanel;
import com.jgoodies.uifextras.util.ThinBevelBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.HelpBroker;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class MainAboutToolPanel
extends DefaultAboutToolPanel {
    private final AnimatedPanel animatedPanel;
    private final MainModel mainModel;

    public MainAboutToolPanel(MainModel mainModel) {
        this.mainModel = mainModel;
        this.animatedPanel = new AnimatedPanel(Animations.aboutAnimation(), true);
    }

    public void build() {
        super.build();
        this.addComponentListener(this.animatedPanel.createStartStopListener());
    }

    protected JComponent buildAcknowledgementsPanel() {
        JComponent jComponent = super.buildAcknowledgementsPanel();
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        jPanel.setOpaque(false);
        jPanel.add((Component)jComponent, "North");
        jPanel.add((Component)this.buildAnimationPanel(), "Center");
        return jPanel;
    }

    private JComponent buildAnimationPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Dimension dimension = new Dimension(140, 40);
        this.animatedPanel.setPreferredSize(dimension);
        this.animatedPanel.setMinimumSize(dimension);
        jPanel.add((Component)new GradientBackgroundPanel((JComponent)this.animatedPanel, true));
        jPanel.setBorder((Border)new ThinBevelBorder(1));
        return jPanel;
    }

    public void stopAnimation() {
        if (this.animatedPanel != null) {
            this.animatedPanel.stop();
        }
    }

    protected JButton createShowLicenseButton() {
        JButton jButton = new JButton("Show License");
        jButton.setMnemonic('S');
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBroker helpBroker = MainAboutToolPanel.this.mainModel.getHelpBroker();
                if (helpBroker != null) {
                    ((AbstractDialog)SwingUtilities.getWindowAncestor((Component)((Object)MainAboutToolPanel.this))).close();
                    helpBroker.setCurrentURL(MainAboutToolPanel.this.getLicenseAgreementURL());
                    helpBroker.setDisplayed(true);
                }
            }
        });
        return jButton;
    }
}

