/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.view.main.MainView;
import com.jgoodies.uif.AbstractFrame;
import com.jgoodies.uif.application.Application;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.help.HelpBroker;
import javax.swing.JComponent;
import javax.swing.JRootPane;

public class MainFrame
extends AbstractFrame {
    private static final float DEFAULT_WIDTH_TO_HEIGHT_RATIO = 1.58f;
    private static final Dimension MINIMUM_SIZE = new Dimension(600, 400);
    private MainModel mainModel = MainModel.getInstance();
    private MainView mainView;

    public MainFrame() {
        super(Application.getDescription().getWindowTitle());
    }

    public void build() {
        super.build();
        this.setJMenuBar(this.mainView.getMenuBar());
        JRootPane jRootPane = this.getRootPane();
        HelpBroker helpBroker = this.mainModel.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.enableHelpKey((Component)jRootPane, "helproot", null);
        }
    }

    protected JComponent buildContentPane() {
        this.mainView = new MainView(this.mainModel);
        return this.mainView.getPanel();
    }

    public Dimension getWindowMinimumSize() {
        return MINIMUM_SIZE;
    }

    protected void configureCloseOperation() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(Application.getApplicationCloseOnWindowClosingHandler());
    }

    public String getWindowID() {
        return "main";
    }

    protected void storeState() {
        try {
            super.storeState();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void restoreState() {
        Dimension dimension;
        Rectangle rectangle;
        if (!this.hasStoredState()) {
            rectangle = new Rectangle();
            dimension = this.getToolkit().getScreenSize();
            rectangle.height = Math.round((float)dimension.height * 0.7f);
            rectangle.height = Math.min(700, rectangle.height);
            rectangle.width = (int)((float)rectangle.height * 1.58f);
            rectangle.width = Math.min(dimension.width, rectangle.width);
            rectangle.height = (int)((float)rectangle.width / 1.58f);
            rectangle.x = (dimension.width - rectangle.width) / 2;
            rectangle.y = (dimension.height - rectangle.height) / 2;
            this.setBounds(rectangle);
        } else {
            super.restoreState();
        }
        rectangle = this.mainModel.getHelpBroker();
        if (rectangle != null) {
            dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            Dimension dimension3 = this.getSize();
            dimension3.height = (int)((float)dimension2.height * 0.85f);
            if (dimension3.height > dimension.height - 50) {
                dimension3.height = dimension.height - 50;
            }
            dimension3.width = (int)((float)dimension3.height * 1.58f);
            if (dimension3.width > dimension.width - 20) {
                dimension3.width = dimension.width - 20;
            }
            rectangle.setSize(dimension3);
            int n = dimension.width - dimension3.width;
            Point point = this.getLocation();
            if (n > point.x + dimension2.width / 2) {
                n = point.x + dimension2.width / 2;
            }
            rectangle.setLocation(new Point(n, point.y + 15));
        }
    }
}

