/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.TrackedTabbedPane;
import com.ecmtuning.ecmlink.view.main.MenuBarView;
import com.ecmtuning.ecmlink.view.main.StatusBarView;
import com.ecmtuning.ecmlink.view.main.ToolBarView;
import com.jgoodies.uif.AbstractView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class MainView
extends AbstractView {
    private final MainModel mainModel;
    private ToolBarView toolBarView;
    private MenuBarView menuBarView;
    private StatusBarView primaryStatusBarView;
    private TrackedTabbedPane mainTabPane;
    private static final Dimension PREFERRED_SIZE = Toolkit.getDefaultToolkit().getScreenSize().width >= 800 ? new Dimension(730, 523) : new Dimension(632, 443);

    MainView(MainModel mainModel) {
        this.mainModel = mainModel;
        mainModel.registerMainView(this);
    }

    JMenuBar getMenuBar() {
        return this.menuBarView.getMenuBar();
    }

    public TrackedTabbedPane getTabbedPane() {
        return this.mainTabPane;
    }

    public MenuBarView getMenuBarView() {
        return this.menuBarView;
    }

    public ToolBarView getToolBarView() {
        return this.toolBarView;
    }

    private void initComponents() {
        this.toolBarView = new ToolBarView(this.mainModel);
        this.menuBarView = new MenuBarView(this.mainModel);
        this.primaryStatusBarView = new StatusBarView(this.mainModel.getPrimaryStatusBarModel());
    }

    protected JComponent buildPanel() {
        this.initComponents();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.toolBarView.getToolBar(), "North");
        jPanel.add((Component)this.buildMainCenter(), "Center");
        jPanel.add((Component)this.buildStatusBar(), "South");
        jPanel.setPreferredSize(PREFERRED_SIZE);
        return jPanel;
    }

    private JComponent buildMainCenter() {
        this.mainTabPane = new TrackedTabbedPane(1);
        this.mainTabPane.setModel(this.mainModel.getTabPanelSelectionModel());
        return this.mainTabPane;
    }

    private JPanel buildStatusBar() {
        JPanel jPanel = (JPanel)this.primaryStatusBarView.getPanel();
        return jPanel;
    }

    public ArrayList getTabs() {
        return this.mainTabPane.getTabs();
    }
}

