/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.view.main.MainResources;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.builder.MenuBuilder;
import com.jgoodies.uif.osx.OSXApplicationMenu;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.help.HelpBroker;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuBarView {
    private final MainModel mainModel;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu viewMenu;
    private JMenu helpMenu;

    MenuBarView(MainModel mainModel) {
        this.mainModel = mainModel;
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = this.buildMenuBar();
        }
        return this.menuBar;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getViewMenu() {
        return this.viewMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    private synchronized JMenuBar buildMenuBar() {
        Object object;
        if (this.menuBar != null) {
            return this.menuBar;
        }
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        jMenuBar.putClientProperty("jgoodies.windows.borderStyle", BorderStyle.SEPARATOR);
        jMenuBar.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
        InputMap inputMap = jMenuBar.getInputMap(2);
        ActionMap actionMap = jMenuBar.getActionMap();
        if (inputMap != null && actionMap != null && actionMap.getParent() != null && (object = inputMap.get(KeyStroke.getKeyStroke("F10"))) != null) {
            actionMap.getParent().remove(object);
        }
        this.fileMenu = this.buildFileMenu();
        this.editMenu = this.buildEditMenu();
        this.viewMenu = this.buildViewMenu();
        this.helpMenu = this.buildHelpMenu();
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.editMenu);
        jMenuBar.add(this.viewMenu);
        jMenuBar.add(this.helpMenu);
        return jMenuBar;
    }

    private JMenu buildFileMenu() {
        MenuBuilder menuBuilder = new MenuBuilder("File", 'F');
        menuBuilder.add(MainActions.getAction("openFile"));
        menuBuilder.add(MainActions.getAction("exportFile"));
        menuBuilder.add(MainActions.getAction("saveFile"));
        menuBuilder.add(MainActions.getAction("saveFileAs"));
        menuBuilder.add(MainActions.getAction("closeFile"));
        if (!OSXApplicationMenu.isRegisteredQuit()) {
            menuBuilder.addSeparator();
            menuBuilder.add(MainActions.getAction("exitApp"));
        }
        return menuBuilder.getMenu();
    }

    private JMenu buildMainDeviceMenu() {
        MenuBuilder menuBuilder = new MenuBuilder(new JMenu("Main device"));
        PropertyAdapter propertyAdapter = new PropertyAdapter((Object)DeviceManagerFactory.getInstance(), "mainDMId", true);
        ToggleAction toggleAction = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)new Integer(1));
        toggleAction.putValue("Name", (Object)"ECMLink ECU");
        ToggleAction toggleAction2 = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)new Integer(2));
        toggleAction2.putValue("Name", (Object)"Mitsu/MUT-II");
        menuBuilder.addToggle(toggleAction);
        menuBuilder.addToggle(toggleAction2);
        DeviceManagerFactory.getInstance().addPropertyChangeListener("mainDMId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MenuBarView.this.displayDeviceRestartWarning();
            }
        });
        return menuBuilder.getMenu();
    }

    void displayDeviceRestartWarning() {
        if (OptionalMessageDialog.isShowingMsg("devicerestart.msg")) {
            MenuBarView menuBarView = this;
            OptionalMessageDialog optionalMessageDialog = new OptionalMessageDialog(menuBarView.mainModel.getDefaultParentFrame(), "devicerestart.msg", MainResources.getResourceBundle());
            optionalMessageDialog.setDoCancel(false);
            optionalMessageDialog.setOkText("Ok");
            DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
        }
    }

    private JMenu buildEditMenu() {
        MenuBuilder menuBuilder = new MenuBuilder("Edit", 'E');
        menuBuilder.add(MainActions.getAction("displayValues"));
        menuBuilder.add(MainActions.getAction("capturedValues"));
        menuBuilder.addSeparator();
        menuBuilder.add(MainActions.getAction("selectAll"));
        menuBuilder.add(MainActions.getAction("selectNone"));
        menuBuilder.add(MainActions.getAction("clipSelection"));
        menuBuilder.addSeparator();
        menuBuilder.add(MainActions.getAction("find"));
        menuBuilder.add(MainActions.getAction("findNext"));
        if (!OSXApplicationMenu.isRegisteredPreferences()) {
            menuBuilder.addSeparator();
            menuBuilder.add(MainActions.getAction("openPreferences"));
        }
        return menuBuilder.getMenu();
    }

    private JMenu buildViewMenu() {
        MenuBuilder menuBuilder = new MenuBuilder("View", 'V');
        menuBuilder.addToggle((ToggleAction)MainActions.getAction("showMainDeviceTab"));
        DeviceManagerFactory deviceManagerFactory = DeviceManagerFactory.getInstance();
        if (deviceManagerFactory.getAuxDeviceManager() != null) {
            menuBuilder.addToggle((ToggleAction)MainActions.getAction("showAuxDeviceTab"));
        }
        menuBuilder.addToggle((ToggleAction)MainActions.getAction("showLiveDatalogTab"));
        menuBuilder.addToggle((ToggleAction)MainActions.getAction("showToolbar"));
        menuBuilder.addSeparator();
        menuBuilder.add(MainActions.getAction("prevTab"));
        menuBuilder.add(MainActions.getAction("nextTab"));
        menuBuilder.add(MainActions.getAction("closeTab"));
        return menuBuilder.getMenu();
    }

    private JMenu buildHelpMenu() {
        MenuBuilder menuBuilder = new MenuBuilder("Help", 'H');
        JMenuItem jMenuItem = menuBuilder.add(MainActions.getAction("openHelpContents"));
        HelpBroker helpBroker = this.mainModel.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.enableHelpOnButton((Component)jMenuItem, "helproot", null);
        }
        if (!OSXApplicationMenu.isRegisteredAbout()) {
            menuBuilder.addSeparator();
            menuBuilder.add(MainActions.getAction("openAboutDialog"));
        }
        return menuBuilder.getMenu();
    }
}

