/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.SerialPortManager;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.preferences.PortConfigView;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.uif.AbstractDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.help.HelpBroker;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class PortConfigDialog
extends AbstractDialog {
    private JButton helpButton;
    private static final String helpId = "portconfig";
    private PresentationModel model;

    public PortConfigDialog(Frame frame, SerialPortManager serialPortManager) {
        super(frame);
        this.setTitle("Serial port configuration");
        this.model = new PresentationModel((Object)serialPortManager, this.getTriggerChannel());
        HelpBroker helpBroker = MainModel.getInstance().getHelpBroker();
        if (helpBroker != null) {
            JRootPane jRootPane = this.getRootPane();
            helpBroker.enableHelpKey((Component)jRootPane, helpId, null);
        }
    }

    public void close() {
        super.close();
        this.model.setBean(null);
    }

    protected void setResizable() {
        this.setResizable(true);
    }

    protected JComponent buildContent() {
        this.helpButton = DialogUtil.createDefaultHelpButton(helpId);
        JPanel jPanel = new JPanel(new BorderLayout());
        PortConfigView portConfigView = new PortConfigView(this.model);
        jPanel.add((Component)portConfigView.getPanel(), "Center");
        jPanel.add((Component)this.buildButtonBarWithOKCancelAnd(this.helpButton), "South");
        return jPanel;
    }
}

