/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.control.DeviceUIAdapterInterface;
import com.ecmtuning.ecmlink.control.DeviceUIController;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.model.StatusBarModel;
import com.jgoodies.uif.AbstractView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;

public class StatusBarView
extends AbstractView
implements PropertyChangeListener {
    private StatusBarModel statusBarModel;
    private JPanel statusBarPanel;
    private JLabel statusText;
    private JButton statusStateButton;
    private JProgressBar statusProgressBar;

    public StatusBarView(StatusBarModel statusBarModel) {
        this.statusBarModel = statusBarModel;
        statusBarModel.addPropertyChangeListener(this);
    }

    protected JComponent buildPanel() {
        this.statusBarPanel = new JPanel();
        this.statusText = new JLabel();
        this.statusStateButton = new JButton();
        JPanel jPanel = new JPanel();
        this.statusProgressBar = new JProgressBar();
        this.statusBarPanel.setLayout(new BorderLayout());
        this.statusBarPanel.add((Component)this.statusText, "West");
        this.statusStateButton.setPreferredSize(new Dimension(16, 16));
        this.statusStateButton.setMinimumSize(new Dimension(16, 16));
        this.statusStateButton.setMaximumSize(new Dimension(16, 16));
        this.statusStateButton.setBorder(new BevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlShadow));
        this.statusStateButton.setFocusable(false);
        this.statusStateButton.setRequestFocusEnabled(false);
        this.statusBarPanel.add((Component)this.statusStateButton, "East");
        StateButtonAction stateButtonAction = new StateButtonAction();
        stateButtonAction.putValue("ShortDescription", "Configure device connection settings");
        this.statusStateButton.setAction(stateButtonAction);
        jPanel.setLayout(new BorderLayout());
        this.statusProgressBar.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.statusProgressBar.setFocusable(false);
        this.statusProgressBar.setBorder(new BevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlShadow));
        this.statusProgressBar.setForeground(SystemColor.textHighlight);
        jPanel.add((Component)this.statusProgressBar, "East");
        this.statusBarPanel.add((Component)jPanel, "Center");
        return this.statusBarPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBarView.this.statusProgressBar.setValue(StatusBarView.this.statusBarModel.getStatusProgress());
                StatusBarView.this.statusText.setText(StatusBarView.this.statusBarModel.getStatusText());
                switch (StatusBarView.this.statusBarModel.getStatusState()) {
                    case 2: {
                        StatusBarView.this.statusStateButton.setBackground(Color.ORANGE.darker());
                        break;
                    }
                    case 3: {
                        StatusBarView.this.statusStateButton.setBackground(Color.RED.darker());
                        break;
                    }
                    case 1: {
                        StatusBarView.this.statusStateButton.setBackground(UIManager.getColor("Button.background"));
                        break;
                    }
                    case 0: {
                        StatusBarView.this.statusStateButton.setBackground(Color.GREEN.darker());
                    }
                }
            }
        });
    }

    class StateButtonAction
    extends AbstractAction {
        StateButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainModel mainModel = MainModel.getInstance();
            DeviceUIController deviceUIController = mainModel.getDeviceUIController();
            DeviceUIAdapterInterface deviceUIAdapterInterface = StatusBarView.this.statusBarModel.isPrimary() ? deviceUIController.getMainAdapter() : deviceUIController.getAuxAdapter();
            Action action = deviceUIAdapterInterface.getConnectionConfigurationAction();
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }
}

