/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.device.data.TimeSelectionListener;
import com.ecmtuning.ecmlink.device.data.TimeSelectionModel;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TextDisplayTimePanel
extends JPanel {
    private final JLabel timeLabel = new JLabel();
    private final JLabel unitsLabel = new JLabel();
    TimeSelectionModel displayTimeModel;
    TimeSelectionModel selectionModel;
    TimeSelectionListener displayTSL = new TimeSelectionListener(){

        @Override
        public void selectionChanged(double d, double d2) {
            TextDisplayTimePanel.this._selectionChanged(false, d, d2);
        }
    };
    TimeSelectionListener selectionTSL = new TimeSelectionListener(){

        @Override
        public void selectionChanged(double d, double d2) {
            TextDisplayTimePanel.this._selectionChanged(true, d, d2);
        }
    };

    public TextDisplayTimePanel() {
        this.setLayout(new BorderLayout(4, 0));
        this.timeLabel.setHorizontalAlignment(4);
        this.add((Component)this.timeLabel, "Center");
        this.unitsLabel.setText("secs");
        this.add((Component)this.unitsLabel, "East");
    }

    public synchronized void connect(TimeSelectionModel timeSelectionModel, TimeSelectionModel timeSelectionModel2) {
        this.disconnect();
        timeSelectionModel.addTimeSelectionListener(this.displayTSL);
        timeSelectionModel2.addTimeSelectionListener(this.selectionTSL);
        this.displayTimeModel = timeSelectionModel;
        this.selectionModel = timeSelectionModel2;
        if (timeSelectionModel2.isSelectionActive()) {
            this._selectionChanged(true, timeSelectionModel2.getAnchorTime(), timeSelectionModel2.getExtentTime());
        } else if (timeSelectionModel.isSelectionActive()) {
            this._selectionChanged(false, timeSelectionModel.getAnchorTime(), timeSelectionModel2.getExtentTime());
        }
    }

    public synchronized void disconnect() {
        if (this.displayTimeModel != null) {
            this.displayTimeModel.removeTimeSelectionListener(this.displayTSL);
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeTimeSelectionListener(this.selectionTSL);
        }
        this.selectionModel = null;
        this.displayTimeModel = null;
        this.timeLabel.setText("-");
    }

    public void setLabelFont(Font font, Font font2) {
        this.timeLabel.setFont(font);
        this.unitsLabel.setFont(font2);
    }

    synchronized void _selectionChanged(boolean bl, double d, double d2) {
        if (d == Double.MIN_VALUE) {
            if (!bl) {
                this.timeLabel.setText("-");
            }
        } else {
            double d3;
            StringBuffer stringBuffer = new StringBuffer(XFormatter.format((float)(d / 1000000.0), 3));
            if (d2 != Double.MIN_VALUE && (d3 = Math.abs(d2 - d)) > 4.0E-4) {
                stringBuffer.append(", w=");
                stringBuffer.append(XFormatter.format((float)(d3 / 1000000.0), 3));
            }
            this.timeLabel.setText(stringBuffer.toString());
        }
    }
}

