/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.main;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.model.MainModel;
import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.uif.builder.ToolBarBuilder;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ToolBarView
implements PropertyChangeListener {
    private final MainModel mainModel;
    private JToolBar toolBar;
    private JButton openButton;
    private JButton saveButton;
    private JButton saveAsButton;
    private JButton closeTabButton;
    private Component lastToolbarComponent;

    ToolBarView(MainModel mainModel) {
        this.mainModel = mainModel;
        mainModel.addPropertyChangeListener("showToolbar", this);
    }

    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.buildToolBar();
            this.toolBar.setVisible(this.mainModel.getShowToolbar());
        }
        return this.toolBar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
            this.toolBar.setVisible(true);
        } else {
            this.toolBar.setVisible(false);
        }
    }

    public JButton getOpenButton() {
        return this.openButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getSaveAsButton() {
        return this.saveAsButton;
    }

    public Component getLastToolbarComponent() {
        return this.lastToolbarComponent;
    }

    private JToolBar buildToolBar() {
        ToolBarBuilder toolBarBuilder = new ToolBarBuilder("ToolBar", (Object)HeaderStyle.BOTH);
        toolBarBuilder.getToolBar().putClientProperty("jgoodies.windows.borderStyle", BorderStyle.SEPARATOR);
        toolBarBuilder.getToolBar().putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
        toolBarBuilder.addSeparator();
        this.openButton = toolBarBuilder.add(MainActions.getAction("openFile"));
        this.saveButton = toolBarBuilder.add(MainActions.getAction("saveFile"));
        this.saveAsButton = toolBarBuilder.add(MainActions.getAction("saveFileAs"));
        toolBarBuilder.addSeparator();
        toolBarBuilder.add(MainActions.getAction("openPreferences"));
        toolBarBuilder.addSeparator();
        toolBarBuilder.add(MainActions.getAction("startStream"));
        toolBarBuilder.add(MainActions.getAction("startCapture"));
        toolBarBuilder.addSeparator();
        this.closeTabButton = toolBarBuilder.add(MainActions.getAction("closeTab"));
        this.lastToolbarComponent = this.closeTabButton;
        return toolBarBuilder.getToolBar();
    }
}

