/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.mitsu;

import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceManager;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceMap;
import com.ecmtuning.ecmlink.util.model.ComboMap;
import com.ecmtuning.ecmlink.util.model.Integer2ComboFilter;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.IntRangeValidator;
import com.ecmtuning.ecmlink.view.main.AbstractConfigDialog;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MitsuConfigDialog
extends AbstractConfigDialog {
    private final MitsuDeviceManager deviceManager;
    private JComboBox comboTryDevice;
    private JTextField tfByteDelay;
    private JTextField tfCmdTimeout;
    private JTextField tfBitRate;
    private JTextField tfDiagHold;
    private final int TRY_DEVICE_PRE95 = 0;
    private final int TRY_DEVICE_97UP = 1;
    private ValueHolder tryDeviceIntHolder = new ValueHolder(0);
    ComboMap[] tryDeviceMap = new ComboMap[]{new ComboMap(0, "MUT - pre 1995"), new ComboMap(1, "MUT - 1997+")};

    public MitsuConfigDialog(Frame frame, MitsuDeviceManager mitsuDeviceManager) {
        super(frame, mitsuDeviceManager);
        this.deviceManager = mitsuDeviceManager;
    }

    @Override
    protected String getConfigDialogTitle() {
        return "Mitsu Connection Settings";
    }

    @Override
    protected String getHelpID() {
        return "mitsu.connectionsettings";
    }

    @Override
    protected void updateView() {
        this.tfBitRate.setText(Integer.toString(this.deviceManager.getBitRate()));
        this.tfDiagHold.setText(Long.toString(this.deviceManager.getDiagSleepTimeMillis()));
        this.tfByteDelay.setText(Long.toString(this.deviceManager.getByteDelayMillis()));
        this.tfCmdTimeout.setText(Long.toString(this.deviceManager.getCmdTimeoutMillis()));
        int n = this.deviceManager.getConnectTryDevId();
        if (MitsuDeviceMap.isPre95DeviceId(n)) {
            this.tryDeviceIntHolder.setValue(0);
        } else if (MitsuDeviceMap.is97UpDeviceId(n)) {
            this.tryDeviceIntHolder.setValue(1);
        } else {
            this.tryDeviceIntHolder.setValue(0);
        }
        super.updateView();
    }

    @Override
    protected void updateModel() {
        this.deviceManager.setBitRate(Integer.parseInt(this.tfBitRate.getText()));
        this.deviceManager.setDiagSleepTimeMillis(Long.parseLong(this.tfDiagHold.getText()));
        this.deviceManager.setByteDelayMillis(Long.parseLong(this.tfByteDelay.getText()));
        this.deviceManager.setCmdTimeoutMillis(Long.parseLong(this.tfCmdTimeout.getText()));
        int n = this.tryDeviceIntHolder.intValue();
        if (n == 0) {
            this.deviceManager.setConnectTryDevId(0x7F000000);
        } else if (n == 1) {
            this.deviceManager.setConnectTryDevId(0x7E000000);
        } else {
            this.deviceManager.setConnectTryDevId(0x7F000000);
        }
        super.updateModel();
    }

    @Override
    protected JPanel buildAdvancedPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.appendRows(rowSpec, rowSpec2);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("Advanced");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(rowSpec, rowSpec3);
        panelBuilder.addLabel("Bit rate:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.tfBitRate);
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(rowSpec, rowSpec3);
        panelBuilder.addLabel("Diag hold:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.tfDiagHold);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("ms");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(rowSpec, rowSpec3);
        panelBuilder.addLabel("Byte delay:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.tfByteDelay);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("ms");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(rowSpec, rowSpec3);
        panelBuilder.addLabel("Cmd timeout:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.tfCmdTimeout);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("ms");
        panelBuilder.nextLine(2, 2);
        return panelBuilder.getPanel();
    }

    @Override
    protected Component getECUTypeComponent() {
        return this.comboTryDevice;
    }

    @Override
    protected void initComponents() {
        ValueModelPlug valueModelPlug = new ValueModelPlug((ValueModel)this.tryDeviceIntHolder, null);
        Integer2ComboFilter integer2ComboFilter = new Integer2ComboFilter(0, this.tryDeviceMap[0]);
        integer2ComboFilter.addValidCombos(this.tryDeviceMap);
        valueModelPlug.addObjectFilter(integer2ComboFilter);
        this.comboTryDevice = BasicComponentFactory.createComboBox((SelectionInList)new SelectionInList((Object[])this.tryDeviceMap, (ValueModel)valueModelPlug));
        this.tfBitRate = new JTextField(5);
        new IntRangeValidator(this.tfBitRate, 1200, 62500);
        this.tfBitRate.setHorizontalAlignment(4);
        this.tfBitRate.setToolTipText("Bitrate for communication; default is 1952 for old MUT-II, 10400 for OBD2/hybrid, 15625 for new MUT-II");
        this.tfDiagHold = new JTextField(5);
        new IntRangeValidator(this.tfDiagHold, 0, 500);
        this.tfDiagHold.setHorizontalAlignment(4);
        this.tfDiagHold.setToolTipText("Time to hold diag pin low before sending a command; not used in every protocol");
        this.tfByteDelay = new JTextField(5);
        new IntRangeValidator(this.tfByteDelay, 0, 100);
        this.tfByteDelay.setHorizontalAlignment(4);
        this.tfByteDelay.setToolTipText("Delay between bytes; only really needed for MUT/OBD2 hybrid mode");
        this.tfCmdTimeout = new JTextField(5);
        new IntRangeValidator(this.tfCmdTimeout, 50, 1500);
        this.tfCmdTimeout.setHorizontalAlignment(4);
        this.tfCmdTimeout.setToolTipText("Time to wait for a reply; default: 300ms");
        super.initComponents();
    }
}

