/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.preferences;

import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.preferences.PatternDialog;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class FilenameView
extends AbstractView {
    private JCheckBox cbRememberLastAutoOpen;
    private JCheckBox cbAutoCreateSubDir;
    private JTextField tfSaveToDir;
    private JTextField tfAutoCreateSpec;
    private JTextField tfSaveAsSpec;
    private JTextField tfDeviceSaveAsSpec;
    private JTextField tfDirectAccessSaveAsSpec;
    private JButton btnSaveToDir;
    private JButton btnAutoCreateSpec;
    private JButton btnSaveAsSpec;
    private JButton btnDeviceSaveAsSpec;
    private JButton btnDirectAccessSaveAsSpec;
    private final PresentationModel model;

    public FilenameView(PresentationModel presentationModel) {
        this.model = presentationModel;
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(new ColumnSpec("200dlu"));
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.PREF_SHRINK_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("New Datalog Files", cellConstraints.xyw(1, n, 7));
        n += 2;
        n = DialogUtil.addTriplet(panelBuilder, "Base directory:", this.tfSaveToDir, this.btnSaveToDir, cellConstraints.xy(2, n));
        panelBuilder.add((Component)this.cbAutoCreateSubDir, cellConstraints.xyw(4, n, 4));
        n += 2;
        n = DialogUtil.addTriplet(panelBuilder, "", this.tfAutoCreateSpec, this.btnAutoCreateSpec, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, "Filename pattern:", this.tfSaveAsSpec, this.btnSaveAsSpec, cellConstraints.xy(2, n));
        panelBuilder.add((Component)this.cbRememberLastAutoOpen, cellConstraints.xyw(2, n, 6));
        panelBuilder.addSeparator("New Device Data Files", cellConstraints.xyw(1, n += 2, 7));
        n += 2;
        n = DialogUtil.addTriplet(panelBuilder, "ECU settings:", this.tfDeviceSaveAsSpec, this.btnDeviceSaveAsSpec, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, "Direct access:", this.tfDirectAccessSaveAsSpec, this.btnDirectAccessSaveAsSpec, cellConstraints.xy(2, n));
        return panelBuilder.getPanel();
    }

    private void initComponents() {
        this.cbRememberLastAutoOpen = BasicComponentFactory.createCheckBox((ValueModel)this.model.getBufferedModel("rememberLastAutoOpen"), (String)"Remember last auto-opened directory");
        BufferedValueModel bufferedValueModel = this.model.getBufferedModel("datalogCreateDirectory");
        this.cbAutoCreateSubDir = BasicComponentFactory.createCheckBox((ValueModel)bufferedValueModel, (String)"Auto create subdirectory");
        BufferedValueModel bufferedValueModel2 = this.model.getBufferedModel("datalogBaseDirectory");
        this.tfSaveToDir = BasicComponentFactory.createTextField((ValueModel)bufferedValueModel2, (boolean)true);
        this.btnSaveToDir = new JButton(new SelectDirectoryAction((ValueModel)bufferedValueModel2));
        bufferedValueModel2 = this.model.getBufferedModel("datalogCreateDirectorySpec");
        this.tfAutoCreateSpec = BasicComponentFactory.createTextField((ValueModel)bufferedValueModel2, (boolean)true);
        this.btnAutoCreateSpec = new JButton(new EditPatternAction((ValueModel)bufferedValueModel2));
        bufferedValueModel2 = this.model.getBufferedModel("datalogSaveAsFileSpec");
        this.tfSaveAsSpec = BasicComponentFactory.createTextField((ValueModel)bufferedValueModel2, (boolean)true);
        this.btnSaveAsSpec = new JButton(new EditPatternAction((ValueModel)bufferedValueModel2));
        bufferedValueModel2 = this.model.getBufferedModel("deviceSettingsSaveAsFileSpec");
        this.tfDeviceSaveAsSpec = BasicComponentFactory.createTextField((ValueModel)bufferedValueModel2, (boolean)true);
        this.btnDeviceSaveAsSpec = new JButton(new EditPatternAction((ValueModel)bufferedValueModel2));
        bufferedValueModel2 = this.model.getBufferedModel("directAccessSaveAsFileSpec");
        this.tfDirectAccessSaveAsSpec = BasicComponentFactory.createTextField((ValueModel)bufferedValueModel2, (boolean)true);
        this.btnDirectAccessSaveAsSpec = new JButton(new EditPatternAction((ValueModel)bufferedValueModel2));
        DialogUtil.installComponentEnabler((ValueModel)bufferedValueModel, new Component[]{this.tfAutoCreateSpec, this.btnAutoCreateSpec});
    }

    static class SelectDirectoryAction
    extends AbstractAction {
        ValueModel dataModel;

        SelectDirectoryAction(ValueModel valueModel) {
            this.dataModel = valueModel;
            this.putValue("Name", "Browse\u2026");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.dataModel.getValue();
            boolean bl = FilenameModel.ensureDirectoryExists(string);
            if (!bl) {
                string = FilenameModel.findGoodDirectory(string);
            }
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setDialogTitle("Select a Base Directory");
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(MainModel.getDefaultParentFrame());
            if (n == 0 && jFileChooser.getSelectedFile() != null) {
                try {
                    this.dataModel.setValue((Object)jFileChooser.getSelectedFile().getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static class EditPatternAction
    extends AbstractAction {
        ValueModel dataModel;

        EditPatternAction(ValueModel valueModel) {
            this.dataModel = valueModel;
            this.putValue("Name", "Edit\u2026");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PatternDialog patternDialog = new PatternDialog(MainModel.getDefaultParentFrame(), (String)this.dataModel.getValue());
            patternDialog.open();
            if (!patternDialog.hasBeenCanceled()) {
                this.dataModel.setValue((Object)patternDialog.getPattern());
            }
        }
    }
}

