/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.preferences;

import com.ecmtuning.ecmlink.util.ListUtil;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uifextras.util.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class PatternDialog
extends AbstractDialog {
    private JTextField tfPattern;
    private JLabel lblResultContent;
    private JScrollPane spReference;
    private JTable tblReference;
    private final String initialPattern;
    private ValueHolder patternModel;
    private ValueModel bufferedPattern;
    private SimpleDateFormat formatter = new SimpleDateFormat();
    private Date formatterDate = new Date();
    static String[][] refTableData = new String[][]{{"'text'", "Literal"}, {"'log.'yyyy.MM.dd", "Example"}, {"'logs.'yyyy.MM", "Example"}, {"yyyy", "Year"}, {"yy", "Year"}, {"MMMMM", "Month"}, {"MMM", "Month"}, {"MM", "Month"}, {"dd", "Day"}, {"HH", "Hour"}, {"mm", "Minute"}, {"ss", "Second"}, {"SSS", "Millisecond"}, {"EEE", "Week day"}};

    public PatternDialog(Frame frame, String string) {
        super(frame);
        this.initialPattern = string;
        this.setTitle("Pattern editor");
        this.patternModel = new ValueHolder((Object)string);
        this.bufferedPattern = new BufferedValueModel((ValueModel)this.patternModel, this.getTriggerChannel());
        this.bufferedPattern.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PatternDialog.this.updateResult();
            }
        });
    }

    public String getPattern() {
        return this.patternModel.getString();
    }

    protected void updateResult() {
        try {
            this.formatter.applyPattern((String)this.bufferedPattern.getValue());
            this.lblResultContent.setText(this.formatter.format(this.formatterDate));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.lblResultContent.setText((String)this.bufferedPattern.getValue());
        }
    }

    public void close() {
        super.close();
        try {
            this.formatter.applyPattern((String)this.patternModel.getValue());
            this.lblResultContent.setText(this.formatter.format(this.formatterDate));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected JComponent buildContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildCenterPanel(), "Center");
        jPanel.add((Component)this.buildButtonBarWithOKCancel(), "South");
        this.updateResult();
        return jPanel;
    }

    protected JComponent buildCenterPanel() {
        this.initComponents();
        RowSpec rowSpec = FormFactory.PREF_ROWSPEC;
        RowSpec rowSpec2 = FormFactory.LINE_GAP_ROWSPEC;
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(FormFactory.UNRELATED_GAP_COLSPEC);
        arrayList.add(new ColumnSpec("right:pref"));
        arrayList.add(FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(new ColumnSpec("100dlu"));
        arrayList.add(FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(new ColumnSpec("100dlu"));
        arrayList.add(FormFactory.GLUE_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, new RowSpec("100dlu"));
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("Filename Pattern", cellConstraints.xyw(1, n, 7));
        panelBuilder.addLabel("Pattern:", cellConstraints.xy(2, n += 2));
        panelBuilder.add((Component)this.tfPattern, cellConstraints.xy(4, n));
        panelBuilder.addLabel("Result:", cellConstraints.xy(2, n += 2));
        panelBuilder.add((Component)this.lblResultContent, cellConstraints.xy(4, n));
        panelBuilder.addSeparator("Reference", cellConstraints.xyw(1, n += 2, 7));
        panelBuilder.add((Component)this.spReference, cellConstraints.xyw(2, n += 2, 5));
        return panelBuilder.getPanel();
    }

    private void initComponents() {
        this.tfPattern = BasicComponentFactory.createTextField((ValueModel)this.bufferedPattern, (boolean)false);
        this.lblResultContent = UIFactory.createBoldLabel((String)"");
        int n = refTableData.length;
        Object[][] objectArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new String[3];
            objectArray[i][0] = refTableData[i][0];
            objectArray[i][1] = refTableData[i][1];
            this.formatter.applyPattern(refTableData[i][0]);
            objectArray[i][2] = this.formatter.format(this.formatterDate);
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, new String[]{"Pattern", "Description", "Result"});
        this.tblReference = new JTable(defaultTableModel){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.tblReference.setColumnSelectionAllowed(false);
        this.tblReference.setRowSelectionAllowed(false);
        this.tblReference.setCellSelectionEnabled(false);
        this.tblReference.setFocusable(false);
        this.tblReference.getTableHeader().setReorderingAllowed(false);
        this.spReference = new JScrollPane();
        this.spReference.setViewportView(this.tblReference);
    }
}

