/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.preferences;

import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PortConfigView
extends AbstractView {
    private JList allPortsList;
    private JList skippedPortsList;
    private JButton doSkipButton;
    private JButton doUseButton;
    private JTextField forceIdTextField;
    private JCheckBox doBackgroundScanBox;
    private BufferedValueModel skippedListValueModel;
    private final PresentationModel model;
    private boolean defineBorder;

    public PortConfigView(PresentationModel presentationModel) {
        this.model = presentationModel;
    }

    public void setDefineBorder(boolean bl) {
        this.defineBorder = bl;
    }

    protected JComponent buildPanel() {
        this.initComponents();
        String string = "100dlu:grow";
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(new ColumnSpec(string));
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(new ColumnSpec(string));
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, DialogUtil.LABEL_COMPONENT_GAP_ROWSPEC);
        ListUtil.add(arrayList2, new RowSpec("40dlu"), DialogUtil.LABEL_COMPONENT_GAP_ROWSPEC);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec4);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        if (this.defineBorder) {
            panelBuilder.setDefaultDialogBorder();
        }
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("System Defined", cellConstraints.xyw(1, n, 4));
        panelBuilder.addLabel("All ports", cellConstraints.xy(2, n += 2));
        panelBuilder.addLabel("Will skip", cellConstraints.xy(4, n));
        panelBuilder.add((Component)new JScrollPane(this.allPortsList), cellConstraints.xy(2, n += 2));
        panelBuilder.add((Component)new JScrollPane(this.skippedPortsList), cellConstraints.xy(4, n));
        panelBuilder.add((Component)this.doSkipButton, cellConstraints.xy(2, n += 2));
        panelBuilder.add((Component)this.doUseButton, cellConstraints.xy(4, n));
        panelBuilder.add((Component)this.doBackgroundScanBox, cellConstraints.xyw(2, n += 2, 3));
        panelBuilder.addSeparator("Manually Add", cellConstraints.xyw(1, n += 2, 4));
        panelBuilder.addLabel("COM port id:", cellConstraints.xywh(2, n += 2, 1, 1, "right,default"));
        panelBuilder.add((Component)this.forceIdTextField, cellConstraints.xy(4, n));
        return panelBuilder.getPanel();
    }

    private void initComponents() {
        this.allPortsList = BasicComponentFactory.createList((SelectionInList)new SelectionInList((ValueModel)this.model.getBufferedModel("portIdListFromOsModel")));
        this.skippedListValueModel = this.model.getBufferedModel("skippedPortIdList");
        this.skippedPortsList = BasicComponentFactory.createList((SelectionInList)new SelectionInList((ValueModel)this.skippedListValueModel));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList;
                String string = (String)PortConfigView.this.allPortsList.getSelectedValue();
                if (string != null && !(arrayList = (ArrayList)PortConfigView.this.skippedListValueModel.getValue()).contains(string)) {
                    ArrayList<String> arrayList2 = new ArrayList<String>(arrayList);
                    arrayList2.add(string);
                    Collections.sort(arrayList2);
                    PortConfigView.this.skippedListValueModel.setValue(arrayList2);
                }
            }
        };
        abstractAction.putValue("Name", "Skip");
        abstractAction.setEnabled(false);
        this.doSkipButton = new JButton(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PortConfigView.this.skippedPortsList.getSelectedIndex();
                if (n != -1) {
                    ArrayList arrayList = new ArrayList((ArrayList)PortConfigView.this.skippedListValueModel.getValue());
                    arrayList.remove(n);
                    PortConfigView.this.skippedListValueModel.setValue(arrayList);
                }
            }
        };
        abstractAction2.putValue("Name", "Use");
        abstractAction2.setEnabled(false);
        this.doUseButton = new JButton(abstractAction2);
        DialogUtil.registerListSelectionEnabler(this.allPortsList.getSelectionModel(), abstractAction);
        DialogUtil.registerListSelectionEnabler(this.skippedPortsList.getSelectionModel(), abstractAction2);
        this.forceIdTextField = BasicComponentFactory.createTextField((ValueModel)this.model.getBufferedModel("forcedPortId"));
        this.doBackgroundScanBox = BasicComponentFactory.createCheckBox((ValueModel)this.model.getModel("doBackgroundPortScan"), (String)"Scan for new/removed ports");
    }
}

