/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.preferences;

import com.ecmtuning.ecmlink.device.SerialPortManager;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.preferences.FilenameView;
import com.ecmtuning.ecmlink.view.preferences.GeneralTabView;
import com.ecmtuning.ecmlink.view.preferences.PortConfigView;
import com.ecmtuning.ecmlink.view.preferences.SmallerLafChoiceView;
import com.ecmtuning.ecmlink.view.preferences.UnitsView;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.util.Resizer;
import com.jgoodies.uifextras.laf.LafChoiceModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.help.HelpBroker;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;

public class PreferencesDialog
extends AbstractDialog {
    public static final int SELECTED_INDEX_GENERAL = 0;
    public static final int SELECTED_INDEX_UNITS = 1;
    public static final int SELECTED_INDEX_FILENAME = 2;
    public static final int SELECTED_INDEX_PORTS = 3;
    private final MainModel mainModel;
    private final int initialSelectedTabIndex;
    private JButton helpButton;
    private PresentationModel generalViewModel;
    private PresentationModel portConfigModel;
    private PresentationModel filenameModel;
    private PresentationModel unitsModel;
    private static final String helpId = "preferences";
    JComponent contentPanel;

    public PreferencesDialog(Frame frame) {
        this(frame, 0);
    }

    public PreferencesDialog(Frame frame, int n) {
        super(frame);
        this.initialSelectedTabIndex = n;
        this.mainModel = MainModel.getInstance();
        this.setTitle("Application Preferences");
        HelpBroker helpBroker = this.mainModel.getHelpBroker();
        if (helpBroker != null) {
            JRootPane jRootPane = this.getRootPane();
            helpBroker.enableHelpKey((Component)jRootPane, helpId, null);
        }
    }

    public void initPresentation() {
        this.buildContentPane();
        this.disconnectModels();
    }

    private void disconnectModels() {
        this.generalViewModel.setBean(null);
        this.filenameModel.setBean(null);
        this.unitsModel.setBean(null);
        this.portConfigModel.setBean(null);
        this.generalViewModel = null;
        this.portConfigModel = null;
        this.filenameModel = null;
        this.unitsModel = null;
        this.setDefaultButton(null);
    }

    public void close() {
        this.disconnectModels();
        super.close();
    }

    protected void setResizable() {
        this.setResizable(true);
    }

    protected JComponent buildContent() {
        if (this.contentPanel == null) {
            this.helpButton = DialogUtil.createDefaultHelpButton(helpId);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buildTabbedPane(), "Center");
            jPanel.add((Component)this.buildButtonBarWithOKCancelApplyAnd(this.helpButton), "South");
            this.contentPanel = jPanel;
        }
        return this.contentPanel;
    }

    protected JTabbedPane buildTabbedPane() {
        SerialPortManager serialPortManager = SerialPortManager.getInstance();
        SmallerLafChoiceView smallerLafChoiceView = new SmallerLafChoiceView(new LafChoiceModel(this.getTriggerChannel()));
        this.generalViewModel = new PresentationModel((Object)this.mainModel, this.getTriggerChannel());
        GeneralTabView generalTabView = new GeneralTabView(this.generalViewModel);
        this.filenameModel = new PresentationModel((Object)this.mainModel.getFilenameModel(), this.getTriggerChannel());
        FilenameView filenameView = new FilenameView(this.filenameModel);
        this.unitsModel = new PresentationModel((Object)UnitsModel.getInstance(), this.getTriggerChannel());
        UnitsView unitsView = new UnitsView(this.unitsModel);
        this.portConfigModel = new PresentationModel((Object)serialPortManager, this.getTriggerChannel());
        PortConfigView portConfigView = new PortConfigView(this.portConfigModel);
        portConfigView.setDefineBorder(true);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("General", generalTabView.getPanel());
        jTabbedPane.addTab("Units", unitsView.getPanel());
        jTabbedPane.addTab("Filenames", filenameView.getPanel());
        jTabbedPane.addTab("Ports", portConfigView.getPanel());
        jTabbedPane.addTab("Look & Feel", smallerLafChoiceView.getPanel());
        jTabbedPane.setSelectedIndex(this.initialSelectedTabIndex);
        return jTabbedPane;
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.FOUR2THREE.resizeDialogContent(jComponent);
    }
}

