/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.preferences;

import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class UnitsView
extends AbstractView {
    private final PresentationModel model;
    private JButton btnMetric;
    private JButton btnImperial;
    private ValueModel airflowIndexModel;
    private ValueModel temperatureIndexModel;
    private ValueModel boostIndexModel;
    private ValueModel distanceIndexModel;
    private ValueModel injectorSizeIndexModel;
    private ValueModel fluidIndexModel;
    private ValueModel afMixtureIndexModel;
    private SelectionInList airflowSelectionModel;
    private SelectionInList temperatureSelectionModel;
    private SelectionInList boostSelectionModel;
    private SelectionInList distanceSelectionModel;
    private SelectionInList injectorSizeSelectionModel;
    private SelectionInList fluidSelectionModel;
    private SelectionInList afMixtureSelectionModel;
    private JComboBox cbAirflow;
    private JComboBox cbTemperature;
    private JComboBox cbBoost;
    private JComboBox cbDistance;
    private JComboBox cbInjectorSize;
    private JComboBox cbFuel;
    private JComboBox cbAfMixture;
    ActionListener systemAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == UnitsView.this.btnMetric) {
                UnitsView.this.airflowIndexModel.setValue((Object)UnitsModel.INDEX_AIRFLOW_MASS_GRAMS);
                UnitsView.this.temperatureIndexModel.setValue((Object)UnitsModel.INDEX_TEMPERATURE_C);
                UnitsView.this.boostIndexModel.setValue((Object)UnitsModel.INDEX_BOOST_PRESSURE_BAR);
                UnitsView.this.distanceIndexModel.setValue((Object)UnitsModel.INDEX_DISTANCE_KILOMETERS);
                UnitsView.this.injectorSizeIndexModel.setValue((Object)UnitsModel.INDEX_INJECTOR_SIZE_CCPMIN);
                UnitsView.this.fluidIndexModel.setValue((Object)UnitsModel.INDEX_FLUID_PRESSURE_KPA);
            } else if (actionEvent.getSource() == UnitsView.this.btnImperial) {
                UnitsView.this.airflowIndexModel.setValue((Object)UnitsModel.INDEX_AIRFLOW_MASS_POUNDS);
                UnitsView.this.temperatureIndexModel.setValue((Object)UnitsModel.INDEX_TEMPERATURE_F);
                UnitsView.this.boostIndexModel.setValue((Object)UnitsModel.INDEX_BOOST_PRESSURE_PSI);
                UnitsView.this.distanceIndexModel.setValue((Object)UnitsModel.INDEX_DISTANCE_MILES);
                UnitsView.this.injectorSizeIndexModel.setValue((Object)UnitsModel.INDEX_INJECTOR_SIZE_LBPHR);
                UnitsView.this.fluidIndexModel.setValue((Object)UnitsModel.INDEX_FLUID_PRESSURE_PSI);
            }
        }
    };

    public UnitsView(PresentationModel presentationModel) {
        this.model = presentationModel;
    }

    protected JComponent buildPanel() {
        this.initComponents();
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, DialogUtil.UNRELATED_GAP_ROWSPEC);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{{2, 4}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Displayed Units", cellConstraints.xyw(1, 1, 5));
        int n = 3;
        panelBuilder.addLabel("Airflow mass:", (CellConstraints)cellConstraints.xy(2, n).clone(), (Component)this.cbAirflow, cellConstraints.xy(4, n));
        panelBuilder.addLabel("Temperature:", (CellConstraints)cellConstraints.xy(2, n += 2).clone(), (Component)this.cbTemperature, cellConstraints.xy(4, n));
        panelBuilder.addLabel("Air pressure:", (CellConstraints)cellConstraints.xy(2, n += 2).clone(), (Component)this.cbBoost, cellConstraints.xy(4, n));
        panelBuilder.addLabel("Fluid pressure:", (CellConstraints)cellConstraints.xy(2, n += 2).clone(), (Component)this.cbFuel, cellConstraints.xy(4, n));
        panelBuilder.addLabel("Distance:", (CellConstraints)cellConstraints.xy(2, n += 2).clone(), (Component)this.cbDistance, cellConstraints.xy(4, n));
        panelBuilder.addLabel("Injector size:", (CellConstraints)cellConstraints.xy(2, n += 2).clone(), (Component)this.cbInjectorSize, cellConstraints.xy(4, n));
        panelBuilder.addLabel("A/F mixture:", (CellConstraints)cellConstraints.xy(2, n += 2).clone(), (Component)this.cbAfMixture, cellConstraints.xy(4, n));
        panelBuilder.add((Component)this.btnMetric, cellConstraints.xy(2, n += 2, CellConstraints.FILL, CellConstraints.DEFAULT));
        panelBuilder.add((Component)this.btnImperial, cellConstraints.xy(4, n, CellConstraints.FILL, CellConstraints.DEFAULT));
        return panelBuilder.getPanel();
    }

    private void initComponents() {
        this.btnMetric = new JButton("Metric");
        this.btnImperial = new JButton("Imperial");
        this.btnMetric.addActionListener(this.systemAction);
        this.btnImperial.addActionListener(this.systemAction);
        this.airflowSelectionModel = new SelectionInList((Object[])UnitsModel.SELECT_LIST_AIRFLOW_MASS);
        this.airflowIndexModel = this.model.getBufferedModel("airflowMassIndex");
        this.airflowSelectionModel.setSelectionIndexHolder(this.airflowIndexModel);
        this.temperatureSelectionModel = new SelectionInList((Object[])UnitsModel.SELECT_LIST_TEMPERATURE);
        this.temperatureIndexModel = this.model.getBufferedModel("temperatureIndex");
        this.temperatureSelectionModel.setSelectionIndexHolder(this.temperatureIndexModel);
        this.boostSelectionModel = new SelectionInList((Object[])UnitsModel.SELECT_LIST_BOOST_PRESSURE);
        this.boostIndexModel = this.model.getBufferedModel("boostPressureIndex");
        this.boostSelectionModel.setSelectionIndexHolder(this.boostIndexModel);
        this.distanceSelectionModel = new SelectionInList((Object[])UnitsModel.SELECT_LIST_DISTANCE);
        this.distanceIndexModel = this.model.getBufferedModel("distanceIndex");
        this.distanceSelectionModel.setSelectionIndexHolder(this.distanceIndexModel);
        this.injectorSizeSelectionModel = new SelectionInList((Object[])UnitsModel.SELECT_LIST_INJECTOR_SIZE);
        this.injectorSizeIndexModel = this.model.getBufferedModel("injectorSizeIndex");
        this.injectorSizeSelectionModel.setSelectionIndexHolder(this.injectorSizeIndexModel);
        this.fluidSelectionModel = new SelectionInList((Object[])UnitsModel.SELECT_LIST_FLUID_PRESSURE);
        this.fluidIndexModel = this.model.getBufferedModel("fluidPressureIndex");
        this.fluidSelectionModel.setSelectionIndexHolder(this.fluidIndexModel);
        this.afMixtureSelectionModel = new SelectionInList((Object[])UnitsModel.SELECT_LIST_AF_MIXTURE);
        this.afMixtureIndexModel = this.model.getBufferedModel("afMixtureIndex");
        this.afMixtureSelectionModel.setSelectionIndexHolder(this.afMixtureIndexModel);
        this.cbAirflow = BasicComponentFactory.createComboBox((SelectionInList)this.airflowSelectionModel);
        this.cbTemperature = BasicComponentFactory.createComboBox((SelectionInList)this.temperatureSelectionModel);
        this.cbBoost = BasicComponentFactory.createComboBox((SelectionInList)this.boostSelectionModel);
        this.cbDistance = BasicComponentFactory.createComboBox((SelectionInList)this.distanceSelectionModel);
        this.cbInjectorSize = BasicComponentFactory.createComboBox((SelectionInList)this.injectorSizeSelectionModel);
        this.cbFuel = BasicComponentFactory.createComboBox((SelectionInList)this.fluidSelectionModel);
        this.cbAfMixture = BasicComponentFactory.createComboBox((SelectionInList)this.afMixtureSelectionModel);
    }
}

