/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif;

import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.component.UIFButton;
import com.jgoodies.uif.util.ComponentUtils;
import com.jgoodies.uif.util.Mode;
import com.jgoodies.uif.util.Modes;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uif.util.UIFFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public abstract class AbstractDialog
extends JDialog {
    public static final String PROPERTYNAME_TRIGGER_CHANNEL = "triggerChannel";
    protected static final String APPLY_LABEL = "Apply";
    protected static final String CANCEL_LABEL = "Cancel";
    protected static final String CLOSE_LABEL = "Close";
    protected static final String OK_LABEL = "OK";
    protected static final String RESET_LABEL = "Reset";
    private static final String ACCEPT_ID = "accept";
    private static final String APPLY_ID = "apply";
    private static final String CANCEL_ID = "cancel";
    private static final String CLOSE_ID = "close";
    private static final String RESET_ID = "reset";
    private static Mode escapeCancelsDefaultMode = Modes.ALWAYS;
    private boolean canceled = false;
    private ValueModel triggerChannel = new Trigger();
    private Mode escapeCancelsMode = AbstractDialog.getEscapeCancelsDefaultMode();
    private Action applyAction;
    private Action cancelAction;
    private Action closeAction;
    private Action okAction;
    private Action resetAction;
    protected static final Border DIALOG_BORDER = new EmptyBorder(12, 10, 10, 10);
    protected static final Border CARD_DIALOG_BORDER = new EmptyBorder(10, 6, 7, 6);

    public AbstractDialog(Frame frame) {
        this(frame, Application.getDescription().getWindowTitle());
    }

    public AbstractDialog(Frame frame, String string) {
        this(frame, string, true);
    }

    public AbstractDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.configureWindowClosing();
    }

    public AbstractDialog(Dialog dialog) {
        this(dialog, Application.getDescription().getWindowTitle());
    }

    public AbstractDialog(Dialog dialog, String string) {
        this(dialog, string, true);
    }

    public AbstractDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.configureWindowClosing();
    }

    public static Mode getEscapeCancelsDefaultMode() {
        return escapeCancelsDefaultMode;
    }

    public static void setEscapeCancelsDefaultMode(Mode mode) {
        escapeCancelsDefaultMode = mode;
    }

    public Mode getEscapeCancelsMode() {
        return this.escapeCancelsMode;
    }

    public void setEscapeCancelsMode(Mode mode) {
        Mode mode2 = this.getEscapeCancelsMode();
        if (mode2 == mode) {
            return;
        }
        this.escapeCancelsMode = mode;
        if (this.getRootPane() != null) {
            if (mode.enabled()) {
                this.registerCancelOnEscapeKey();
            } else {
                this.deregisterCancelOnEscapeKey();
            }
        }
        this.firePropertyChange("escapeCancelsMode", mode2, this.getEscapeCancelsMode());
    }

    private void registerCancelOnEscapeKey() {
        ComponentUtils.addAction(this.getRootPane(), this.getCancelAction(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void deregisterCancelOnEscapeKey() {
        ComponentUtils.addAction(this.getRootPane(), this.getCancelAction(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void setInitialComponent(Component component) {
        this.setFocusTraversalPolicy(new UIFFocusTraversalPolicy(component));
    }

    protected void build() {
        JComponent jComponent = this.buildContentPane();
        this.setBackground(jComponent.getBackground());
        this.resizeHook(jComponent);
        this.setContentPane(jComponent);
        this.pack();
        this.setResizable();
        this.locateOnScreen();
        if (this.getEscapeCancelsMode().enabled()) {
            this.registerCancelOnEscapeKey();
        }
    }

    protected JComponent buildContentPane() {
        JComponent jComponent = this.buildContent();
        jComponent.setBorder(this.getDialogBorder());
        JComponent jComponent2 = this.buildHeader();
        if (jComponent2 == null) {
            return jComponent;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jComponent2, "North");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    protected JComponent buildHeader() {
        return null;
    }

    protected abstract JComponent buildContent();

    public void open() {
        this.build();
        this.canceled = false;
        this.setVisible(true);
    }

    public void openSafe() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.open();
        } else {
            try {
                SwingUtilities.invokeAndWait(new OpenRunner(this));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.dispose();
    }

    public boolean hasBeenCanceled() {
        return this.canceled;
    }

    protected void configureWindowClosing() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowClosingHandler());
    }

    protected void resizeHook(JComponent jComponent) {
    }

    protected Border getDialogBorder() {
        return DIALOG_BORDER;
    }

    protected void setResizable() {
        this.setResizable(false);
    }

    protected void locateOnScreen() {
        this.setLocationRelativeTo(this.getParent());
    }

    public final BufferedValueModel buffer(ValueModel valueModel) {
        return new BufferedValueModel(valueModel, this.getTriggerChannel());
    }

    public final ValueModel getTriggerChannel() {
        return this.triggerChannel;
    }

    public final void setTriggerChannel(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The trigger channel must not be null");
        }
        ValueModel valueModel2 = this.getTriggerChannel();
        this.triggerChannel = valueModel;
        this.firePropertyChange(PROPERTYNAME_TRIGGER_CHANNEL, valueModel2, valueModel);
    }

    protected final void triggerCommit() {
        if (Boolean.TRUE.equals(this.getTriggerChannel().getValue())) {
            this.getTriggerChannel().setValue(null);
        }
        this.getTriggerChannel().setValue((Object)Boolean.TRUE);
    }

    protected final void triggerFlush() {
        if (Boolean.FALSE.equals(this.getTriggerChannel().getValue())) {
            this.getTriggerChannel().setValue(null);
        }
        this.getTriggerChannel().setValue((Object)Boolean.FALSE);
    }

    protected UIFButton createAcceptButton(String string, boolean bl) {
        UIFButton uIFButton = new UIFButton(new DispatchingAction(ACCEPT_ID, string));
        if (bl) {
            this.setDefaultButton(uIFButton);
        }
        return uIFButton;
    }

    protected UIFButton createApplyButton() {
        return new UIFButton(this.getApplyAction());
    }

    protected UIFButton createCancelButton() {
        UIFButton uIFButton = new UIFButton(this.getCancelAction());
        uIFButton.setVerifyInputWhenFocusTarget(false);
        return uIFButton;
    }

    protected UIFButton createCloseButton(boolean bl) {
        UIFButton uIFButton = new UIFButton(this.getCloseAction());
        if (bl) {
            this.setDefaultButton(uIFButton);
        }
        return uIFButton;
    }

    protected UIFButton createOKButton(boolean bl) {
        UIFButton uIFButton = new UIFButton(this.getOKAction());
        if (bl) {
            this.setDefaultButton(uIFButton);
        }
        return uIFButton;
    }

    protected UIFButton createResetButton() {
        return new UIFButton(this.getResetAction());
    }

    protected void setDefaultButton(JButton jButton) {
        this.getRootPane().setDefaultButton(jButton);
    }

    protected JComponent buildButtonBarWithClose() {
        JPanel jPanel = ButtonBarFactory.buildCloseBar((JButton)this.createCloseButton(true));
        jPanel.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        return jPanel;
    }

    protected JComponent buildButtonBarWithOKCancel() {
        JPanel jPanel = ButtonBarFactory.buildOKCancelBar((JButton)this.createOKButton(true), (JButton)this.createCancelButton());
        jPanel.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        return jPanel;
    }

    protected JComponent buildButtonBarWithOKCancelAnd(JButton jButton) {
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixed((JComponent)jButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGriddedButtons(new JButton[]{this.createOKButton(true), this.createCancelButton()});
        JPanel jPanel = buttonBarBuilder.getPanel();
        jPanel.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        return jPanel;
    }

    protected JComponent buildButtonBarWithOKCancelApply() {
        JPanel jPanel = ButtonBarFactory.buildOKCancelApplyBar((JButton)this.createOKButton(true), (JButton)this.createCancelButton(), (JButton)this.createApplyButton());
        jPanel.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        return jPanel;
    }

    protected JComponent buildButtonBarWithOKCancelApplyAnd(JButton jButton) {
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixed((JComponent)jButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGriddedButtons(new JButton[]{this.createOKButton(true), this.createCancelButton(), this.createApplyButton()});
        JPanel jPanel = buttonBarBuilder.getPanel();
        jPanel.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        return jPanel;
    }

    public void doAccept() {
        this.doApply();
        this.canceled = false;
        this.close();
    }

    public void doApply() {
        this.triggerCommit();
    }

    public void doCancel() {
        this.doReset();
        this.canceled = true;
        this.close();
    }

    public void doClose() {
        this.canceled = true;
        this.close();
    }

    protected void doCloseWindow() {
        this.doCancel();
    }

    public void doReset() {
        this.triggerFlush();
    }

    public Action getApplyAction() {
        if (this.applyAction == null) {
            this.applyAction = new DispatchingAction(APPLY_ID, this.getString("button.apply.text", APPLY_LABEL));
        }
        return this.applyAction;
    }

    public Action getCancelAction() {
        if (this.cancelAction == null) {
            this.cancelAction = new DispatchingAction(CANCEL_ID, this.getString("button.cancel.text", CANCEL_LABEL));
        }
        return this.cancelAction;
    }

    public Action getCloseAction() {
        if (this.closeAction == null) {
            this.closeAction = new DispatchingAction(CLOSE_ID, this.getString("button.close.text", CLOSE_LABEL));
        }
        return this.closeAction;
    }

    public Action getOKAction() {
        if (this.okAction == null) {
            this.okAction = new DispatchingAction(ACCEPT_ID, this.getString("button.ok.text", OK_LABEL));
        }
        return this.okAction;
    }

    public Action getResetAction() {
        if (this.resetAction == null) {
            this.resetAction = new DispatchingAction(RESET_ID, this.getString("button.reset.text", RESET_LABEL));
        }
        return this.resetAction;
    }

    protected String getString(String string, String string2) {
        return ResourceUtils.getString(string, string2);
    }

    private final class DispatchingAction
    extends AbstractAction {
        private final String id;

        private DispatchingAction(String string, String string2) {
            super(string2);
            this.id = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id.equals(AbstractDialog.ACCEPT_ID)) {
                AbstractDialog.this.doAccept();
            } else if (this.id.equals(AbstractDialog.APPLY_ID)) {
                AbstractDialog.this.doApply();
            } else if (this.id.equals(AbstractDialog.CANCEL_ID)) {
                AbstractDialog.this.doCancel();
            } else if (this.id.equals(AbstractDialog.CLOSE_ID)) {
                AbstractDialog.this.doClose();
            } else if (this.id.equals(AbstractDialog.RESET_ID)) {
                AbstractDialog.this.doReset();
            } else {
                throw new IllegalStateException("Unknown action name" + this.id);
            }
        }

        public String toString() {
            return super.toString() + ": " + this.id;
        }
    }

    private class WindowClosingHandler
    extends WindowAdapter {
        private WindowClosingHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            AbstractDialog.this.doCloseWindow();
        }
    }

    private static class OpenRunner
    implements Runnable {
        final AbstractDialog dialog;

        public OpenRunner(AbstractDialog abstractDialog) {
            this.dialog = abstractDialog;
        }

        public void run() {
            this.dialog.open();
        }
    }
}

