/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif;

import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.application.ApplicationAdapter;
import com.jgoodies.uif.application.ApplicationEvent;
import com.jgoodies.uif.util.Resizer;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uif.util.ScreenUtils;
import com.jgoodies.uif.util.WindowUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;

public abstract class AbstractFrame
extends JFrame {
    private String titleSuffix;

    protected AbstractFrame(String string) {
        super(string);
        this.setTitleSuffix(string);
    }

    public void build() {
        JComponent jComponent = this.buildContentPane();
        this.setBackground(jComponent.getBackground());
        this.resizeHook(jComponent);
        this.setContentPane(jComponent);
        this.pack();
        this.locateOnScreen();
        this.configureWindowIcon();
        this.restoreState();
        this.initEventHandling();
        this.configureCloseOperation();
    }

    protected abstract JComponent buildContentPane();

    protected abstract void configureCloseOperation();

    public abstract String getWindowID();

    public Dimension getWindowMinimumSize() {
        return null;
    }

    public void setTitlePrefix(String string) {
        String string2 = string.trim();
        if (string2.length() > 40) {
            string2 = string2.substring(0, 37) + "...";
        }
        String string3 = string2.length() == 0 ? "" : " - ";
        this.setTitle(string2 + string3 + this.titleSuffix);
    }

    public void setTitleSuffix(String string) {
        this.titleSuffix = string;
    }

    public void open() {
        this.setVisible(true);
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.DEFAULT.resizeDialogContent(jComponent);
    }

    protected void locateOnScreen() {
        ScreenUtils.locateOnScreenCenter(this);
    }

    protected void initEventHandling() {
        this.addComponentListener(new WindowUtils.SizeChangeHandler(this));
        Application.addApplicationListener(new ApplicationClosingHandler());
    }

    protected void configureWindowIcon() {
        Image image = this.readImage("application.icon.12x12");
        Image image2 = this.readImage("application.icon.16x16");
        if (image2 == null) {
            image2 = this.readImage("application.icon");
        }
        WindowUtils.setImageIcon(this, image, image2);
    }

    private Image readImage(String string) {
        String string2 = ResourceUtils.getString(string, null);
        if (string2 == null) {
            return null;
        }
        ClassLoader classLoader = ResourceUtils.getDefaultClassLoader();
        URL uRL = classLoader.getResource(string2);
        if (uRL == null) {
            return null;
        }
        try {
            return ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void storeState() {
        Preferences preferences = Application.getUserPreferences();
        WindowUtils.storeBounds(preferences, this);
        WindowUtils.storeState(preferences, this);
    }

    protected void restoreState() {
        Preferences preferences = Application.getUserPreferences();
        WindowUtils.restoreBounds(this, preferences);
        WindowUtils.restoreState(this, preferences, false);
    }

    protected boolean hasStoredState() {
        return WindowUtils.getStoredBounds(this, Application.getUserPreferences()) != null;
    }

    private class ApplicationClosingHandler
    extends ApplicationAdapter {
        private ApplicationClosingHandler() {
        }

        public void applicationClosing(ApplicationEvent applicationEvent) {
            AbstractFrame.this.storeState();
        }
    }
}

