/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.action;

import com.jgoodies.uif.action.ActionReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;

public final class ActionManager {
    public static final String SMALL_GRAY_ICON = "smallGrayIcon";
    public static final String DISPLAYED_MNEMONIC_INDEX = "mnemonicIndex";
    private static final ActionManager INSTANCE = new ActionManager();
    private static final Logger LOGGER = Logger.getLogger("ActionManager");
    public static final InitializationType EAGER = new InitializationType("EAGER");
    public static final InitializationType LAZY = new InitializationType("LAZY");
    private final Map actions = new HashMap(50);
    private ResourceBundle bundle;
    static /* synthetic */ Class class$com$jgoodies$uif$action$ActionManager;

    private ActionManager() {
    }

    public static void setBundlePath(String string) {
        ActionManager.setBundle(ResourceBundle.getBundle(string, Locale.getDefault(), (class$com$jgoodies$uif$action$ActionManager == null ? (class$com$jgoodies$uif$action$ActionManager = ActionManager.class$("com.jgoodies.uif.action.ActionManager")) : class$com$jgoodies$uif$action$ActionManager).getClassLoader()));
    }

    public static void setBundle(ResourceBundle resourceBundle) {
        ActionManager.INSTANCE.bundle = resourceBundle;
    }

    public static Action register(String string, Action action) {
        return ActionManager.register(string, action, LAZY);
    }

    public static Action register(String string, Action action, InitializationType initializationType) {
        return ActionManager.register(string, action, string, initializationType);
    }

    public static Action register(String string, Action action, String string2) {
        return ActionManager.register(string, action, string2, LAZY);
    }

    public static Action register(String string, Action action, String string2, InitializationType initializationType) {
        return ActionManager.register(string, action, ActionManager.INSTANCE.bundle, string2, initializationType);
    }

    public static Action register(String string, Action action, ResourceBundle resourceBundle) {
        return ActionManager.register(string, action, resourceBundle, LAZY);
    }

    public static Action register(String string, Action action, ResourceBundle resourceBundle, InitializationType initializationType) {
        return ActionManager.register(string, action, resourceBundle, string, initializationType);
    }

    public static Action register(String string, Action action, ResourceBundle resourceBundle, String string2) {
        return ActionManager.register(string, action, resourceBundle, string2, LAZY);
    }

    public static Action register(String string, Action action, ResourceBundle resourceBundle, String string2, InitializationType initializationType) {
        if (action == null) {
            throw new NullPointerException("Registered actions must not be null.");
        }
        LazyActionReader lazyActionReader = new LazyActionReader(resourceBundle, string2, action);
        LazyActionReader lazyActionReader2 = ActionManager.INSTANCE.actions.put(string, lazyActionReader);
        if (lazyActionReader2 != null) {
            LOGGER.warning("Duplicate action id: " + string);
        }
        if (initializationType == EAGER) {
            lazyActionReader.getAction();
        }
        return action;
    }

    public static Action get(String string) {
        LazyActionReader lazyActionReader = (LazyActionReader)ActionManager.INSTANCE.actions.get(string);
        if (null == lazyActionReader) {
            LOGGER.severe("No action found for id: " + string);
            return null;
        }
        return lazyActionReader.getAction();
    }

    public static List getAll(String[] stringArray) {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        for (int i = 0; i < stringArray.length; ++i) {
            Action action = ActionManager.get(stringArray[i]);
            if (action == null) continue;
            linkedList.add(action);
        }
        return linkedList;
    }

    public static Icon getIcon(String string) {
        Action action = ActionManager.get(string);
        if (action == null) {
            return null;
        }
        return (Icon)action.getValue("SmallIcon");
    }

    public static void ensureAllActionsRead() {
        Iterator iterator = new LinkedList(ActionManager.INSTANCE.actions.values()).iterator();
        while (iterator.hasNext()) {
            ((LazyActionReader)iterator.next()).ensureRead();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class LazyActionReader {
        private final ResourceBundle resourceBundle;
        private final String prefix;
        private final Action action;
        private boolean read = false;

        private LazyActionReader(ResourceBundle resourceBundle, String string, Action action) {
            this.resourceBundle = resourceBundle;
            this.prefix = string;
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureRead() {
            if (this.read) {
                return;
            }
            LazyActionReader lazyActionReader = this;
            synchronized (lazyActionReader) {
                ActionReader.readAndPutValues(this.action, this.resourceBundle, this.prefix);
                this.read = true;
            }
        }

        private Action getAction() {
            this.ensureRead();
            return this.action;
        }
    }

    public static final class InitializationType {
        private final String name;

        private InitializationType(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

