/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.action;

import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uif.util.SystemUtils;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public final class ActionReader {
    private static final String LABEL = "label";
    private static final char MNEMONIC_MARKER = '&';
    private static final char ELLIPSIS = '\u2026';
    private static final String ELLIPSIS_STRING = "...";
    private static final String SHORT_DESCRIPTION = "tooltip";
    private static final String LONG_DESCRIPTION = "helptext";
    private static final String ICON = "icon";
    private static final String GRAY_ICON = "icon.gray";
    private static final String ACCELERATOR = "accelerator";
    private static final String SUFFIX_OS_MAC = ".mac";

    private ActionReader() {
    }

    public static void readAndPutValues(Action action, ResourceBundle resourceBundle, String string) {
        String string2 = ActionReader.getString(resourceBundle, string + "." + LABEL, string);
        int n = string2.indexOf(38);
        String string3 = ActionReader.stripName(string2, n);
        Integer n2 = ActionReader.stripMnemonic(string2, n);
        Integer n3 = new Integer(n);
        String string4 = ActionReader.stripEllipsis(string3);
        String string5 = ActionReader.getString(resourceBundle, string + '.' + SHORT_DESCRIPTION, string4);
        String string6 = string3;
        String string7 = ActionReader.getString(resourceBundle, string + '.' + LONG_DESCRIPTION, string6);
        String string8 = ActionReader.getString(resourceBundle, string + '.' + ICON, null);
        ImageIcon imageIcon = null == string8 ? null : ActionReader.getImageIcon(string8);
        String string9 = ActionReader.getString(resourceBundle, string + '.' + GRAY_ICON, null);
        ImageIcon imageIcon2 = null == string9 ? null : ActionReader.getImageIcon(string9);
        String string10 = ActionReader.getString(resourceBundle, string + '.' + ACCELERATOR, null);
        KeyStroke keyStroke = ActionReader.getKeyStroke(string, string10);
        action.putValue("Name", string3);
        action.putValue("ShortDescription", string5);
        action.putValue("LongDescription", string7);
        action.putValue("SmallIcon", imageIcon);
        action.putValue("smallGrayIcon", imageIcon2);
        action.putValue("AcceleratorKey", keyStroke);
        action.putValue("mnemonicIndex", n3);
        if (n2 != null) {
            action.putValue("MnemonicKey", n2);
        }
    }

    private static String stripName(String string, int n) {
        return n == -1 ? string : string.substring(0, n) + string.substring(n + 1);
    }

    private static Integer stripMnemonic(String string, int n) {
        return n == -1 ? null : new Integer(string.toUpperCase().charAt(n + 1));
    }

    private static String stripEllipsis(String string) {
        int n = string.length();
        if (string.charAt(n - 1) == '\u2026') {
            return string.substring(0, n - 1);
        }
        if (string.endsWith(ELLIPSIS_STRING)) {
            return string.substring(0, n - ELLIPSIS_STRING.length());
        }
        return string;
    }

    private static ImageIcon getImageIcon(String string) {
        return ResourceUtils.readImageIcon(string);
    }

    private static KeyStroke getKeyStroke(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
        if (keyStroke == null) {
            Logger.getLogger("ActionReader").warning("Action " + string + " has an invalid accelerator " + string2);
        }
        return keyStroke;
    }

    public static String getString(ResourceBundle resourceBundle, String string, String string2) {
        String string3 = string + SUFFIX_OS_MAC;
        String string4 = SystemUtils.IS_OS_MAC ? string3 : string;
        try {
            return resourceBundle.getString(string4);
        }
        catch (MissingResourceException missingResourceException) {
            if (!SystemUtils.IS_OS_MAC) {
                return string2;
            }
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                return string2;
            }
        }
    }
}

