/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.application;

import com.jgoodies.uif.action.ActionManager;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.application.ApplicationConfiguration;
import com.jgoodies.uif.application.ApplicationDescription;
import com.jgoodies.uif.osx.OSXApplicationMenu;
import com.jgoodies.uif.splash.Splash;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uif.util.SystemUtils;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractApplicationStarter {
    private Logger logger;
    private ApplicationDescription description;
    private ApplicationConfiguration configuration;

    protected final Logger getLogger() {
        return this.logger;
    }

    protected final ApplicationDescription getApplicationDescription() {
        return this.description;
    }

    protected final ApplicationConfiguration getApplicationConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(ApplicationDescription applicationDescription, ApplicationConfiguration applicationConfiguration) {
        try {
            Splash.resetStartTime();
            this.description = applicationDescription;
            this.configuration = applicationConfiguration;
            this.logger = Logger.getLogger("com.jgoodies.ApplicationStarter");
            this.load();
        }
        catch (Throwable throwable) {
            this.logger.log(Level.SEVERE, "Load failed", throwable);
            this.exit();
        }
        finally {
            Splash.ensureClosed();
        }
    }

    protected void exit() {
        Splash.ensureClosed();
        if (SystemUtils.systemExitAllowed()) {
            System.exit(0);
        }
    }

    protected void load() {
        OSXApplicationMenu.setAboutName(this.description.getShortName());
        this.addApplicationProperties();
        this.configureLogging();
        Application.setConfiguration(this.configuration);
        Application.setDescription(this.description);
        ResourceUtils.setBundlePath(this.configuration.getResourcesBundlePath());
        this.configureSplash();
        Splash.open();
        ActionManager.setBundlePath(this.configuration.getActionsBundlePath());
        this.configureHelp();
        Splash.setNote("Configuring UI");
        this.configureUI();
        this.launchApplication();
    }

    protected abstract void configureLogging();

    protected abstract void configureSplash();

    protected abstract void configureHelp();

    protected abstract void configureUI();

    protected abstract void launchApplication();

    private void addApplicationProperties() {
        System.setProperty("application.name", this.description.getName());
        System.setProperty("application.vendor", this.description.getVendor());
        System.setProperty("application.vendor.url", this.description.getVendorURL());
        System.setProperty("application.vendor.mail", this.description.getVendorMail());
        System.setProperty("application.fullversion", this.description.getFullVersion());
    }

    protected final void ensureParentDirectoryExists(String string) {
        File file = this.generate(string);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    private File generate(String string) {
        File file = null;
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            char c2 = '\u0000';
            if (++n < string.length()) {
                c2 = Character.toLowerCase(string.charAt(n));
            }
            if (c == '/') {
                file = file == null ? new File(string2) : new File(file, string2);
                string2 = "";
                continue;
            }
            if (c == '%') {
                if (c2 == 't') {
                    String string3 = System.getProperty("java.io.tmpdir");
                    if (string3 == null) {
                        string3 = System.getProperty("user.home");
                    }
                    file = new File(string3);
                    ++n;
                    string2 = "";
                    continue;
                }
                if (c2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    ++n;
                    string2 = "";
                    continue;
                }
                if (c2 == 'g') {
                    ++n;
                    continue;
                }
                if (c2 == 'u') {
                    ++n;
                    continue;
                }
                if (c2 == '%') {
                    string2 = string2 + "%";
                    ++n;
                    continue;
                }
            }
            string2 = string2 + c;
        }
        if (string2.length() > 0) {
            file = file == null ? new File(string2) : new File(file, string2);
        }
        return file;
    }
}

