/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.application;

import com.jgoodies.uif.application.ApplicationConfiguration;
import com.jgoodies.uif.application.ApplicationDescription;
import com.jgoodies.uif.application.ApplicationEvent;
import com.jgoodies.uif.application.ApplicationListener;
import com.jgoodies.uif.util.SystemUtils;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public final class Application {
    private static ApplicationConfiguration configuration;
    private static ApplicationDescription description;
    private static JFrame defaultParentFrame;
    private static List listenerList;
    private static WindowListener applicationCloseOnWindowClosingHandler;

    private Application() {
    }

    public static ApplicationConfiguration getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(ApplicationConfiguration applicationConfiguration) {
        configuration = applicationConfiguration;
    }

    public static ApplicationDescription getDescription() {
        return description;
    }

    public static void setDescription(ApplicationDescription applicationDescription) {
        description = applicationDescription;
    }

    public static JFrame getDefaultParentFrame() {
        return defaultParentFrame;
    }

    public static void setDefaultParentFrame(JFrame jFrame) {
        defaultParentFrame = jFrame;
    }

    public static Preferences getUserPreferences() {
        return Preferences.userRoot().node(Application.getConfiguration().getPreferencesRootName());
    }

    public static void close() {
        Application.fireApplicationClosing();
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            Frame frame = frameArray[i];
            if (frame instanceof JFrame) {
                JFrame jFrame = (JFrame)frame;
                Window[] windowArray = jFrame.getOwnedWindows();
                for (int j = 0; j < windowArray.length; ++j) {
                    windowArray[j].dispose();
                }
            }
            frame.dispose();
        }
        Application.fireApplicationClosed();
        if (SystemUtils.systemExitAllowed()) {
            System.exit(0);
        }
    }

    public static void addApplicationListener(ApplicationListener applicationListener) {
        if (applicationListener == null) {
            throw new NullPointerException("The application listener must not be null.");
        }
        listenerList.add(applicationListener);
    }

    public static void removeApplicationListener(ApplicationListener applicationListener) {
        if (applicationListener == null) {
            throw new NullPointerException("The application listener must not be null.");
        }
        listenerList.remove(applicationListener);
    }

    public static void fireApplicationStarting() {
        ApplicationEvent applicationEvent = new ApplicationEvent(ApplicationEvent.APPLICATION_STARTING);
        Iterator iterator = listenerList.iterator();
        while (iterator.hasNext()) {
            ApplicationListener applicationListener = (ApplicationListener)iterator.next();
            applicationListener.applicationStarting(applicationEvent);
        }
    }

    public static void fireApplicationStarted() {
        ApplicationEvent applicationEvent = new ApplicationEvent(ApplicationEvent.APPLICATION_STARTED);
        Iterator iterator = listenerList.iterator();
        while (iterator.hasNext()) {
            ApplicationListener applicationListener = (ApplicationListener)iterator.next();
            applicationListener.applicationStarted(applicationEvent);
        }
    }

    public static void fireApplicationClosing() {
        ApplicationEvent applicationEvent = new ApplicationEvent(ApplicationEvent.APPLICATION_CLOSING);
        Iterator iterator = listenerList.iterator();
        while (iterator.hasNext()) {
            ApplicationListener applicationListener = (ApplicationListener)iterator.next();
            applicationListener.applicationClosing(applicationEvent);
        }
    }

    public static void fireApplicationClosed() {
        ApplicationEvent applicationEvent = new ApplicationEvent(ApplicationEvent.APPLICATION_CLOSED);
        Iterator iterator = listenerList.iterator();
        while (iterator.hasNext()) {
            ApplicationListener applicationListener = (ApplicationListener)iterator.next();
            applicationListener.applicationClosed(applicationEvent);
        }
    }

    public static WindowListener getApplicationCloseOnWindowClosingHandler() {
        if (applicationCloseOnWindowClosingHandler == null) {
            applicationCloseOnWindowClosingHandler = new ApplicationCloseOnWindowClosingHandler();
        }
        return applicationCloseOnWindowClosingHandler;
    }

    static {
        listenerList = new LinkedList();
    }

    private static class ApplicationCloseOnWindowClosingHandler
    extends WindowAdapter {
        private ApplicationCloseOnWindowClosingHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Application.close();
        }
    }
}

