/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.builder;

import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.component.UIFCheckBoxMenuItem;
import com.jgoodies.uif.component.UIFMenuItem;
import com.jgoodies.uif.component.UIFRadioButtonMenuItem;
import com.jgoodies.uif.util.Mode;
import com.jgoodies.uif.util.Modes;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public final class MenuBuilder {
    private static Mode iconVisibleDefaultMode = Modes.LAF_NON_AQUA;
    private Mode iconVisibleMode;
    private final JMenu menu;

    public MenuBuilder(String string, char c) {
        this(new JMenu(string));
        this.getMenu().setMnemonic(c);
    }

    public MenuBuilder(JMenu jMenu) {
        this.menu = jMenu;
        this.setIconVisibleMode(MenuBuilder.getIconVisibleDefaultMode());
    }

    public static Mode getIconVisibleDefaultMode() {
        return iconVisibleDefaultMode;
    }

    public static void setIconVisibleDefaultMode(Mode mode) {
        iconVisibleDefaultMode = mode;
    }

    public Mode getIconVisibleMode() {
        return this.iconVisibleMode;
    }

    public void setIconVisibleMode(Mode mode) {
        this.iconVisibleMode = mode;
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public UIFMenuItem add(String string) {
        return this.add(new UIFMenuItem(string));
    }

    public UIFMenuItem add(String string, Icon icon) {
        return this.add(new UIFMenuItem(string, icon));
    }

    public UIFMenuItem add(String string, int n) {
        return this.add(new UIFMenuItem(string, n));
    }

    public UIFMenuItem add(String string, Icon icon, int n) {
        return this.add(new UIFMenuItem(string, icon, n));
    }

    public JMenuItem add(Action action) {
        if (action instanceof ToggleAction) {
            throw new IllegalArgumentException("Use #addToggle for ToggleActions.");
        }
        return this.add(new UIFMenuItem(action));
    }

    public JMenuItem addToggle(ToggleAction toggleAction) {
        if (toggleAction.isRadioAction()) {
            return this.add(new UIFRadioButtonMenuItem(toggleAction));
        }
        return this.add(new UIFCheckBoxMenuItem(toggleAction));
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        return this.getMenu().add(jMenuItem);
    }

    public UIFMenuItem add(UIFMenuItem uIFMenuItem) {
        uIFMenuItem.setIconVisibleMode(this.getIconVisibleMode());
        return (UIFMenuItem)this.add((JMenuItem)uIFMenuItem);
    }

    public UIFRadioButtonMenuItem add(UIFRadioButtonMenuItem uIFRadioButtonMenuItem) {
        uIFRadioButtonMenuItem.setIconVisibleMode(this.getIconVisibleMode());
        return (UIFRadioButtonMenuItem)this.add((JMenuItem)uIFRadioButtonMenuItem);
    }

    public UIFCheckBoxMenuItem add(UIFCheckBoxMenuItem uIFCheckBoxMenuItem) {
        uIFCheckBoxMenuItem.setIconVisibleMode(this.getIconVisibleMode());
        return (UIFCheckBoxMenuItem)this.add((JMenuItem)uIFCheckBoxMenuItem);
    }

    public void addSeparator() {
        this.getMenu().addSeparator();
    }
}

