/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.builder;

import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.component.PopupButton;
import com.jgoodies.uif.component.ToolBarButton;
import com.jgoodies.uif.component.ToolBarToggleButton;
import com.jgoodies.uif.util.Mode;
import com.jgoodies.uif.util.Modes;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ToolBarBuilder {
    private static Mode borderPaintedDefaultMode = Modes.LAF_NON_AQUA;
    private static Mode wideMarginDefaultMode = Modes.LAF_AQUA;
    private Mode borderPaintedMode = ToolBarBuilder.getBorderPaintedDefaultMode();
    private Mode wideMarginMode = ToolBarBuilder.getWideMarginDefaultMode();
    private final JToolBar toolBar;

    public ToolBarBuilder() {
        this("", null);
    }

    public ToolBarBuilder(String string) {
        this(string, null);
    }

    public ToolBarBuilder(String string, Object object) {
        this.toolBar = new JToolBar(string);
        this.configureToolBar();
        this.setHeaderStyle(object);
    }

    public ToolBarBuilder(JToolBar jToolBar) {
        this.toolBar = jToolBar;
    }

    public static Mode getBorderPaintedDefaultMode() {
        return borderPaintedDefaultMode;
    }

    public static void setBorderPaintedDefaultMode(Mode mode) {
        borderPaintedDefaultMode = mode;
    }

    public static Mode getWideMarginDefaultMode() {
        return wideMarginDefaultMode;
    }

    public static void setWideMarginDefaultMode(Mode mode) {
        wideMarginDefaultMode = mode;
    }

    public final Mode getBorderPaintedMode() {
        return this.borderPaintedMode;
    }

    public final void setBorderPaintedMode(Mode mode) {
        this.borderPaintedMode = mode;
    }

    public final Mode getWideMarginMode() {
        return this.wideMarginMode;
    }

    public final void setWideMarginMode(Mode mode) {
        this.wideMarginMode = mode;
    }

    public final JToolBar getToolBar() {
        return this.toolBar;
    }

    protected void configureToolBar() {
        this.getToolBar().setRollover(true);
        this.getToolBar().setFloatable(false);
    }

    public final void setBorderStyle(Object object) {
        this.getToolBar().putClientProperty("Plastic.borderStyle", object);
        this.getToolBar().putClientProperty("jgoodies.windows.borderStyle", object);
    }

    public final void setHeaderStyle(Object object) {
        this.getToolBar().putClientProperty("jgoodies.headerStyle", object);
    }

    public void addGap() {
        this.addGap(6);
    }

    public void addLargeGap() {
        this.addGap(12);
    }

    public void addGap(int n) {
        this.add(Box.createRigidArea(new Dimension(n, n)));
    }

    public void addGlue() {
        this.add(Box.createGlue());
    }

    public void addSeparator() {
        this.getToolBar().addSeparator();
    }

    public void add(PopupButton popupButton) {
        popupButton.addTo(this.getToolBar());
    }

    public Component add(Component component) {
        return this.getToolBar().add(component);
    }

    public JButton add(Action action) {
        if (action instanceof ToggleAction) {
            throw new IllegalArgumentException("Use #addToggle for ToggleActions.");
        }
        ToolBarButton toolBarButton = new ToolBarButton(action);
        toolBarButton.setBorderPaintedMode(this.getBorderPaintedMode());
        toolBarButton.setWideMarginMode(this.getWideMarginMode());
        this.add(toolBarButton);
        return toolBarButton;
    }

    public JToggleButton addToggle(ToggleAction toggleAction) {
        ToolBarToggleButton toolBarToggleButton = new ToolBarToggleButton(toggleAction);
        toolBarToggleButton.setModel(toggleAction.getButtonModel());
        toolBarToggleButton.setBorderPaintedMode(this.getBorderPaintedMode());
        toolBarToggleButton.setWideMarginMode(this.getWideMarginMode());
        this.add(toolBarToggleButton);
        return toolBarToggleButton;
    }
}

