/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.component;

import com.jgoodies.uif.component.ToolBarButton;
import com.jgoodies.uif.util.ComponentTreeUtils;
import com.jgoodies.uif.util.CompoundIcon;
import com.jgoodies.uif.util.NullIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class PopupButton
extends JPanel {
    private final JButton mainButton;
    private final JPopupMenu popupMenu;
    private AbstractButton arrowButton;
    private boolean mouseIsOver = false;

    public PopupButton(JButton jButton, JPopupMenu jPopupMenu) {
        super(null);
        this.mainButton = jButton;
        this.popupMenu = jPopupMenu;
        this.build();
    }

    public void addTo(JToolBar jToolBar) {
        jToolBar.add(this.mainButton);
        jToolBar.add(this.arrowButton);
        this.adjustButtonHeights();
    }

    protected void build() {
        this.arrowButton = this.createArrowButton();
        this.mainButton.getModel().addChangeListener(new MainButtonChangeListener());
        this.mainButton.addMouseListener(new MainButtonMouseListener());
        this.popupMenu.addPopupMenuListener(new RolloverPopupMenuListener());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.mainButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.arrowButton, gridBagConstraints);
        this.setOpaque(false);
    }

    private AbstractButton createArrowButton() {
        Icon icon = this.mainButton.getIcon();
        int n = icon != null ? icon.getIconHeight() : 16;
        ArrowIcon arrowIcon = new ArrowIcon();
        CompoundIcon compoundIcon = new CompoundIcon(new NullIcon(new Dimension(arrowIcon.getIconWidth(), n)), arrowIcon, 0);
        ToolBarButton toolBarButton = new ToolBarButton(compoundIcon);
        toolBarButton.setModel(new DelegatingButtonModel(this.mainButton.getModel()));
        toolBarButton.addActionListener(new ArrowButtonActionListener());
        toolBarButton.addMouseListener(new ArrowButtonMouseListener());
        Insets insets = toolBarButton.getMargin();
        toolBarButton.setMargin(new Insets(insets.top, 0, insets.bottom, 0));
        return toolBarButton;
    }

    public float getAlignmentX() {
        return this.mainButton.getAlignmentX();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void updateUI() {
        super.updateUI();
        if (null == this.popupMenu) {
            return;
        }
        ComponentTreeUtils.updateComponentTreeUI(this.popupMenu);
        this.adjustButtonHeights();
    }

    private void adjustButtonHeights() {
        Dimension dimension = this.mainButton.getMinimumSize();
        dimension.width = this.arrowButton.getMinimumSize().width;
        this.arrowButton.setMaximumSize(dimension);
    }

    private static final class DelegatingButtonModel
    extends DefaultButtonModel {
        private final ButtonModel delegate;

        private DelegatingButtonModel(ButtonModel buttonModel) {
            this.delegate = buttonModel;
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public boolean isRollover() {
            return this.delegate.isRollover();
        }

        public boolean isArmed() {
            return super.isArmed() || this.delegate.isArmed();
        }

        public boolean isPressed() {
            return super.isPressed() || this.delegate.isPressed();
        }

        public void setRollover(boolean bl) {
            this.delegate.setRollover(bl);
        }

        public void setEnabled(boolean bl) {
            if (this.delegate != null) {
                this.delegate.setEnabled(bl);
            }
        }
    }

    private static class ArrowIcon
    implements Icon {
        private static final int ICON_HEIGHT = 4;
        private static final int ICON_WIDTH = 9;

        private ArrowIcon() {
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 4;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            int n3 = this.getIconWidth() - 2;
            int n4 = 4;
            graphics.translate(n, n2);
            graphics.setColor(UIManager.getColor(buttonModel.isEnabled() ? "controlText" : "textInactiveText"));
            for (int i = 0; i < n4; ++i) {
                graphics.drawLine(i + 1, i, n3 - i, i);
            }
            graphics.translate(-n, -n2);
        }
    }

    private class RolloverPopupMenuListener
    implements PopupMenuListener {
        private RolloverPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            PopupButton.this.arrowButton.getModel().setRollover(PopupButton.this.mouseIsOver);
            PopupButton.this.arrowButton.getModel().setPressed(false);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            PopupButton.this.arrowButton.getModel().setRollover(true);
            PopupButton.this.arrowButton.getModel().setPressed(true);
        }
    }

    private class MainButtonMouseListener
    extends MouseAdapter {
        private MainButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            PopupButton.this.mouseIsOver = true;
            PopupButton.this.arrowButton.getModel().setRollover(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PopupButton.this.mouseIsOver = false;
            PopupButton.this.arrowButton.getModel().setRollover(PopupButton.this.popupMenu.isVisible());
        }
    }

    private class MainButtonChangeListener
    implements ChangeListener {
        private MainButtonChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            PopupButton.this.arrowButton.repaint();
        }
    }

    private class ArrowButtonMouseListener
    extends MouseAdapter {
        private ArrowButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            PopupButton.this.mouseIsOver = true;
            PopupButton.this.mainButton.getModel().setRollover(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PopupButton.this.mouseIsOver = false;
            PopupButton.this.mainButton.getModel().setRollover(PopupButton.this.popupMenu.isVisible());
        }
    }

    private class ArrowButtonActionListener
    implements ActionListener {
        private ArrowButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PopupButton.this.popupMenu.show(PopupButton.this.mainButton, 0, PopupButton.this.mainButton.getHeight());
            PopupButton.this.arrowButton.getModel().setArmed(true);
        }
    }
}

