/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.component;

import com.jgoodies.uif.util.Mode;
import com.jgoodies.uif.util.Modes;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class ToolBarButton
extends JButton {
    private static final Insets EMPTY_INSETS = new InsetsUIResource(0, 0, 0, 0);
    private Mode borderPaintedMode = Modes.LAF_NON_AQUA;
    private Mode wideMarginMode = Modes.LAF_AQUA;

    public ToolBarButton() {
        this((Icon)null);
    }

    public ToolBarButton(Icon icon) {
        super(icon);
        this.configureButton();
    }

    public ToolBarButton(Action action) {
        super(action);
        this.configureButton();
    }

    public Mode getBorderPaintedMode() {
        return this.borderPaintedMode;
    }

    public void setBorderPaintedMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException("The border painted mode must not be null.");
        }
        this.borderPaintedMode = mode;
        this.configureButton();
    }

    public Mode getWideMarginMode() {
        return this.wideMarginMode;
    }

    public void setWideMarginMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException("The wide margin mode must not be null.");
        }
        this.wideMarginMode = mode;
        this.configureButton();
    }

    public void updateUI() {
        super.updateUI();
        if (this.getBorderPaintedMode() != null) {
            this.configureButton();
        }
    }

    public static void configureButton(AbstractButton abstractButton, boolean bl, boolean bl2) {
        abstractButton.setHorizontalTextPosition(0);
        abstractButton.setVerticalTextPosition(3);
        abstractButton.setAlignmentY(0.5f);
        abstractButton.setBorderPainted(bl);
        if (abstractButton.getMargin() instanceof UIResource) {
            abstractButton.setMargin(ToolBarButton.getButtonMargin(abstractButton, bl2));
        }
        abstractButton.setMnemonic(0);
        abstractButton.setFocusable(false);
    }

    private static Insets getButtonMargin(AbstractButton abstractButton, boolean bl) {
        Dimension dimension = UIManager.getDimension("jgoodies.defaultIconSize");
        Icon icon = abstractButton.getIcon();
        if (dimension == null || icon == null) {
            return EMPTY_INSETS;
        }
        int n = Math.max(0, dimension.width - icon.getIconWidth());
        int n2 = Math.max(0, dimension.height - icon.getIconHeight());
        int n3 = n2 / 2;
        int n4 = n / 2;
        int n5 = n3 + n2 % 2;
        int n6 = n4 + n % 2;
        if (bl) {
            n3 += 2;
            n4 += 2;
            n5 += 2;
            n6 += 2;
        }
        return new InsetsUIResource(n3, n4, n5, n6);
    }

    private void configureButton() {
        ToolBarButton.configureButton(this, this.getBorderPaintedMode().enabled(), this.getWideMarginMode().enabled());
        this.setDefaultCapable(false);
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        Icon icon = this.getIcon();
        Icon icon2 = (Icon)action.getValue("smallGrayIcon");
        if (icon2 != null) {
            this.setRolloverIcon(icon);
            this.setIcon(icon2);
        }
        if (icon != null) {
            this.putClientProperty("hideActionText", Boolean.TRUE);
        }
    }

    public void setText(String string) {
    }
}

