/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.component;

import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.component.ToolBarButton;
import com.jgoodies.uif.util.Mode;
import com.jgoodies.uif.util.Modes;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public final class ToolBarToggleButton
extends JToggleButton {
    private Mode borderPaintedMode = Modes.LAF_NON_AQUA;
    private Mode wideMarginMode = Modes.LAF_AQUA;

    public ToolBarToggleButton() {
        this.configureButton();
    }

    public ToolBarToggleButton(Icon icon) {
        super(icon);
        this.configureButton();
    }

    public ToolBarToggleButton(ToggleAction toggleAction) {
        super(toggleAction);
        this.configureButton();
    }

    public Mode getBorderPaintedMode() {
        return this.borderPaintedMode;
    }

    public void setBorderPaintedMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException("The border painted mode must not be null.");
        }
        this.borderPaintedMode = mode;
        this.configureButton();
    }

    public Mode getWideMarginMode() {
        return this.wideMarginMode;
    }

    public void setWideMarginMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException("The wide margin mode must not be null.");
        }
        this.wideMarginMode = mode;
        this.configureButton();
    }

    public void updateUI() {
        super.updateUI();
        if (this.getBorderPaintedMode() != null) {
            this.configureButton();
        }
    }

    private void configureButton() {
        ToolBarButton.configureButton(this, this.getBorderPaintedMode().enabled(), this.getWideMarginMode().enabled());
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        Icon icon = this.getIcon();
        Icon icon2 = (Icon)action.getValue("smallGrayIcon");
        if (icon2 != null) {
            this.setSelectedIcon(icon);
            this.setRolloverIcon(icon);
            this.setIcon(icon2);
        }
        if (icon != null) {
            this.setText(null);
        }
        if (action instanceof ToggleAction) {
            this.setModel(((ToggleAction)action).getButtonModel());
        }
    }
}

