/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.component;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.plaf.FontUIResource;

public class UIFLabel
extends JLabel {
    public static final String PROPERTYNAME_FONT_STYLE = "fontStyle";
    public static final String PROPERTYNAME_FONT_SIZE_DELTA = "fontSizeDelta";
    public static final String PROPERTYNAME_ANTI_ALIASED = "antiAliased";
    private int fontStyle;
    private int fontSizeDelta;
    private boolean antiAliased;

    public UIFLabel(String string, boolean bl) {
        this(string, 0, 0, bl);
    }

    public UIFLabel(String string, int n, int n2, boolean bl) {
        super(string);
        this.fontStyle = n;
        this.fontSizeDelta = n2;
        this.antiAliased = bl;
        this.updateUI();
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int n) {
        int n2 = this.getFontStyle();
        this.fontStyle = n;
        this.updateUI();
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROPERTYNAME_FONT_STYLE, n2, n);
    }

    public int getFontSizeDelta() {
        return this.fontSizeDelta;
    }

    public void setFontSizeDelta(int n) {
        int n2 = this.getFontSizeDelta();
        this.fontSizeDelta = n;
        this.updateUI();
        this.repaint();
        this.revalidate();
        this.firePropertyChange(PROPERTYNAME_FONT_SIZE_DELTA, n2, n);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean bl) {
        boolean bl2 = this.isAntiAliased();
        this.antiAliased = bl;
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROPERTYNAME_ANTI_ALIASED, bl2, bl);
    }

    public void paint(Graphics graphics) {
        Object object = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAntiAliased()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paint(graphics2D);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public void updateUI() {
        super.updateUI();
        Font font = this.getFont();
        if (0 == this.getFontSizeDelta()) {
            if (font.getStyle() != this.fontStyle) {
                this.setFont(new FontUIResource(font.deriveFont(this.fontStyle)));
            }
        } else {
            this.setFont(new FontUIResource(new Font(font.getName(), this.fontStyle, font.getSize() + this.getFontSizeDelta())));
        }
    }
}

