/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.component;

import com.jgoodies.uif.util.Mode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public final class UIFMenuItem
extends JMenuItem {
    private boolean iconVisible = true;
    private Icon backedIcon;
    private Icon backedSelectedIcon;
    private Icon backedDisabledIcon;
    private Icon backedDisabledSelectedIcon;
    private Icon backedPressedIcon;
    private Icon backedRollOverIcon;
    private Icon backedRollOverSelectedIcon;
    private Mode iconVisibleMode;

    public UIFMenuItem() {
        this(null, null);
    }

    public UIFMenuItem(Icon icon) {
        this(null, icon);
    }

    public UIFMenuItem(String string) {
        this(string, null);
    }

    public UIFMenuItem(Action action) {
        super(action);
    }

    public UIFMenuItem(String string, Icon icon) {
        super(string, icon);
    }

    public UIFMenuItem(String string, int n) {
        super(string, n);
    }

    public UIFMenuItem(String string, Icon icon, int n) {
        super(string, icon);
        this.setMnemonic(n);
    }

    public boolean isIconVisible() {
        return this.iconVisible;
    }

    public void setIconVisible(boolean bl) {
        boolean bl2 = this.isIconVisible();
        if (bl2 == bl) {
            return;
        }
        this.iconVisible = bl;
        if (bl) {
            this.setIcon(this.backedIcon);
            this.setSelectedIcon(this.backedSelectedIcon);
            this.setDisabledIcon(this.backedDisabledIcon);
            this.setDisabledSelectedIcon(this.backedDisabledSelectedIcon);
            this.setPressedIcon(this.backedPressedIcon);
            this.setRolloverIcon(this.backedRollOverIcon);
            this.setRolloverSelectedIcon(this.backedRollOverSelectedIcon);
        } else {
            this.backedIcon = this.getIcon();
            this.backedSelectedIcon = this.getSelectedIcon();
            this.backedDisabledIcon = this.getDisabledIcon();
            this.backedDisabledSelectedIcon = this.getDisabledSelectedIcon();
            this.backedPressedIcon = this.getPressedIcon();
            this.backedRollOverIcon = this.getRolloverIcon();
            this.backedRollOverSelectedIcon = this.getRolloverSelectedIcon();
            this.setIcon(null);
            this.setSelectedIcon(null);
            this.setDisabledIcon(null);
            this.setDisabledSelectedIcon(null);
            this.setPressedIcon(null);
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
        }
        this.firePropertyChange("iconVisible", bl2, bl);
    }

    public Mode getIconVisibleMode() {
        return this.iconVisibleMode;
    }

    public void setIconVisibleMode(Mode mode) {
        Mode mode2 = this.getIconVisibleMode();
        this.iconVisibleMode = mode;
        if (this.getIconVisibleMode() != null) {
            this.setIconVisible(this.getIconVisibleMode().enabled());
        }
        this.firePropertyChange("iconVisibleMode", mode2, mode);
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        UIFMenuItem.setDisplayedMnemonicIndex(this, action);
    }

    public void updateUI() {
        super.updateUI();
        if (this.getIconVisibleMode() != null) {
            this.setIconVisible(this.getIconVisibleMode().enabled());
        }
    }

    public static void setDisplayedMnemonicIndex(JMenuItem jMenuItem, Action action) {
        Integer n = (Integer)action.getValue("mnemonicIndex");
        if (n == null) {
            return;
        }
        jMenuItem.setDisplayedMnemonicIndex(n);
    }

    public void setAction(Action action) {
        super.setAction(action);
        if (action != null) {
            action.addPropertyChangeListener(this.createToolTipListener(action));
        }
    }

    protected PropertyChangeListener createToolTipListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, action){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                JMenuItem jMenuItem = (JMenuItem)this.getTarget();
                if (jMenuItem == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    String string3 = jMenuItem.getToolTipText();
                    if (!(string3 != null && string3.equals(string2) || string3 == null && string2 == null)) {
                        jMenuItem.setToolTipText(string2);
                    }
                }
            }
        };
    }

    static abstract class AbstractActionPropertyChangeListener
    implements PropertyChangeListener {
        private static ReferenceQueue queue;
        private WeakReference target;
        private Action action;

        AbstractActionPropertyChangeListener(JComponent jComponent, Action action) {
            this.setTarget(jComponent);
            this.action = action;
        }

        public void setTarget(JComponent jComponent) {
            OwnedWeakReference ownedWeakReference;
            if (queue == null) {
                queue = new ReferenceQueue();
            }
            while ((ownedWeakReference = (OwnedWeakReference)queue.poll()) != null) {
                AbstractActionPropertyChangeListener abstractActionPropertyChangeListener = (AbstractActionPropertyChangeListener)ownedWeakReference.getOwner();
                Action action = abstractActionPropertyChangeListener.getAction();
                if (action == null) continue;
                action.removePropertyChangeListener(abstractActionPropertyChangeListener);
            }
            this.target = new OwnedWeakReference(jComponent, queue, this);
        }

        public JComponent getTarget() {
            return (JComponent)this.target.get();
        }

        public Action getAction() {
            return this.action;
        }

        private static class OwnedWeakReference
        extends WeakReference {
            private Object owner;

            OwnedWeakReference(Object object, ReferenceQueue referenceQueue, Object object2) {
                super(object, referenceQueue);
                this.owner = object2;
            }

            public Object getOwner() {
                return this.owner;
            }
        }
    }
}

